@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin

import com.pulumi.azurenative.importexport.kotlin.outputs.IdentityDetailsResponse
import com.pulumi.azurenative.importexport.kotlin.outputs.JobDetailsResponse
import com.pulumi.azurenative.importexport.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.importexport.kotlin.outputs.IdentityDetailsResponse.Companion.toKotlin as identityDetailsResponseToKotlin
import com.pulumi.azurenative.importexport.kotlin.outputs.JobDetailsResponse.Companion.toKotlin as jobDetailsResponseToKotlin
import com.pulumi.azurenative.importexport.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Job].
 */
@PulumiTagMarker
public class JobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobArgs = JobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobArgsBuilder.() -> Unit) {
        val builder = JobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Job {
        val builtJavaResource = com.pulumi.azurenative.importexport.Job(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Job(builtJavaResource)
    }
}

/**
 * Contains the job information.
 * Azure REST API version: 2021-01-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * ## Example Usage
 * ### Create export job
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.ImportExport.Job("job", new()
 *     {
 *         JobName = "myExportJob",
 *         Location = "West US",
 *         Properties = new AzureNative.ImportExport.Inputs.JobDetailsArgs
 *         {
 *             BackupDriveManifest = true,
 *             DiagnosticsPath = "waimportexport",
 *             Export = new AzureNative.ImportExport.Inputs.ExportArgs
 *             {
 *                 BlobPathPrefix = new[]
 *                 {
 *                     "/",
 *                 },
 *             },
 *             JobType = "Export",
 *             LogLevel = "Verbose",
 *             ReturnAddress = new AzureNative.ImportExport.Inputs.ReturnAddressArgs
 *             {
 *                 City = "Redmond",
 *                 CountryOrRegion = "USA",
 *                 Email = "Test@contoso.com",
 *                 Phone = "4250000000",
 *                 PostalCode = "98007",
 *                 RecipientName = "Test",
 *                 StateOrProvince = "wa",
 *                 StreetAddress1 = "Street1",
 *                 StreetAddress2 = "street2",
 *             },
 *             ReturnShipping = new AzureNative.ImportExport.Inputs.ReturnShippingArgs
 *             {
 *                 CarrierAccountNumber = "989ffff",
 *                 CarrierName = "FedEx",
 *             },
 *             StorageAccountId = "/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/importexport/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := importexport.NewJob(ctx, "job", &importexport.JobArgs{
 * 			JobName:  pulumi.String("myExportJob"),
 * 			Location: pulumi.String("West US"),
 * 			Properties: &importexport.JobDetailsArgs{
 * 				BackupDriveManifest: pulumi.Bool(true),
 * 				DiagnosticsPath:     pulumi.String("waimportexport"),
 * 				Export: &importexport.ExportArgs{
 * 					BlobPathPrefix: pulumi.StringArray{
 * 						pulumi.String("/"),
 * 					},
 * 				},
 * 				JobType:  pulumi.String("Export"),
 * 				LogLevel: pulumi.String("Verbose"),
 * 				ReturnAddress: &importexport.ReturnAddressArgs{
 * 					City:            pulumi.String("Redmond"),
 * 					CountryOrRegion: pulumi.String("USA"),
 * 					Email:           pulumi.String("Test@contoso.com"),
 * 					Phone:           pulumi.String("4250000000"),
 * 					PostalCode:      pulumi.String("98007"),
 * 					RecipientName:   pulumi.String("Test"),
 * 					StateOrProvince: pulumi.String("wa"),
 * 					StreetAddress1:  pulumi.String("Street1"),
 * 					StreetAddress2:  pulumi.String("street2"),
 * 				},
 * 				ReturnShipping: &importexport.ReturnShippingArgs{
 * 					CarrierAccountNumber: pulumi.String("989ffff"),
 * 					CarrierName:          pulumi.String("FedEx"),
 * 				},
 * 				StorageAccountId: pulumi.String("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.importexport.Job;
 * import com.pulumi.azurenative.importexport.JobArgs;
 * import com.pulumi.azurenative.importexport.inputs.JobDetailsArgs;
 * import com.pulumi.azurenative.importexport.inputs.ExportArgs;
 * import com.pulumi.azurenative.importexport.inputs.ReturnAddressArgs;
 * import com.pulumi.azurenative.importexport.inputs.ReturnShippingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .jobName("myExportJob")
 *             .location("West US")
 *             .properties(JobDetailsArgs.builder()
 *                 .backupDriveManifest(true)
 *                 .diagnosticsPath("waimportexport")
 *                 .export(ExportArgs.builder()
 *                     .blobPathPrefix("/")
 *                     .build())
 *                 .jobType("Export")
 *                 .logLevel("Verbose")
 *                 .returnAddress(ReturnAddressArgs.builder()
 *                     .city("Redmond")
 *                     .countryOrRegion("USA")
 *                     .email("Test@contoso.com")
 *                     .phone("4250000000")
 *                     .postalCode("98007")
 *                     .recipientName("Test")
 *                     .stateOrProvince("wa")
 *                     .streetAddress1("Street1")
 *                     .streetAddress2("street2")
 *                     .build())
 *                 .returnShipping(ReturnShippingArgs.builder()
 *                     .carrierAccountNumber("989ffff")
 *                     .carrierName("FedEx")
 *                     .build())
 *                 .storageAccountId("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create import job
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.ImportExport.Job("job", new()
 *     {
 *         JobName = "myJob",
 *         Location = "West US",
 *         Properties = new AzureNative.ImportExport.Inputs.JobDetailsArgs
 *         {
 *             BackupDriveManifest = true,
 *             DiagnosticsPath = "waimportexport",
 *             DriveList = new[]
 *             {
 *                 new AzureNative.ImportExport.Inputs.DriveStatusArgs
 *                 {
 *                     BitLockerKey = "238810-662376-448998-450120-652806-203390-606320-483076",
 *                     DriveHeaderHash = "0:1048576:FB6B6ED500D49DA6E0D723C98D42C657F2881CC13357C28DCECA6A524F1292501571A321238540E621AB5BD9C9A32637615919A75593E6CB5C1515DAE341CABF;135266304:143360:C957A189AFC38C4E80731252301EB91427CE55E61448FA3C73C6FDDE70ABBC197947EC8D0249A2C639BB10B95957D5820A4BE8DFBBF76FFFA688AE5CE0D42EC3",
 *                     DriveId = "9CA995BB",
 *                     ManifestFile = "\\8a0c23f7-14b7-470a-9633-fcd46590a1bc.manifest",
 *                     ManifestHash = "4228EC5D8E048CB9B515338C789314BE8D0B2FDBC7C7A0308E1C826242CDE74E",
 *                 },
 *             },
 *             JobType = "Import",
 *             LogLevel = "Verbose",
 *             ReturnAddress = new AzureNative.ImportExport.Inputs.ReturnAddressArgs
 *             {
 *                 City = "Redmond",
 *                 CountryOrRegion = "USA",
 *                 Email = "Test@contoso.com",
 *                 Phone = "4250000000",
 *                 PostalCode = "98007",
 *                 RecipientName = "Test",
 *                 StateOrProvince = "wa",
 *                 StreetAddress1 = "Street1",
 *                 StreetAddress2 = "street2",
 *             },
 *             ReturnShipping = new AzureNative.ImportExport.Inputs.ReturnShippingArgs
 *             {
 *                 CarrierAccountNumber = "989ffff",
 *                 CarrierName = "FedEx",
 *             },
 *             StorageAccountId = "/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/importexport/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := importexport.NewJob(ctx, "job", &importexport.JobArgs{
 * 			JobName:  pulumi.String("myJob"),
 * 			Location: pulumi.String("West US"),
 * 			Properties: &importexport.JobDetailsArgs{
 * 				BackupDriveManifest: pulumi.Bool(true),
 * 				DiagnosticsPath:     pulumi.String("waimportexport"),
 * 				DriveList: importexport.DriveStatusArray{
 * 					&importexport.DriveStatusArgs{
 * 						BitLockerKey:    pulumi.String("238810-662376-448998-450120-652806-203390-606320-483076"),
 * 						DriveHeaderHash: pulumi.String("0:1048576:FB6B6ED500D49DA6E0D723C98D42C657F2881CC13357C28DCECA6A524F1292501571A321238540E621AB5BD9C9A32637615919A75593E6CB5C1515DAE341CABF;135266304:143360:C957A189AFC38C4E80731252301EB91427CE55E61448FA3C73C6FDDE70ABBC197947EC8D0249A2C639BB10B95957D5820A4BE8DFBBF76FFFA688AE5CE0D42EC3"),
 * 						DriveId:         pulumi.String("9CA995BB"),
 * 						ManifestFile:    pulumi.String("\\8a0c23f7-14b7-470a-9633-fcd46590a1bc.manifest"),
 * 						ManifestHash:    pulumi.String("4228EC5D8E048CB9B515338C789314BE8D0B2FDBC7C7A0308E1C826242CDE74E"),
 * 					},
 * 				},
 * 				JobType:  pulumi.String("Import"),
 * 				LogLevel: pulumi.String("Verbose"),
 * 				ReturnAddress: &importexport.ReturnAddressArgs{
 * 					City:            pulumi.String("Redmond"),
 * 					CountryOrRegion: pulumi.String("USA"),
 * 					Email:           pulumi.String("Test@contoso.com"),
 * 					Phone:           pulumi.String("4250000000"),
 * 					PostalCode:      pulumi.String("98007"),
 * 					RecipientName:   pulumi.String("Test"),
 * 					StateOrProvince: pulumi.String("wa"),
 * 					StreetAddress1:  pulumi.String("Street1"),
 * 					StreetAddress2:  pulumi.String("street2"),
 * 				},
 * 				ReturnShipping: &importexport.ReturnShippingArgs{
 * 					CarrierAccountNumber: pulumi.String("989ffff"),
 * 					CarrierName:          pulumi.String("FedEx"),
 * 				},
 * 				StorageAccountId: pulumi.String("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.importexport.Job;
 * import com.pulumi.azurenative.importexport.JobArgs;
 * import com.pulumi.azurenative.importexport.inputs.JobDetailsArgs;
 * import com.pulumi.azurenative.importexport.inputs.ReturnAddressArgs;
 * import com.pulumi.azurenative.importexport.inputs.ReturnShippingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .jobName("myJob")
 *             .location("West US")
 *             .properties(JobDetailsArgs.builder()
 *                 .backupDriveManifest(true)
 *                 .diagnosticsPath("waimportexport")
 *                 .driveList(DriveStatusArgs.builder()
 *                     .bitLockerKey("238810-662376-448998-450120-652806-203390-606320-483076")
 *                     .driveHeaderHash("0:1048576:FB6B6ED500D49DA6E0D723C98D42C657F2881CC13357C28DCECA6A524F1292501571A321238540E621AB5BD9C9A32637615919A75593E6CB5C1515DAE341CABF;135266304:143360:C957A189AFC38C4E80731252301EB91427CE55E61448FA3C73C6FDDE70ABBC197947EC8D0249A2C639BB10B95957D5820A4BE8DFBBF76FFFA688AE5CE0D42EC3")
 *                     .driveId("9CA995BB")
 *                     .manifestFile("\\8a0c23f7-14b7-470a-9633-fcd46590a1bc.manifest")
 *                     .manifestHash("4228EC5D8E048CB9B515338C789314BE8D0B2FDBC7C7A0308E1C826242CDE74E")
 *                     .build())
 *                 .jobType("Import")
 *                 .logLevel("Verbose")
 *                 .returnAddress(ReturnAddressArgs.builder()
 *                     .city("Redmond")
 *                     .countryOrRegion("USA")
 *                     .email("Test@contoso.com")
 *                     .phone("4250000000")
 *                     .postalCode("98007")
 *                     .recipientName("Test")
 *                     .stateOrProvince("wa")
 *                     .streetAddress1("Street1")
 *                     .streetAddress2("street2")
 *                     .build())
 *                 .returnShipping(ReturnShippingArgs.builder()
 *                     .carrierAccountNumber("989ffff")
 *                     .carrierName("FedEx")
 *                     .build())
 *                 .storageAccountId("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:importexport:Job myJob /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ImportExport/jobs/{jobName}
 * ```
 */
public class Job internal constructor(
    override val javaResource: com.pulumi.azurenative.importexport.Job,
) : KotlinCustomResource(javaResource, JobMapper) {
    /**
     * Specifies the job identity details
     */
    public val identity: Output<IdentityDetailsResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityDetailsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the Azure location where the job is created.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the name of the job.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the job properties
     */
    public val properties: Output<JobDetailsResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                jobDetailsResponseToKotlin(args0)
            })
        })

    /**
     * SystemData of ImportExport Jobs.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Specifies the tags that are assigned to the job.
     */
    public val tags: Output<Any>?
        get() = javaResource.tags().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the type of the job resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobMapper : ResourceMapper<Job> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.importexport.Job::class == javaResource::class

    override fun map(javaResource: Resource): Job = Job(
        javaResource as
            com.pulumi.azurenative.importexport.Job,
    )
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Job].
 */
public suspend fun job(name: String, block: suspend JobResourceBuilder.() -> Unit): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 */
public fun job(name: String): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    return builder.build()
}
