@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin

import com.pulumi.azurenative.importexport.JobArgs.builder
import com.pulumi.azurenative.importexport.kotlin.inputs.JobDetailsArgs
import com.pulumi.azurenative.importexport.kotlin.inputs.JobDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Contains the job information.
 * Azure REST API version: 2021-01-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * ## Example Usage
 * ### Create export job
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.ImportExport.Job("job", new()
 *     {
 *         JobName = "myExportJob",
 *         Location = "West US",
 *         Properties = new AzureNative.ImportExport.Inputs.JobDetailsArgs
 *         {
 *             BackupDriveManifest = true,
 *             DiagnosticsPath = "waimportexport",
 *             Export = new AzureNative.ImportExport.Inputs.ExportArgs
 *             {
 *                 BlobPathPrefix = new[]
 *                 {
 *                     "/",
 *                 },
 *             },
 *             JobType = "Export",
 *             LogLevel = "Verbose",
 *             ReturnAddress = new AzureNative.ImportExport.Inputs.ReturnAddressArgs
 *             {
 *                 City = "Redmond",
 *                 CountryOrRegion = "USA",
 *                 Email = "Test@contoso.com",
 *                 Phone = "4250000000",
 *                 PostalCode = "98007",
 *                 RecipientName = "Test",
 *                 StateOrProvince = "wa",
 *                 StreetAddress1 = "Street1",
 *                 StreetAddress2 = "street2",
 *             },
 *             ReturnShipping = new AzureNative.ImportExport.Inputs.ReturnShippingArgs
 *             {
 *                 CarrierAccountNumber = "989ffff",
 *                 CarrierName = "FedEx",
 *             },
 *             StorageAccountId = "/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/importexport/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := importexport.NewJob(ctx, "job", &importexport.JobArgs{
 * 			JobName:  pulumi.String("myExportJob"),
 * 			Location: pulumi.String("West US"),
 * 			Properties: &importexport.JobDetailsArgs{
 * 				BackupDriveManifest: pulumi.Bool(true),
 * 				DiagnosticsPath:     pulumi.String("waimportexport"),
 * 				Export: &importexport.ExportArgs{
 * 					BlobPathPrefix: pulumi.StringArray{
 * 						pulumi.String("/"),
 * 					},
 * 				},
 * 				JobType:  pulumi.String("Export"),
 * 				LogLevel: pulumi.String("Verbose"),
 * 				ReturnAddress: &importexport.ReturnAddressArgs{
 * 					City:            pulumi.String("Redmond"),
 * 					CountryOrRegion: pulumi.String("USA"),
 * 					Email:           pulumi.String("Test@contoso.com"),
 * 					Phone:           pulumi.String("4250000000"),
 * 					PostalCode:      pulumi.String("98007"),
 * 					RecipientName:   pulumi.String("Test"),
 * 					StateOrProvince: pulumi.String("wa"),
 * 					StreetAddress1:  pulumi.String("Street1"),
 * 					StreetAddress2:  pulumi.String("street2"),
 * 				},
 * 				ReturnShipping: &importexport.ReturnShippingArgs{
 * 					CarrierAccountNumber: pulumi.String("989ffff"),
 * 					CarrierName:          pulumi.String("FedEx"),
 * 				},
 * 				StorageAccountId: pulumi.String("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.importexport.Job;
 * import com.pulumi.azurenative.importexport.JobArgs;
 * import com.pulumi.azurenative.importexport.inputs.JobDetailsArgs;
 * import com.pulumi.azurenative.importexport.inputs.ExportArgs;
 * import com.pulumi.azurenative.importexport.inputs.ReturnAddressArgs;
 * import com.pulumi.azurenative.importexport.inputs.ReturnShippingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .jobName("myExportJob")
 *             .location("West US")
 *             .properties(JobDetailsArgs.builder()
 *                 .backupDriveManifest(true)
 *                 .diagnosticsPath("waimportexport")
 *                 .export(ExportArgs.builder()
 *                     .blobPathPrefix("/")
 *                     .build())
 *                 .jobType("Export")
 *                 .logLevel("Verbose")
 *                 .returnAddress(ReturnAddressArgs.builder()
 *                     .city("Redmond")
 *                     .countryOrRegion("USA")
 *                     .email("Test@contoso.com")
 *                     .phone("4250000000")
 *                     .postalCode("98007")
 *                     .recipientName("Test")
 *                     .stateOrProvince("wa")
 *                     .streetAddress1("Street1")
 *                     .streetAddress2("street2")
 *                     .build())
 *                 .returnShipping(ReturnShippingArgs.builder()
 *                     .carrierAccountNumber("989ffff")
 *                     .carrierName("FedEx")
 *                     .build())
 *                 .storageAccountId("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create import job
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.ImportExport.Job("job", new()
 *     {
 *         JobName = "myJob",
 *         Location = "West US",
 *         Properties = new AzureNative.ImportExport.Inputs.JobDetailsArgs
 *         {
 *             BackupDriveManifest = true,
 *             DiagnosticsPath = "waimportexport",
 *             DriveList = new[]
 *             {
 *                 new AzureNative.ImportExport.Inputs.DriveStatusArgs
 *                 {
 *                     BitLockerKey = "238810-662376-448998-450120-652806-203390-606320-483076",
 *                     DriveHeaderHash = "0:1048576:FB6B6ED500D49DA6E0D723C98D42C657F2881CC13357C28DCECA6A524F1292501571A321238540E621AB5BD9C9A32637615919A75593E6CB5C1515DAE341CABF;135266304:143360:C957A189AFC38C4E80731252301EB91427CE55E61448FA3C73C6FDDE70ABBC197947EC8D0249A2C639BB10B95957D5820A4BE8DFBBF76FFFA688AE5CE0D42EC3",
 *                     DriveId = "9CA995BB",
 *                     ManifestFile = "\\8a0c23f7-14b7-470a-9633-fcd46590a1bc.manifest",
 *                     ManifestHash = "4228EC5D8E048CB9B515338C789314BE8D0B2FDBC7C7A0308E1C826242CDE74E",
 *                 },
 *             },
 *             JobType = "Import",
 *             LogLevel = "Verbose",
 *             ReturnAddress = new AzureNative.ImportExport.Inputs.ReturnAddressArgs
 *             {
 *                 City = "Redmond",
 *                 CountryOrRegion = "USA",
 *                 Email = "Test@contoso.com",
 *                 Phone = "4250000000",
 *                 PostalCode = "98007",
 *                 RecipientName = "Test",
 *                 StateOrProvince = "wa",
 *                 StreetAddress1 = "Street1",
 *                 StreetAddress2 = "street2",
 *             },
 *             ReturnShipping = new AzureNative.ImportExport.Inputs.ReturnShippingArgs
 *             {
 *                 CarrierAccountNumber = "989ffff",
 *                 CarrierName = "FedEx",
 *             },
 *             StorageAccountId = "/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/importexport/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := importexport.NewJob(ctx, "job", &importexport.JobArgs{
 * 			JobName:  pulumi.String("myJob"),
 * 			Location: pulumi.String("West US"),
 * 			Properties: &importexport.JobDetailsArgs{
 * 				BackupDriveManifest: pulumi.Bool(true),
 * 				DiagnosticsPath:     pulumi.String("waimportexport"),
 * 				DriveList: importexport.DriveStatusArray{
 * 					&importexport.DriveStatusArgs{
 * 						BitLockerKey:    pulumi.String("238810-662376-448998-450120-652806-203390-606320-483076"),
 * 						DriveHeaderHash: pulumi.String("0:1048576:FB6B6ED500D49DA6E0D723C98D42C657F2881CC13357C28DCECA6A524F1292501571A321238540E621AB5BD9C9A32637615919A75593E6CB5C1515DAE341CABF;135266304:143360:C957A189AFC38C4E80731252301EB91427CE55E61448FA3C73C6FDDE70ABBC197947EC8D0249A2C639BB10B95957D5820A4BE8DFBBF76FFFA688AE5CE0D42EC3"),
 * 						DriveId:         pulumi.String("9CA995BB"),
 * 						ManifestFile:    pulumi.String("\\8a0c23f7-14b7-470a-9633-fcd46590a1bc.manifest"),
 * 						ManifestHash:    pulumi.String("4228EC5D8E048CB9B515338C789314BE8D0B2FDBC7C7A0308E1C826242CDE74E"),
 * 					},
 * 				},
 * 				JobType:  pulumi.String("Import"),
 * 				LogLevel: pulumi.String("Verbose"),
 * 				ReturnAddress: &importexport.ReturnAddressArgs{
 * 					City:            pulumi.String("Redmond"),
 * 					CountryOrRegion: pulumi.String("USA"),
 * 					Email:           pulumi.String("Test@contoso.com"),
 * 					Phone:           pulumi.String("4250000000"),
 * 					PostalCode:      pulumi.String("98007"),
 * 					RecipientName:   pulumi.String("Test"),
 * 					StateOrProvince: pulumi.String("wa"),
 * 					StreetAddress1:  pulumi.String("Street1"),
 * 					StreetAddress2:  pulumi.String("street2"),
 * 				},
 * 				ReturnShipping: &importexport.ReturnShippingArgs{
 * 					CarrierAccountNumber: pulumi.String("989ffff"),
 * 					CarrierName:          pulumi.String("FedEx"),
 * 				},
 * 				StorageAccountId: pulumi.String("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.importexport.Job;
 * import com.pulumi.azurenative.importexport.JobArgs;
 * import com.pulumi.azurenative.importexport.inputs.JobDetailsArgs;
 * import com.pulumi.azurenative.importexport.inputs.ReturnAddressArgs;
 * import com.pulumi.azurenative.importexport.inputs.ReturnShippingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .jobName("myJob")
 *             .location("West US")
 *             .properties(JobDetailsArgs.builder()
 *                 .backupDriveManifest(true)
 *                 .diagnosticsPath("waimportexport")
 *                 .driveList(DriveStatusArgs.builder()
 *                     .bitLockerKey("238810-662376-448998-450120-652806-203390-606320-483076")
 *                     .driveHeaderHash("0:1048576:FB6B6ED500D49DA6E0D723C98D42C657F2881CC13357C28DCECA6A524F1292501571A321238540E621AB5BD9C9A32637615919A75593E6CB5C1515DAE341CABF;135266304:143360:C957A189AFC38C4E80731252301EB91427CE55E61448FA3C73C6FDDE70ABBC197947EC8D0249A2C639BB10B95957D5820A4BE8DFBBF76FFFA688AE5CE0D42EC3")
 *                     .driveId("9CA995BB")
 *                     .manifestFile("\\8a0c23f7-14b7-470a-9633-fcd46590a1bc.manifest")
 *                     .manifestHash("4228EC5D8E048CB9B515338C789314BE8D0B2FDBC7C7A0308E1C826242CDE74E")
 *                     .build())
 *                 .jobType("Import")
 *                 .logLevel("Verbose")
 *                 .returnAddress(ReturnAddressArgs.builder()
 *                     .city("Redmond")
 *                     .countryOrRegion("USA")
 *                     .email("Test@contoso.com")
 *                     .phone("4250000000")
 *                     .postalCode("98007")
 *                     .recipientName("Test")
 *                     .stateOrProvince("wa")
 *                     .streetAddress1("Street1")
 *                     .streetAddress2("street2")
 *                     .build())
 *                 .returnShipping(ReturnShippingArgs.builder()
 *                     .carrierAccountNumber("989ffff")
 *                     .carrierName("FedEx")
 *                     .build())
 *                 .storageAccountId("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:importexport:Job myJob /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ImportExport/jobs/{jobName}
 * ```
 * @property jobName The name of the import/export job.
 * @property location Specifies the supported Azure location where the job should be created
 * @property properties Specifies the job properties
 * @property resourceGroupName The resource group name uniquely identifies the resource group within the user subscription.
 * @property tags Specifies the tags that will be assigned to the job.
 */
public data class JobArgs(
    public val jobName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<JobDetailsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.importexport.JobArgs> {
    override fun toJava(): com.pulumi.azurenative.importexport.JobArgs =
        com.pulumi.azurenative.importexport.JobArgs.builder()
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobArgs].
 */
@PulumiTagMarker
public class JobArgsBuilder internal constructor() {
    private var jobName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<JobDetailsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Any>? = null

    /**
     * @param value The name of the import/export job.
     */
    @JvmName("cjskfbrykioacsen")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value Specifies the supported Azure location where the job should be created
     */
    @JvmName("emefdoucvotsrypj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Specifies the job properties
     */
    @JvmName("sjdvhtqdcpfevird")
    public suspend fun properties(`value`: Output<JobDetailsArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource group name uniquely identifies the resource group within the user subscription.
     */
    @JvmName("rwakwxsjvqlpubbu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the tags that will be assigned to the job.
     */
    @JvmName("kxflhesofetptqok")
    public suspend fun tags(`value`: Output<Any>) {
        this.tags = value
    }

    /**
     * @param value The name of the import/export job.
     */
    @JvmName("jtufhfqlqsgajtpu")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value Specifies the supported Azure location where the job should be created
     */
    @JvmName("ehuydwmyxkrwlxuj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Specifies the job properties
     */
    @JvmName("cqqwfxoydfowjoyv")
    public suspend fun properties(`value`: JobDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Specifies the job properties
     */
    @JvmName("jqefbqpehghuibsb")
    public suspend fun properties(argument: suspend JobDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = JobDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource group name uniquely identifies the resource group within the user subscription.
     */
    @JvmName("hirvqyoutpenweun")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the tags that will be assigned to the job.
     */
    @JvmName("tvmvxaxmgbmklxwh")
    public suspend fun tags(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): JobArgs = JobArgs(
        jobName = jobName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
