@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * BitLocker recovery key or password to the specified drive
 * @property bitLockerKey BitLocker recovery key or password
 * @property driveId Drive ID
 */
public data class DriveBitLockerKeyResponse(
    public val bitLockerKey: String? = null,
    public val driveId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.importexport.outputs.DriveBitLockerKeyResponse): DriveBitLockerKeyResponse = DriveBitLockerKeyResponse(
            bitLockerKey = javaType.bitLockerKey().map({ args0 -> args0 }).orElse(null),
            driveId = javaType.driveId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
