@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Provides information about the drive's status
 * @property bitLockerKey The BitLocker key used to encrypt the drive.
 * @property bytesSucceeded Bytes successfully transferred for the drive.
 * @property copyStatus Detailed status about the data transfer process. This field is not returned in the response until the drive is in the Transferring state.
 * @property driveHeaderHash The drive header hash value.
 * @property driveId The drive's hardware serial number, without spaces.
 * @property errorLogUri A URI that points to the blob containing the error log for the data transfer operation.
 * @property manifestFile The relative path of the manifest file on the drive.
 * @property manifestHash The Base16-encoded MD5 hash of the manifest file on the drive.
 * @property manifestUri A URI that points to the blob containing the drive manifest file.
 * @property percentComplete Percentage completed for the drive.
 * @property state The drive's current state.
 * @property verboseLogUri A URI that points to the blob containing the verbose log for the data transfer operation.
 */
public data class DriveStatusResponse(
    public val bitLockerKey: String? = null,
    public val bytesSucceeded: Double? = null,
    public val copyStatus: String? = null,
    public val driveHeaderHash: String? = null,
    public val driveId: String? = null,
    public val errorLogUri: String? = null,
    public val manifestFile: String? = null,
    public val manifestHash: String? = null,
    public val manifestUri: String? = null,
    public val percentComplete: Double? = null,
    public val state: String? = null,
    public val verboseLogUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.importexport.outputs.DriveStatusResponse): DriveStatusResponse = DriveStatusResponse(
            bitLockerKey = javaType.bitLockerKey().map({ args0 -> args0 }).orElse(null),
            bytesSucceeded = javaType.bytesSucceeded().map({ args0 -> args0 }).orElse(null),
            copyStatus = javaType.copyStatus().map({ args0 -> args0 }).orElse(null),
            driveHeaderHash = javaType.driveHeaderHash().map({ args0 -> args0 }).orElse(null),
            driveId = javaType.driveId().map({ args0 -> args0 }).orElse(null),
            errorLogUri = javaType.errorLogUri().map({ args0 -> args0 }).orElse(null),
            manifestFile = javaType.manifestFile().map({ args0 -> args0 }).orElse(null),
            manifestHash = javaType.manifestHash().map({ args0 -> args0 }).orElse(null),
            manifestUri = javaType.manifestUri().map({ args0 -> args0 }).orElse(null),
            percentComplete = javaType.percentComplete().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            verboseLogUri = javaType.verboseLogUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
