@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A property containing information about the blobs to be exported for an export job. This property is required for export jobs, but must not be specified for import jobs.
 * @property blobListBlobPath The relative URI to the block blob that contains the list of blob paths or blob path prefixes as defined above, beginning with the container name. If the blob is in root container, the URI must begin with $root.
 * @property blobPath A collection of blob-path strings.
 * @property blobPathPrefix A collection of blob-prefix strings.
 */
public data class ExportResponse(
    public val blobListBlobPath: String? = null,
    public val blobPath: List<String>? = null,
    public val blobPathPrefix: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.importexport.outputs.ExportResponse): ExportResponse = ExportResponse(
            blobListBlobPath = javaType.blobListBlobPath().map({ args0 -> args0 }).orElse(null),
            blobPath = javaType.blobPath().map({ args0 -> args0 }),
            blobPathPrefix = javaType.blobPathPrefix().map({ args0 -> args0 }),
        )
    }
}
