@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Contains the job information.
 * @property id Specifies the resource identifier of the job.
 * @property identity Specifies the job identity details
 * @property location Specifies the Azure location where the job is created.
 * @property name Specifies the name of the job.
 * @property properties Specifies the job properties
 * @property systemData SystemData of ImportExport Jobs.
 * @property tags Specifies the tags that are assigned to the job.
 * @property type Specifies the type of the job resource.
 */
public data class GetJobResult(
    public val id: String,
    public val identity: IdentityDetailsResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val properties: JobDetailsResponse,
    public val systemData: SystemDataResponse,
    public val tags: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.importexport.outputs.GetJobResult): GetJobResult = GetJobResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.importexport.kotlin.outputs.IdentityDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.importexport.kotlin.outputs.JobDetailsResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.importexport.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
