@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the identity properties.
 * @property principalId Specifies the principal id for the identity for the job.
 * @property tenantId Specifies the tenant id for the identity for the job.
 * @property type The type of identity
 */
public data class IdentityDetailsResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.importexport.outputs.IdentityDetailsResponse): IdentityDetailsResponse = IdentityDetailsResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
