@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the return address information for the job.
 * @property city The city name to use when returning the drives.
 * @property countryOrRegion The country or region to use when returning the drives.
 * @property email Email address of the recipient of the returned drives.
 * @property phone Phone number of the recipient of the returned drives.
 * @property postalCode The postal code to use when returning the drives.
 * @property recipientName The name of the recipient who will receive the hard drives when they are returned.
 * @property stateOrProvince The state or province to use when returning the drives.
 * @property streetAddress1 The first line of the street address to use when returning the drives.
 * @property streetAddress2 The second line of the street address to use when returning the drives.
 */
public data class ReturnAddressResponse(
    public val city: String,
    public val countryOrRegion: String,
    public val email: String,
    public val phone: String,
    public val postalCode: String,
    public val recipientName: String,
    public val stateOrProvince: String? = null,
    public val streetAddress1: String,
    public val streetAddress2: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.importexport.outputs.ReturnAddressResponse): ReturnAddressResponse = ReturnAddressResponse(
            city = javaType.city(),
            countryOrRegion = javaType.countryOrRegion(),
            email = javaType.email(),
            phone = javaType.phone(),
            postalCode = javaType.postalCode(),
            recipientName = javaType.recipientName(),
            stateOrProvince = javaType.stateOrProvince().map({ args0 -> args0 }).orElse(null),
            streetAddress1 = javaType.streetAddress1(),
            streetAddress2 = javaType.streetAddress2().map({ args0 -> args0 }).orElse(null),
        )
    }
}
