@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains information about the Microsoft datacenter to which the drives should be shipped.
 * @property additionalInformation Additional shipping information for customer, specific to datacenter to which customer should send their disks.
 * @property city The city name to use when returning the drives.
 * @property countryOrRegion The country or region to use when returning the drives.
 * @property phone Phone number of the recipient of the returned drives.
 * @property postalCode The postal code to use when returning the drives.
 * @property recipientName The name of the recipient who will receive the hard drives when they are returned.
 * @property stateOrProvince The state or province to use when returning the drives.
 * @property streetAddress1 The first line of the street address to use when returning the drives.
 * @property streetAddress2 The second line of the street address to use when returning the drives.
 */
public data class ShippingInformationResponse(
    public val additionalInformation: String,
    public val city: String? = null,
    public val countryOrRegion: String? = null,
    public val phone: String? = null,
    public val postalCode: String? = null,
    public val recipientName: String? = null,
    public val stateOrProvince: String? = null,
    public val streetAddress1: String? = null,
    public val streetAddress2: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.importexport.outputs.ShippingInformationResponse): ShippingInformationResponse = ShippingInformationResponse(
            additionalInformation = javaType.additionalInformation(),
            city = javaType.city().map({ args0 -> args0 }).orElse(null),
            countryOrRegion = javaType.countryOrRegion().map({ args0 -> args0 }).orElse(null),
            phone = javaType.phone().map({ args0 -> args0 }).orElse(null),
            postalCode = javaType.postalCode().map({ args0 -> args0 }).orElse(null),
            recipientName = javaType.recipientName().map({ args0 -> args0 }).orElse(null),
            stateOrProvince = javaType.stateOrProvince().map({ args0 -> args0 }).orElse(null),
            streetAddress1 = javaType.streetAddress1().map({ args0 -> args0 }).orElse(null),
            streetAddress2 = javaType.streetAddress2().map({ args0 -> args0 }).orElse(null),
        )
    }
}
