@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.ArmRoleReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.AutomationRunbookReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.AzureAppPushReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.AzureFunctionReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.EmailReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.EventHubReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.ItsmReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.LogicAppReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.SmsReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.VoiceReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.WebhookReceiverResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.insights.kotlin.outputs.ArmRoleReceiverResponse.Companion.toKotlin as armRoleReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.AutomationRunbookReceiverResponse.Companion.toKotlin as automationRunbookReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.AzureAppPushReceiverResponse.Companion.toKotlin as azureAppPushReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.AzureFunctionReceiverResponse.Companion.toKotlin as azureFunctionReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.EmailReceiverResponse.Companion.toKotlin as emailReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.EventHubReceiverResponse.Companion.toKotlin as eventHubReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.ItsmReceiverResponse.Companion.toKotlin as itsmReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.LogicAppReceiverResponse.Companion.toKotlin as logicAppReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.SmsReceiverResponse.Companion.toKotlin as smsReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.VoiceReceiverResponse.Companion.toKotlin as voiceReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.WebhookReceiverResponse.Companion.toKotlin as webhookReceiverResponseToKotlin

/**
 * Builder for [ActionGroup].
 */
@PulumiTagMarker
public class ActionGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ActionGroupArgs = ActionGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ActionGroupArgsBuilder.() -> Unit) {
        val builder = ActionGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ActionGroup {
        val builtJavaResource = com.pulumi.azurenative.insights.ActionGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ActionGroup(builtJavaResource)
    }
}

/**
 * An action group resource.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-09-01-preview.
 * ## Example Usage
 * ### Create or update an action group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var actionGroup = new AzureNative.Insights.ActionGroup("actionGroup", new()
 *     {
 *         ActionGroupName = "SampleActionGroup",
 *         ArmRoleReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.ArmRoleReceiverArgs
 *             {
 *                 Name = "Sample armRole",
 *                 RoleId = "8e3af657-a8ff-443c-a75c-2fe8c4bcb635",
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *         AutomationRunbookReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AutomationRunbookReceiverArgs
 *             {
 *                 AutomationAccountId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest",
 *                 IsGlobalRunbook = false,
 *                 Name = "testRunbook",
 *                 RunbookName = "Sample runbook",
 *                 ServiceUri = "<serviceUri>",
 *                 UseCommonAlertSchema = true,
 *                 WebhookResourceId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest/webhooks/Alert1510184037084",
 *             },
 *         },
 *         AzureAppPushReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AzureAppPushReceiverArgs
 *             {
 *                 EmailAddress = "johndoe@email.com",
 *                 Name = "Sample azureAppPush",
 *             },
 *         },
 *         AzureFunctionReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AzureFunctionReceiverArgs
 *             {
 *                 FunctionAppResourceId = "/subscriptions/5def922a-3ed4-49c1-b9fd-05ec533819a3/resourceGroups/aznsTest/providers/Microsoft.Web/sites/testFunctionApp",
 *                 FunctionName = "HttpTriggerCSharp1",
 *                 HttpTriggerUrl = "http://test.me",
 *                 Name = "Sample azureFunction",
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *         EmailReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.EmailReceiverArgs
 *             {
 *                 EmailAddress = "johndoe@email.com",
 *                 Name = "John Doe's email",
 *                 UseCommonAlertSchema = false,
 *             },
 *             new AzureNative.Insights.Inputs.EmailReceiverArgs
 *             {
 *                 EmailAddress = "janesmith@email.com",
 *                 Name = "Jane Smith's email",
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *         Enabled = true,
 *         EventHubReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.EventHubReceiverArgs
 *             {
 *                 EventHubName = "testEventHub",
 *                 EventHubNameSpace = "testEventHubNameSpace",
 *                 Name = "Sample eventHub",
 *                 SubscriptionId = "187f412d-1758-44d9-b052-169e2564721d",
 *                 TenantId = "68a4459a-ccb8-493c-b9da-dd30457d1b84",
 *             },
 *         },
 *         GroupShortName = "sample",
 *         ItsmReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.ItsmReceiverArgs
 *             {
 *                 ConnectionId = "a3b9076c-ce8e-434e-85b4-aff10cb3c8f1",
 *                 Name = "Sample itsm",
 *                 Region = "westcentralus",
 *                 TicketConfiguration = "{\"PayloadRevision\":0,\"WorkItemType\":\"Incident\",\"UseTemplate\":false,\"WorkItemData\":\"{}\",\"CreateOneWIPerCI\":false}",
 *                 WorkspaceId = "5def922a-3ed4-49c1-b9fd-05ec533819a3|55dfd1f8-7e59-4f89-bf56-4c82f5ace23c",
 *             },
 *         },
 *         Location = "Global",
 *         LogicAppReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.LogicAppReceiverArgs
 *             {
 *                 CallbackUrl = "https://prod-27.northcentralus.logic.azure.com/workflows/68e572e818e5457ba898763b7db90877/triggers/manual/paths/invoke/azns/test?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=Abpsb72UYJxPPvmDo937uzofupO5r_vIeWEx7KVHo7w",
 *                 Name = "Sample logicApp",
 *                 ResourceId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/LogicApp/providers/Microsoft.Logic/workflows/testLogicApp",
 *                 UseCommonAlertSchema = false,
 *             },
 *         },
 *         ResourceGroupName = "Default-NotificationRules",
 *         SmsReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.SmsReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "John Doe's mobile",
 *                 PhoneNumber = "1234567890",
 *             },
 *             new AzureNative.Insights.Inputs.SmsReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "Jane Smith's mobile",
 *                 PhoneNumber = "0987654321",
 *             },
 *         },
 *         Tags = null,
 *         VoiceReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.VoiceReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "Sample voice",
 *                 PhoneNumber = "1234567890",
 *             },
 *         },
 *         WebhookReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.WebhookReceiverArgs
 *             {
 *                 Name = "Sample webhook 1",
 *                 ServiceUri = "http://www.example.com/webhook1",
 *                 UseCommonAlertSchema = true,
 *             },
 *             new AzureNative.Insights.Inputs.WebhookReceiverArgs
 *             {
 *                 IdentifierUri = "http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a",
 *                 Name = "Sample webhook 2",
 *                 ObjectId = "d3bb868c-fe44-452c-aa26-769a6538c808",
 *                 ServiceUri = "http://www.example.com/webhook2",
 *                 TenantId = "68a4459a-ccb8-493c-b9da-dd30457d1b84",
 *                 UseAadAuth = true,
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewActionGroup(ctx, "actionGroup", &insights.ActionGroupArgs{
 * 			ActionGroupName: pulumi.String("SampleActionGroup"),
 * 			ArmRoleReceivers: insights.ArmRoleReceiverArray{
 * 				&insights.ArmRoleReceiverArgs{
 * 					Name:                 pulumi.String("Sample armRole"),
 * 					RoleId:               pulumi.String("8e3af657-a8ff-443c-a75c-2fe8c4bcb635"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 			},
 * 			AutomationRunbookReceivers: insights.AutomationRunbookReceiverArray{
 * 				&insights.AutomationRunbookReceiverArgs{
 * 					AutomationAccountId:  pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest"),
 * 					IsGlobalRunbook:      pulumi.Bool(false),
 * 					Name:                 pulumi.String("testRunbook"),
 * 					RunbookName:          pulumi.String("Sample runbook"),
 * 					ServiceUri:           pulumi.String("<serviceUri>"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 					WebhookResourceId:    pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest/webhooks/Alert1510184037084"),
 * 				},
 * 			},
 * 			AzureAppPushReceivers: insights.AzureAppPushReceiverArray{
 * 				&insights.AzureAppPushReceiverArgs{
 * 					EmailAddress: pulumi.String("johndoe@email.com"),
 * 					Name:         pulumi.String("Sample azureAppPush"),
 * 				},
 * 			},
 * 			AzureFunctionReceivers: insights.AzureFunctionReceiverArray{
 * 				&insights.AzureFunctionReceiverArgs{
 * 					FunctionAppResourceId: pulumi.String("/subscriptions/5def922a-3ed4-49c1-b9fd-05ec533819a3/resourceGroups/aznsTest/providers/Microsoft.Web/sites/testFunctionApp"),
 * 					FunctionName:          pulumi.String("HttpTriggerCSharp1"),
 * 					HttpTriggerUrl:        pulumi.String("http://test.me"),
 * 					Name:                  pulumi.String("Sample azureFunction"),
 * 					UseCommonAlertSchema:  pulumi.Bool(true),
 * 				},
 * 			},
 * 			EmailReceivers: insights.EmailReceiverArray{
 * 				&insights.EmailReceiverArgs{
 * 					EmailAddress:         pulumi.String("johndoe@email.com"),
 * 					Name:                 pulumi.String("John Doe's email"),
 * 					UseCommonAlertSchema: pulumi.Bool(false),
 * 				},
 * 				&insights.EmailReceiverArgs{
 * 					EmailAddress:         pulumi.String("janesmith@email.com"),
 * 					Name:                 pulumi.String("Jane Smith's email"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 			},
 * 			Enabled: pulumi.Bool(true),
 * 			EventHubReceivers: insights.EventHubReceiverArray{
 * 				&insights.EventHubReceiverArgs{
 * 					EventHubName:      pulumi.String("testEventHub"),
 * 					EventHubNameSpace: pulumi.String("testEventHubNameSpace"),
 * 					Name:              pulumi.String("Sample eventHub"),
 * 					SubscriptionId:    pulumi.String("187f412d-1758-44d9-b052-169e2564721d"),
 * 					TenantId:          pulumi.String("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
 * 				},
 * 			},
 * 			GroupShortName: pulumi.String("sample"),
 * 			ItsmReceivers: insights.ItsmReceiverArray{
 * 				&insights.ItsmReceiverArgs{
 * 					ConnectionId:        pulumi.String("a3b9076c-ce8e-434e-85b4-aff10cb3c8f1"),
 * 					Name:                pulumi.String("Sample itsm"),
 * 					Region:              pulumi.String("westcentralus"),
 * 					TicketConfiguration: pulumi.String("{\"PayloadRevision\":0,\"WorkItemType\":\"Incident\",\"UseTemplate\":false,\"WorkItemData\":\"{}\",\"CreateOneWIPerCI\":false}"),
 * 					WorkspaceId:         pulumi.String("5def922a-3ed4-49c1-b9fd-05ec533819a3|55dfd1f8-7e59-4f89-bf56-4c82f5ace23c"),
 * 				},
 * 			},
 * 			Location: pulumi.String("Global"),
 * 			LogicAppReceivers: insights.LogicAppReceiverArray{
 * 				&insights.LogicAppReceiverArgs{
 * 					CallbackUrl:          pulumi.String("https://prod-27.northcentralus.logic.azure.com/workflows/68e572e818e5457ba898763b7db90877/triggers/manual/paths/invoke/azns/test?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=Abpsb72UYJxPPvmDo937uzofupO5r_vIeWEx7KVHo7w"),
 * 					Name:                 pulumi.String("Sample logicApp"),
 * 					ResourceId:           pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/LogicApp/providers/Microsoft.Logic/workflows/testLogicApp"),
 * 					UseCommonAlertSchema: pulumi.Bool(false),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("Default-NotificationRules"),
 * 			SmsReceivers: insights.SmsReceiverArray{
 * 				&insights.SmsReceiverArgs{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("John Doe's mobile"),
 * 					PhoneNumber: pulumi.String("1234567890"),
 * 				},
 * 				&insights.SmsReceiverArgs{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("Jane Smith's mobile"),
 * 					PhoneNumber: pulumi.String("0987654321"),
 * 				},
 * 			},
 * 			Tags: nil,
 * 			VoiceReceivers: insights.VoiceReceiverArray{
 * 				&insights.VoiceReceiverArgs{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("Sample voice"),
 * 					PhoneNumber: pulumi.String("1234567890"),
 * 				},
 * 			},
 * 			WebhookReceivers: insights.WebhookReceiverArray{
 * 				&insights.WebhookReceiverArgs{
 * 					Name:                 pulumi.String("Sample webhook 1"),
 * 					ServiceUri:           pulumi.String("http://www.example.com/webhook1"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 				&insights.WebhookReceiverArgs{
 * 					IdentifierUri:        pulumi.String("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
 * 					Name:                 pulumi.String("Sample webhook 2"),
 * 					ObjectId:             pulumi.String("d3bb868c-fe44-452c-aa26-769a6538c808"),
 * 					ServiceUri:           pulumi.String("http://www.example.com/webhook2"),
 * 					TenantId:             pulumi.String("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
 * 					UseAadAuth:           pulumi.Bool(true),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ActionGroup;
 * import com.pulumi.azurenative.insights.ActionGroupArgs;
 * import com.pulumi.azurenative.insights.inputs.ArmRoleReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.AutomationRunbookReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.AzureAppPushReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.AzureFunctionReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.EmailReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.EventHubReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.ItsmReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.LogicAppReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.SmsReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.VoiceReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.WebhookReceiverArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var actionGroup = new ActionGroup("actionGroup", ActionGroupArgs.builder()
 *             .actionGroupName("SampleActionGroup")
 *             .armRoleReceivers(ArmRoleReceiverArgs.builder()
 *                 .name("Sample armRole")
 *                 .roleId("8e3af657-a8ff-443c-a75c-2fe8c4bcb635")
 *                 .useCommonAlertSchema(true)
 *                 .build())
 *             .automationRunbookReceivers(AutomationRunbookReceiverArgs.builder()
 *                 .automationAccountId("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest")
 *                 .isGlobalRunbook(false)
 *                 .name("testRunbook")
 *                 .runbookName("Sample runbook")
 *                 .serviceUri("<serviceUri>")
 *                 .useCommonAlertSchema(true)
 *                 .webhookResourceId("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest/webhooks/Alert1510184037084")
 *                 .build())
 *             .azureAppPushReceivers(AzureAppPushReceiverArgs.builder()
 *                 .emailAddress("johndoe@email.com")
 *                 .name("Sample azureAppPush")
 *                 .build())
 *             .azureFunctionReceivers(AzureFunctionReceiverArgs.builder()
 *                 .functionAppResourceId("/subscriptions/5def922a-3ed4-49c1-b9fd-05ec533819a3/resourceGroups/aznsTest/providers/Microsoft.Web/sites/testFunctionApp")
 *                 .functionName("HttpTriggerCSharp1")
 *                 .httpTriggerUrl("http://test.me")
 *                 .name("Sample azureFunction")
 *                 .useCommonAlertSchema(true)
 *                 .build())
 *             .emailReceivers(
 *                 EmailReceiverArgs.builder()
 *                     .emailAddress("johndoe@email.com")
 *                     .name("John Doe's email")
 *                     .useCommonAlertSchema(false)
 *                     .build(),
 *                 EmailReceiverArgs.builder()
 *                     .emailAddress("janesmith@email.com")
 *                     .name("Jane Smith's email")
 *                     .useCommonAlertSchema(true)
 *                     .build())
 *             .enabled(true)
 *             .eventHubReceivers(EventHubReceiverArgs.builder()
 *                 .eventHubName("testEventHub")
 *                 .eventHubNameSpace("testEventHubNameSpace")
 *                 .name("Sample eventHub")
 *                 .subscriptionId("187f412d-1758-44d9-b052-169e2564721d")
 *                 .tenantId("68a4459a-ccb8-493c-b9da-dd30457d1b84")
 *                 .build())
 *             .groupShortName("sample")
 *             .itsmReceivers(ItsmReceiverArgs.builder()
 *                 .connectionId("a3b9076c-ce8e-434e-85b4-aff10cb3c8f1")
 *                 .name("Sample itsm")
 *                 .region("westcentralus")
 *                 .ticketConfiguration("{\"PayloadRevision\":0,\"WorkItemType\":\"Incident\",\"UseTemplate\":false,\"WorkItemData\":\"{}\",\"CreateOneWIPerCI\":false}")
 *                 .workspaceId("5def922a-3ed4-49c1-b9fd-05ec533819a3|55dfd1f8-7e59-4f89-bf56-4c82f5ace23c")
 *                 .build())
 *             .location("Global")
 *             .logicAppReceivers(LogicAppReceiverArgs.builder()
 *                 .callbackUrl("https://prod-27.northcentralus.logic.azure.com/workflows/68e572e818e5457ba898763b7db90877/triggers/manual/paths/invoke/azns/test?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=Abpsb72UYJxPPvmDo937uzofupO5r_vIeWEx7KVHo7w")
 *                 .name("Sample logicApp")
 *                 .resourceId("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/LogicApp/providers/Microsoft.Logic/workflows/testLogicApp")
 *                 .useCommonAlertSchema(false)
 *                 .build())
 *             .resourceGroupName("Default-NotificationRules")
 *             .smsReceivers(
 *                 SmsReceiverArgs.builder()
 *                     .countryCode("1")
 *                     .name("John Doe's mobile")
 *                     .phoneNumber("1234567890")
 *                     .build(),
 *                 SmsReceiverArgs.builder()
 *                     .countryCode("1")
 *                     .name("Jane Smith's mobile")
 *                     .phoneNumber("0987654321")
 *                     .build())
 *             .tags()
 *             .voiceReceivers(VoiceReceiverArgs.builder()
 *                 .countryCode("1")
 *                 .name("Sample voice")
 *                 .phoneNumber("1234567890")
 *                 .build())
 *             .webhookReceivers(
 *                 WebhookReceiverArgs.builder()
 *                     .name("Sample webhook 1")
 *                     .serviceUri("http://www.example.com/webhook1")
 *                     .useCommonAlertSchema(true)
 *                     .build(),
 *                 WebhookReceiverArgs.builder()
 *                     .identifierUri("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a")
 *                     .name("Sample webhook 2")
 *                     .objectId("d3bb868c-fe44-452c-aa26-769a6538c808")
 *                     .serviceUri("http://www.example.com/webhook2")
 *                     .tenantId("68a4459a-ccb8-493c-b9da-dd30457d1b84")
 *                     .useAadAuth(true)
 *                     .useCommonAlertSchema(true)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ActionGroup SampleActionGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/actionGroups/{actionGroupName}
 * ```
 */
public class ActionGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.ActionGroup,
) : KotlinCustomResource(javaResource, ActionGroupMapper) {
    /**
     * The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    public val armRoleReceivers: Output<List<ArmRoleReceiverResponse>>?
        get() = javaResource.armRoleReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        armRoleReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The list of AutomationRunbook receivers that are part of this action group.
     */
    public val automationRunbookReceivers: Output<List<AutomationRunbookReceiverResponse>>?
        get() = javaResource.automationRunbookReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        automationRunbookReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The list of AzureAppPush receivers that are part of this action group.
     */
    public val azureAppPushReceivers: Output<List<AzureAppPushReceiverResponse>>?
        get() = javaResource.azureAppPushReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        azureAppPushReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The list of azure function receivers that are part of this action group.
     */
    public val azureFunctionReceivers: Output<List<AzureFunctionReceiverResponse>>?
        get() = javaResource.azureFunctionReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        azureFunctionReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The list of email receivers that are part of this action group.
     */
    public val emailReceivers: Output<List<EmailReceiverResponse>>?
        get() = javaResource.emailReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        emailReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * The list of event hub receivers that are part of this action group.
     */
    public val eventHubReceivers: Output<List<EventHubReceiverResponse>>?
        get() = javaResource.eventHubReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        eventHubReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The short name of the action group. This will be used in SMS messages.
     */
    public val groupShortName: Output<String>
        get() = javaResource.groupShortName().applyValue({ args0 -> args0 })

    /**
     * The list of ITSM receivers that are part of this action group.
     */
    public val itsmReceivers: Output<List<ItsmReceiverResponse>>?
        get() = javaResource.itsmReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        itsmReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The list of logic app receivers that are part of this action group.
     */
    public val logicAppReceivers: Output<List<LogicAppReceiverResponse>>?
        get() = javaResource.logicAppReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        logicAppReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of SMS receivers that are part of this action group.
     */
    public val smsReceivers: Output<List<SmsReceiverResponse>>?
        get() = javaResource.smsReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> smsReceiverResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The list of voice receivers that are part of this action group.
     */
    public val voiceReceivers: Output<List<VoiceReceiverResponse>>?
        get() = javaResource.voiceReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        voiceReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The list of webhook receivers that are part of this action group.
     */
    public val webhookReceivers: Output<List<WebhookReceiverResponse>>?
        get() = javaResource.webhookReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        webhookReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object ActionGroupMapper : ResourceMapper<ActionGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.ActionGroup::class == javaResource::class

    override fun map(javaResource: Resource): ActionGroup = ActionGroup(
        javaResource as
            com.pulumi.azurenative.insights.ActionGroup,
    )
}

/**
 * @see [ActionGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ActionGroup].
 */
public suspend fun actionGroup(name: String, block: suspend ActionGroupResourceBuilder.() -> Unit): ActionGroup {
    val builder = ActionGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ActionGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun actionGroup(name: String): ActionGroup {
    val builder = ActionGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
