@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.ActionGroupArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.ArmRoleReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.ArmRoleReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.AutomationRunbookReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.AutomationRunbookReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.AzureAppPushReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.AzureAppPushReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.AzureFunctionReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.AzureFunctionReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.EmailReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.EmailReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.EventHubReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.EventHubReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.ItsmReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.ItsmReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.LogicAppReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.LogicAppReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.SmsReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.SmsReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.VoiceReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.VoiceReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.WebhookReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.WebhookReceiverArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An action group resource.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-09-01-preview.
 * ## Example Usage
 * ### Create or update an action group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var actionGroup = new AzureNative.Insights.ActionGroup("actionGroup", new()
 *     {
 *         ActionGroupName = "SampleActionGroup",
 *         ArmRoleReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.ArmRoleReceiverArgs
 *             {
 *                 Name = "Sample armRole",
 *                 RoleId = "8e3af657-a8ff-443c-a75c-2fe8c4bcb635",
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *         AutomationRunbookReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AutomationRunbookReceiverArgs
 *             {
 *                 AutomationAccountId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest",
 *                 IsGlobalRunbook = false,
 *                 Name = "testRunbook",
 *                 RunbookName = "Sample runbook",
 *                 ServiceUri = "<serviceUri>",
 *                 UseCommonAlertSchema = true,
 *                 WebhookResourceId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest/webhooks/Alert1510184037084",
 *             },
 *         },
 *         AzureAppPushReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AzureAppPushReceiverArgs
 *             {
 *                 EmailAddress = "johndoe@email.com",
 *                 Name = "Sample azureAppPush",
 *             },
 *         },
 *         AzureFunctionReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AzureFunctionReceiverArgs
 *             {
 *                 FunctionAppResourceId = "/subscriptions/5def922a-3ed4-49c1-b9fd-05ec533819a3/resourceGroups/aznsTest/providers/Microsoft.Web/sites/testFunctionApp",
 *                 FunctionName = "HttpTriggerCSharp1",
 *                 HttpTriggerUrl = "http://test.me",
 *                 Name = "Sample azureFunction",
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *         EmailReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.EmailReceiverArgs
 *             {
 *                 EmailAddress = "johndoe@email.com",
 *                 Name = "John Doe's email",
 *                 UseCommonAlertSchema = false,
 *             },
 *             new AzureNative.Insights.Inputs.EmailReceiverArgs
 *             {
 *                 EmailAddress = "janesmith@email.com",
 *                 Name = "Jane Smith's email",
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *         Enabled = true,
 *         EventHubReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.EventHubReceiverArgs
 *             {
 *                 EventHubName = "testEventHub",
 *                 EventHubNameSpace = "testEventHubNameSpace",
 *                 Name = "Sample eventHub",
 *                 SubscriptionId = "187f412d-1758-44d9-b052-169e2564721d",
 *                 TenantId = "68a4459a-ccb8-493c-b9da-dd30457d1b84",
 *             },
 *         },
 *         GroupShortName = "sample",
 *         ItsmReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.ItsmReceiverArgs
 *             {
 *                 ConnectionId = "a3b9076c-ce8e-434e-85b4-aff10cb3c8f1",
 *                 Name = "Sample itsm",
 *                 Region = "westcentralus",
 *                 TicketConfiguration = "{\"PayloadRevision\":0,\"WorkItemType\":\"Incident\",\"UseTemplate\":false,\"WorkItemData\":\"{}\",\"CreateOneWIPerCI\":false}",
 *                 WorkspaceId = "5def922a-3ed4-49c1-b9fd-05ec533819a3|55dfd1f8-7e59-4f89-bf56-4c82f5ace23c",
 *             },
 *         },
 *         Location = "Global",
 *         LogicAppReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.LogicAppReceiverArgs
 *             {
 *                 CallbackUrl = "https://prod-27.northcentralus.logic.azure.com/workflows/68e572e818e5457ba898763b7db90877/triggers/manual/paths/invoke/azns/test?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=Abpsb72UYJxPPvmDo937uzofupO5r_vIeWEx7KVHo7w",
 *                 Name = "Sample logicApp",
 *                 ResourceId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/LogicApp/providers/Microsoft.Logic/workflows/testLogicApp",
 *                 UseCommonAlertSchema = false,
 *             },
 *         },
 *         ResourceGroupName = "Default-NotificationRules",
 *         SmsReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.SmsReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "John Doe's mobile",
 *                 PhoneNumber = "1234567890",
 *             },
 *             new AzureNative.Insights.Inputs.SmsReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "Jane Smith's mobile",
 *                 PhoneNumber = "0987654321",
 *             },
 *         },
 *         Tags = null,
 *         VoiceReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.VoiceReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "Sample voice",
 *                 PhoneNumber = "1234567890",
 *             },
 *         },
 *         WebhookReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.WebhookReceiverArgs
 *             {
 *                 Name = "Sample webhook 1",
 *                 ServiceUri = "http://www.example.com/webhook1",
 *                 UseCommonAlertSchema = true,
 *             },
 *             new AzureNative.Insights.Inputs.WebhookReceiverArgs
 *             {
 *                 IdentifierUri = "http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a",
 *                 Name = "Sample webhook 2",
 *                 ObjectId = "d3bb868c-fe44-452c-aa26-769a6538c808",
 *                 ServiceUri = "http://www.example.com/webhook2",
 *                 TenantId = "68a4459a-ccb8-493c-b9da-dd30457d1b84",
 *                 UseAadAuth = true,
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewActionGroup(ctx, "actionGroup", &insights.ActionGroupArgs{
 * 			ActionGroupName: pulumi.String("SampleActionGroup"),
 * 			ArmRoleReceivers: insights.ArmRoleReceiverArray{
 * 				&insights.ArmRoleReceiverArgs{
 * 					Name:                 pulumi.String("Sample armRole"),
 * 					RoleId:               pulumi.String("8e3af657-a8ff-443c-a75c-2fe8c4bcb635"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 			},
 * 			AutomationRunbookReceivers: insights.AutomationRunbookReceiverArray{
 * 				&insights.AutomationRunbookReceiverArgs{
 * 					AutomationAccountId:  pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest"),
 * 					IsGlobalRunbook:      pulumi.Bool(false),
 * 					Name:                 pulumi.String("testRunbook"),
 * 					RunbookName:          pulumi.String("Sample runbook"),
 * 					ServiceUri:           pulumi.String("<serviceUri>"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 					WebhookResourceId:    pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest/webhooks/Alert1510184037084"),
 * 				},
 * 			},
 * 			AzureAppPushReceivers: insights.AzureAppPushReceiverArray{
 * 				&insights.AzureAppPushReceiverArgs{
 * 					EmailAddress: pulumi.String("johndoe@email.com"),
 * 					Name:         pulumi.String("Sample azureAppPush"),
 * 				},
 * 			},
 * 			AzureFunctionReceivers: insights.AzureFunctionReceiverArray{
 * 				&insights.AzureFunctionReceiverArgs{
 * 					FunctionAppResourceId: pulumi.String("/subscriptions/5def922a-3ed4-49c1-b9fd-05ec533819a3/resourceGroups/aznsTest/providers/Microsoft.Web/sites/testFunctionApp"),
 * 					FunctionName:          pulumi.String("HttpTriggerCSharp1"),
 * 					HttpTriggerUrl:        pulumi.String("http://test.me"),
 * 					Name:                  pulumi.String("Sample azureFunction"),
 * 					UseCommonAlertSchema:  pulumi.Bool(true),
 * 				},
 * 			},
 * 			EmailReceivers: insights.EmailReceiverArray{
 * 				&insights.EmailReceiverArgs{
 * 					EmailAddress:         pulumi.String("johndoe@email.com"),
 * 					Name:                 pulumi.String("John Doe's email"),
 * 					UseCommonAlertSchema: pulumi.Bool(false),
 * 				},
 * 				&insights.EmailReceiverArgs{
 * 					EmailAddress:         pulumi.String("janesmith@email.com"),
 * 					Name:                 pulumi.String("Jane Smith's email"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 			},
 * 			Enabled: pulumi.Bool(true),
 * 			EventHubReceivers: insights.EventHubReceiverArray{
 * 				&insights.EventHubReceiverArgs{
 * 					EventHubName:      pulumi.String("testEventHub"),
 * 					EventHubNameSpace: pulumi.String("testEventHubNameSpace"),
 * 					Name:              pulumi.String("Sample eventHub"),
 * 					SubscriptionId:    pulumi.String("187f412d-1758-44d9-b052-169e2564721d"),
 * 					TenantId:          pulumi.String("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
 * 				},
 * 			},
 * 			GroupShortName: pulumi.String("sample"),
 * 			ItsmReceivers: insights.ItsmReceiverArray{
 * 				&insights.ItsmReceiverArgs{
 * 					ConnectionId:        pulumi.String("a3b9076c-ce8e-434e-85b4-aff10cb3c8f1"),
 * 					Name:                pulumi.String("Sample itsm"),
 * 					Region:              pulumi.String("westcentralus"),
 * 					TicketConfiguration: pulumi.String("{\"PayloadRevision\":0,\"WorkItemType\":\"Incident\",\"UseTemplate\":false,\"WorkItemData\":\"{}\",\"CreateOneWIPerCI\":false}"),
 * 					WorkspaceId:         pulumi.String("5def922a-3ed4-49c1-b9fd-05ec533819a3|55dfd1f8-7e59-4f89-bf56-4c82f5ace23c"),
 * 				},
 * 			},
 * 			Location: pulumi.String("Global"),
 * 			LogicAppReceivers: insights.LogicAppReceiverArray{
 * 				&insights.LogicAppReceiverArgs{
 * 					CallbackUrl:          pulumi.String("https://prod-27.northcentralus.logic.azure.com/workflows/68e572e818e5457ba898763b7db90877/triggers/manual/paths/invoke/azns/test?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=Abpsb72UYJxPPvmDo937uzofupO5r_vIeWEx7KVHo7w"),
 * 					Name:                 pulumi.String("Sample logicApp"),
 * 					ResourceId:           pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/LogicApp/providers/Microsoft.Logic/workflows/testLogicApp"),
 * 					UseCommonAlertSchema: pulumi.Bool(false),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("Default-NotificationRules"),
 * 			SmsReceivers: insights.SmsReceiverArray{
 * 				&insights.SmsReceiverArgs{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("John Doe's mobile"),
 * 					PhoneNumber: pulumi.String("1234567890"),
 * 				},
 * 				&insights.SmsReceiverArgs{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("Jane Smith's mobile"),
 * 					PhoneNumber: pulumi.String("0987654321"),
 * 				},
 * 			},
 * 			Tags: nil,
 * 			VoiceReceivers: insights.VoiceReceiverArray{
 * 				&insights.VoiceReceiverArgs{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("Sample voice"),
 * 					PhoneNumber: pulumi.String("1234567890"),
 * 				},
 * 			},
 * 			WebhookReceivers: insights.WebhookReceiverArray{
 * 				&insights.WebhookReceiverArgs{
 * 					Name:                 pulumi.String("Sample webhook 1"),
 * 					ServiceUri:           pulumi.String("http://www.example.com/webhook1"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 				&insights.WebhookReceiverArgs{
 * 					IdentifierUri:        pulumi.String("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
 * 					Name:                 pulumi.String("Sample webhook 2"),
 * 					ObjectId:             pulumi.String("d3bb868c-fe44-452c-aa26-769a6538c808"),
 * 					ServiceUri:           pulumi.String("http://www.example.com/webhook2"),
 * 					TenantId:             pulumi.String("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
 * 					UseAadAuth:           pulumi.Bool(true),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ActionGroup;
 * import com.pulumi.azurenative.insights.ActionGroupArgs;
 * import com.pulumi.azurenative.insights.inputs.ArmRoleReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.AutomationRunbookReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.AzureAppPushReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.AzureFunctionReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.EmailReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.EventHubReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.ItsmReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.LogicAppReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.SmsReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.VoiceReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.WebhookReceiverArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var actionGroup = new ActionGroup("actionGroup", ActionGroupArgs.builder()
 *             .actionGroupName("SampleActionGroup")
 *             .armRoleReceivers(ArmRoleReceiverArgs.builder()
 *                 .name("Sample armRole")
 *                 .roleId("8e3af657-a8ff-443c-a75c-2fe8c4bcb635")
 *                 .useCommonAlertSchema(true)
 *                 .build())
 *             .automationRunbookReceivers(AutomationRunbookReceiverArgs.builder()
 *                 .automationAccountId("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest")
 *                 .isGlobalRunbook(false)
 *                 .name("testRunbook")
 *                 .runbookName("Sample runbook")
 *                 .serviceUri("<serviceUri>")
 *                 .useCommonAlertSchema(true)
 *                 .webhookResourceId("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest/webhooks/Alert1510184037084")
 *                 .build())
 *             .azureAppPushReceivers(AzureAppPushReceiverArgs.builder()
 *                 .emailAddress("johndoe@email.com")
 *                 .name("Sample azureAppPush")
 *                 .build())
 *             .azureFunctionReceivers(AzureFunctionReceiverArgs.builder()
 *                 .functionAppResourceId("/subscriptions/5def922a-3ed4-49c1-b9fd-05ec533819a3/resourceGroups/aznsTest/providers/Microsoft.Web/sites/testFunctionApp")
 *                 .functionName("HttpTriggerCSharp1")
 *                 .httpTriggerUrl("http://test.me")
 *                 .name("Sample azureFunction")
 *                 .useCommonAlertSchema(true)
 *                 .build())
 *             .emailReceivers(
 *                 EmailReceiverArgs.builder()
 *                     .emailAddress("johndoe@email.com")
 *                     .name("John Doe's email")
 *                     .useCommonAlertSchema(false)
 *                     .build(),
 *                 EmailReceiverArgs.builder()
 *                     .emailAddress("janesmith@email.com")
 *                     .name("Jane Smith's email")
 *                     .useCommonAlertSchema(true)
 *                     .build())
 *             .enabled(true)
 *             .eventHubReceivers(EventHubReceiverArgs.builder()
 *                 .eventHubName("testEventHub")
 *                 .eventHubNameSpace("testEventHubNameSpace")
 *                 .name("Sample eventHub")
 *                 .subscriptionId("187f412d-1758-44d9-b052-169e2564721d")
 *                 .tenantId("68a4459a-ccb8-493c-b9da-dd30457d1b84")
 *                 .build())
 *             .groupShortName("sample")
 *             .itsmReceivers(ItsmReceiverArgs.builder()
 *                 .connectionId("a3b9076c-ce8e-434e-85b4-aff10cb3c8f1")
 *                 .name("Sample itsm")
 *                 .region("westcentralus")
 *                 .ticketConfiguration("{\"PayloadRevision\":0,\"WorkItemType\":\"Incident\",\"UseTemplate\":false,\"WorkItemData\":\"{}\",\"CreateOneWIPerCI\":false}")
 *                 .workspaceId("5def922a-3ed4-49c1-b9fd-05ec533819a3|55dfd1f8-7e59-4f89-bf56-4c82f5ace23c")
 *                 .build())
 *             .location("Global")
 *             .logicAppReceivers(LogicAppReceiverArgs.builder()
 *                 .callbackUrl("https://prod-27.northcentralus.logic.azure.com/workflows/68e572e818e5457ba898763b7db90877/triggers/manual/paths/invoke/azns/test?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=Abpsb72UYJxPPvmDo937uzofupO5r_vIeWEx7KVHo7w")
 *                 .name("Sample logicApp")
 *                 .resourceId("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/LogicApp/providers/Microsoft.Logic/workflows/testLogicApp")
 *                 .useCommonAlertSchema(false)
 *                 .build())
 *             .resourceGroupName("Default-NotificationRules")
 *             .smsReceivers(
 *                 SmsReceiverArgs.builder()
 *                     .countryCode("1")
 *                     .name("John Doe's mobile")
 *                     .phoneNumber("1234567890")
 *                     .build(),
 *                 SmsReceiverArgs.builder()
 *                     .countryCode("1")
 *                     .name("Jane Smith's mobile")
 *                     .phoneNumber("0987654321")
 *                     .build())
 *             .tags()
 *             .voiceReceivers(VoiceReceiverArgs.builder()
 *                 .countryCode("1")
 *                 .name("Sample voice")
 *                 .phoneNumber("1234567890")
 *                 .build())
 *             .webhookReceivers(
 *                 WebhookReceiverArgs.builder()
 *                     .name("Sample webhook 1")
 *                     .serviceUri("http://www.example.com/webhook1")
 *                     .useCommonAlertSchema(true)
 *                     .build(),
 *                 WebhookReceiverArgs.builder()
 *                     .identifierUri("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a")
 *                     .name("Sample webhook 2")
 *                     .objectId("d3bb868c-fe44-452c-aa26-769a6538c808")
 *                     .serviceUri("http://www.example.com/webhook2")
 *                     .tenantId("68a4459a-ccb8-493c-b9da-dd30457d1b84")
 *                     .useAadAuth(true)
 *                     .useCommonAlertSchema(true)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ActionGroup SampleActionGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/actionGroups/{actionGroupName}
 * ```
 * @property actionGroupName The name of the action group.
 * @property armRoleReceivers The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
 * @property automationRunbookReceivers The list of AutomationRunbook receivers that are part of this action group.
 * @property azureAppPushReceivers The list of AzureAppPush receivers that are part of this action group.
 * @property azureFunctionReceivers The list of azure function receivers that are part of this action group.
 * @property emailReceivers The list of email receivers that are part of this action group.
 * @property enabled Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications.
 * @property eventHubReceivers The list of event hub receivers that are part of this action group.
 * @property groupShortName The short name of the action group. This will be used in SMS messages.
 * @property itsmReceivers The list of ITSM receivers that are part of this action group.
 * @property location Resource location
 * @property logicAppReceivers The list of logic app receivers that are part of this action group.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property smsReceivers The list of SMS receivers that are part of this action group.
 * @property tags Resource tags
 * @property voiceReceivers The list of voice receivers that are part of this action group.
 * @property webhookReceivers The list of webhook receivers that are part of this action group.
 */
public data class ActionGroupArgs(
    public val actionGroupName: Output<String>? = null,
    public val armRoleReceivers: Output<List<ArmRoleReceiverArgs>>? = null,
    public val automationRunbookReceivers: Output<List<AutomationRunbookReceiverArgs>>? = null,
    public val azureAppPushReceivers: Output<List<AzureAppPushReceiverArgs>>? = null,
    public val azureFunctionReceivers: Output<List<AzureFunctionReceiverArgs>>? = null,
    public val emailReceivers: Output<List<EmailReceiverArgs>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val eventHubReceivers: Output<List<EventHubReceiverArgs>>? = null,
    public val groupShortName: Output<String>? = null,
    public val itsmReceivers: Output<List<ItsmReceiverArgs>>? = null,
    public val location: Output<String>? = null,
    public val logicAppReceivers: Output<List<LogicAppReceiverArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val smsReceivers: Output<List<SmsReceiverArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val voiceReceivers: Output<List<VoiceReceiverArgs>>? = null,
    public val webhookReceivers: Output<List<WebhookReceiverArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.ActionGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.ActionGroupArgs =
        com.pulumi.azurenative.insights.ActionGroupArgs.builder()
            .actionGroupName(actionGroupName?.applyValue({ args0 -> args0 }))
            .armRoleReceivers(
                armRoleReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .automationRunbookReceivers(
                automationRunbookReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureAppPushReceivers(
                azureAppPushReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureFunctionReceivers(
                azureFunctionReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .emailReceivers(
                emailReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .eventHubReceivers(
                eventHubReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .groupShortName(groupShortName?.applyValue({ args0 -> args0 }))
            .itsmReceivers(
                itsmReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .logicAppReceivers(
                logicAppReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .smsReceivers(
                smsReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .voiceReceivers(
                voiceReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .webhookReceivers(
                webhookReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ActionGroupArgs].
 */
@PulumiTagMarker
public class ActionGroupArgsBuilder internal constructor() {
    private var actionGroupName: Output<String>? = null

    private var armRoleReceivers: Output<List<ArmRoleReceiverArgs>>? = null

    private var automationRunbookReceivers: Output<List<AutomationRunbookReceiverArgs>>? = null

    private var azureAppPushReceivers: Output<List<AzureAppPushReceiverArgs>>? = null

    private var azureFunctionReceivers: Output<List<AzureFunctionReceiverArgs>>? = null

    private var emailReceivers: Output<List<EmailReceiverArgs>>? = null

    private var enabled: Output<Boolean>? = null

    private var eventHubReceivers: Output<List<EventHubReceiverArgs>>? = null

    private var groupShortName: Output<String>? = null

    private var itsmReceivers: Output<List<ItsmReceiverArgs>>? = null

    private var location: Output<String>? = null

    private var logicAppReceivers: Output<List<LogicAppReceiverArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var smsReceivers: Output<List<SmsReceiverArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var voiceReceivers: Output<List<VoiceReceiverArgs>>? = null

    private var webhookReceivers: Output<List<WebhookReceiverArgs>>? = null

    /**
     * @param value The name of the action group.
     */
    @JvmName("lstyshjutisebstr")
    public suspend fun actionGroupName(`value`: Output<String>) {
        this.actionGroupName = value
    }

    /**
     * @param value The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("yhxhmotiapflnuuv")
    public suspend fun armRoleReceivers(`value`: Output<List<ArmRoleReceiverArgs>>) {
        this.armRoleReceivers = value
    }

    @JvmName("whxmtoglenvqjcdi")
    public suspend fun armRoleReceivers(vararg values: Output<ArmRoleReceiverArgs>) {
        this.armRoleReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("ucneigffbshepele")
    public suspend fun armRoleReceivers(values: List<Output<ArmRoleReceiverArgs>>) {
        this.armRoleReceivers = Output.all(values)
    }

    /**
     * @param value The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("nhkmnsrtbqnigsqu")
    public suspend fun automationRunbookReceivers(`value`: Output<List<AutomationRunbookReceiverArgs>>) {
        this.automationRunbookReceivers = value
    }

    @JvmName("pmvabmhehxqrqelm")
    public suspend fun automationRunbookReceivers(vararg values: Output<AutomationRunbookReceiverArgs>) {
        this.automationRunbookReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("pgqyyloxshsluglo")
    public suspend fun automationRunbookReceivers(values: List<Output<AutomationRunbookReceiverArgs>>) {
        this.automationRunbookReceivers = Output.all(values)
    }

    /**
     * @param value The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("gmrksrdswepabydd")
    public suspend fun azureAppPushReceivers(`value`: Output<List<AzureAppPushReceiverArgs>>) {
        this.azureAppPushReceivers = value
    }

    @JvmName("qblpjnctphmgrtpx")
    public suspend fun azureAppPushReceivers(vararg values: Output<AzureAppPushReceiverArgs>) {
        this.azureAppPushReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("yxgtsbmdcldvrurl")
    public suspend fun azureAppPushReceivers(values: List<Output<AzureAppPushReceiverArgs>>) {
        this.azureAppPushReceivers = Output.all(values)
    }

    /**
     * @param value The list of azure function receivers that are part of this action group.
     */
    @JvmName("pvcqskjsxflqmubb")
    public suspend fun azureFunctionReceivers(`value`: Output<List<AzureFunctionReceiverArgs>>) {
        this.azureFunctionReceivers = value
    }

    @JvmName("yupdcnmwlvgqirth")
    public suspend fun azureFunctionReceivers(vararg values: Output<AzureFunctionReceiverArgs>) {
        this.azureFunctionReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of azure function receivers that are part of this action group.
     */
    @JvmName("snwybtaugkbublvl")
    public suspend fun azureFunctionReceivers(values: List<Output<AzureFunctionReceiverArgs>>) {
        this.azureFunctionReceivers = Output.all(values)
    }

    /**
     * @param value The list of email receivers that are part of this action group.
     */
    @JvmName("jbtecvnnnxhjpfgl")
    public suspend fun emailReceivers(`value`: Output<List<EmailReceiverArgs>>) {
        this.emailReceivers = value
    }

    @JvmName("rvqvmcgujgqslcbc")
    public suspend fun emailReceivers(vararg values: Output<EmailReceiverArgs>) {
        this.emailReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of email receivers that are part of this action group.
     */
    @JvmName("blxxwqkofbjocyov")
    public suspend fun emailReceivers(values: List<Output<EmailReceiverArgs>>) {
        this.emailReceivers = Output.all(values)
    }

    /**
     * @param value Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications.
     */
    @JvmName("dqwmgdwrcmvxnwyi")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The list of event hub receivers that are part of this action group.
     */
    @JvmName("kfrkaoiousirqtqh")
    public suspend fun eventHubReceivers(`value`: Output<List<EventHubReceiverArgs>>) {
        this.eventHubReceivers = value
    }

    @JvmName("gsxjcejkuxxhxwbf")
    public suspend fun eventHubReceivers(vararg values: Output<EventHubReceiverArgs>) {
        this.eventHubReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of event hub receivers that are part of this action group.
     */
    @JvmName("ylqffsqlxbrpucie")
    public suspend fun eventHubReceivers(values: List<Output<EventHubReceiverArgs>>) {
        this.eventHubReceivers = Output.all(values)
    }

    /**
     * @param value The short name of the action group. This will be used in SMS messages.
     */
    @JvmName("jyxfhttdirrikwrk")
    public suspend fun groupShortName(`value`: Output<String>) {
        this.groupShortName = value
    }

    /**
     * @param value The list of ITSM receivers that are part of this action group.
     */
    @JvmName("yfhsaymfgrefrrkv")
    public suspend fun itsmReceivers(`value`: Output<List<ItsmReceiverArgs>>) {
        this.itsmReceivers = value
    }

    @JvmName("hcyknntpxdhwkpaf")
    public suspend fun itsmReceivers(vararg values: Output<ItsmReceiverArgs>) {
        this.itsmReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of ITSM receivers that are part of this action group.
     */
    @JvmName("awdsptkkllolmbpd")
    public suspend fun itsmReceivers(values: List<Output<ItsmReceiverArgs>>) {
        this.itsmReceivers = Output.all(values)
    }

    /**
     * @param value Resource location
     */
    @JvmName("lehgtpmenbrlgwkq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The list of logic app receivers that are part of this action group.
     */
    @JvmName("ejuwbktuxfykcuwj")
    public suspend fun logicAppReceivers(`value`: Output<List<LogicAppReceiverArgs>>) {
        this.logicAppReceivers = value
    }

    @JvmName("fsrplqchtlknmael")
    public suspend fun logicAppReceivers(vararg values: Output<LogicAppReceiverArgs>) {
        this.logicAppReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of logic app receivers that are part of this action group.
     */
    @JvmName("opogtvxmaanhhiyw")
    public suspend fun logicAppReceivers(values: List<Output<LogicAppReceiverArgs>>) {
        this.logicAppReceivers = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kyowoxlhwwcavvso")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The list of SMS receivers that are part of this action group.
     */
    @JvmName("qbcpjaakltqkasip")
    public suspend fun smsReceivers(`value`: Output<List<SmsReceiverArgs>>) {
        this.smsReceivers = value
    }

    @JvmName("fynnmspjdxkyelxi")
    public suspend fun smsReceivers(vararg values: Output<SmsReceiverArgs>) {
        this.smsReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of SMS receivers that are part of this action group.
     */
    @JvmName("exfpmolmetbguxrx")
    public suspend fun smsReceivers(values: List<Output<SmsReceiverArgs>>) {
        this.smsReceivers = Output.all(values)
    }

    /**
     * @param value Resource tags
     */
    @JvmName("erlxdjmlxhuxpyhh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The list of voice receivers that are part of this action group.
     */
    @JvmName("nkptqoplonkbvxsj")
    public suspend fun voiceReceivers(`value`: Output<List<VoiceReceiverArgs>>) {
        this.voiceReceivers = value
    }

    @JvmName("thliyqeuwdgxbyvl")
    public suspend fun voiceReceivers(vararg values: Output<VoiceReceiverArgs>) {
        this.voiceReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of voice receivers that are part of this action group.
     */
    @JvmName("chlnpkrpurniijno")
    public suspend fun voiceReceivers(values: List<Output<VoiceReceiverArgs>>) {
        this.voiceReceivers = Output.all(values)
    }

    /**
     * @param value The list of webhook receivers that are part of this action group.
     */
    @JvmName("cgjxikupqnvfnvsr")
    public suspend fun webhookReceivers(`value`: Output<List<WebhookReceiverArgs>>) {
        this.webhookReceivers = value
    }

    @JvmName("jtdbvxtdrrpgpqxe")
    public suspend fun webhookReceivers(vararg values: Output<WebhookReceiverArgs>) {
        this.webhookReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of webhook receivers that are part of this action group.
     */
    @JvmName("xrcjmqbgdoojuxtt")
    public suspend fun webhookReceivers(values: List<Output<WebhookReceiverArgs>>) {
        this.webhookReceivers = Output.all(values)
    }

    /**
     * @param value The name of the action group.
     */
    @JvmName("gncjkmpkxnlkvccr")
    public suspend fun actionGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionGroupName = mapped
    }

    /**
     * @param value The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("pmhvdijdiabhldrc")
    public suspend fun armRoleReceivers(`value`: List<ArmRoleReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.armRoleReceivers = mapped
    }

    /**
     * @param argument The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("vodskolubkyyrwui")
    public suspend fun armRoleReceivers(argument: List<suspend ArmRoleReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ArmRoleReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.armRoleReceivers = mapped
    }

    /**
     * @param argument The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("ujcwavfrdrspvbct")
    public suspend fun armRoleReceivers(vararg argument: suspend ArmRoleReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ArmRoleReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.armRoleReceivers = mapped
    }

    /**
     * @param argument The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("kprsngthqlslsmja")
    public suspend fun armRoleReceivers(argument: suspend ArmRoleReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ArmRoleReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.armRoleReceivers = mapped
    }

    /**
     * @param values The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("omcnyvslemmqjpmt")
    public suspend fun armRoleReceivers(vararg values: ArmRoleReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.armRoleReceivers = mapped
    }

    /**
     * @param value The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("rsbqwosfhrxwfhqc")
    public suspend fun automationRunbookReceivers(`value`: List<AutomationRunbookReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationRunbookReceivers = mapped
    }

    /**
     * @param argument The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("qcejjdnfwmjdutdg")
    public suspend fun automationRunbookReceivers(argument: List<suspend AutomationRunbookReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRunbookReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.automationRunbookReceivers = mapped
    }

    /**
     * @param argument The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("kcvgncfkqttkjbih")
    public suspend fun automationRunbookReceivers(vararg argument: suspend AutomationRunbookReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutomationRunbookReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.automationRunbookReceivers = mapped
    }

    /**
     * @param argument The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("hhtxxohlidypgtph")
    public suspend fun automationRunbookReceivers(argument: suspend AutomationRunbookReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRunbookReceiverArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.automationRunbookReceivers = mapped
    }

    /**
     * @param values The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("bnksmcxwbcppoohi")
    public suspend fun automationRunbookReceivers(vararg values: AutomationRunbookReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.automationRunbookReceivers = mapped
    }

    /**
     * @param value The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("uenwskguwjrxowty")
    public suspend fun azureAppPushReceivers(`value`: List<AzureAppPushReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param argument The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("eoklruomsqjmgptx")
    public suspend fun azureAppPushReceivers(argument: List<suspend AzureAppPushReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureAppPushReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param argument The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("ecgmiwhaxpsdswrl")
    public suspend fun azureAppPushReceivers(vararg argument: suspend AzureAppPushReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AzureAppPushReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param argument The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("yqyinrjxjdxknfpq")
    public suspend fun azureAppPushReceivers(argument: suspend AzureAppPushReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AzureAppPushReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param values The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("irmhfxnxhxxlwsgv")
    public suspend fun azureAppPushReceivers(vararg values: AzureAppPushReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param value The list of azure function receivers that are part of this action group.
     */
    @JvmName("lyminrppldqymmsw")
    public suspend fun azureFunctionReceivers(`value`: List<AzureFunctionReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFunctionReceivers = mapped
    }

    /**
     * @param argument The list of azure function receivers that are part of this action group.
     */
    @JvmName("vhoxvnthoayerbeg")
    public suspend fun azureFunctionReceivers(argument: List<suspend AzureFunctionReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureFunctionReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.azureFunctionReceivers = mapped
    }

    /**
     * @param argument The list of azure function receivers that are part of this action group.
     */
    @JvmName("qejvwkmtfryngeui")
    public suspend fun azureFunctionReceivers(vararg argument: suspend AzureFunctionReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AzureFunctionReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.azureFunctionReceivers = mapped
    }

    /**
     * @param argument The list of azure function receivers that are part of this action group.
     */
    @JvmName("tfpbjfkotealvjsg")
    public suspend fun azureFunctionReceivers(argument: suspend AzureFunctionReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AzureFunctionReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.azureFunctionReceivers = mapped
    }

    /**
     * @param values The list of azure function receivers that are part of this action group.
     */
    @JvmName("vnecgqlpviepwlyh")
    public suspend fun azureFunctionReceivers(vararg values: AzureFunctionReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureFunctionReceivers = mapped
    }

    /**
     * @param value The list of email receivers that are part of this action group.
     */
    @JvmName("feyftcqjdfvdapsi")
    public suspend fun emailReceivers(`value`: List<EmailReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailReceivers = mapped
    }

    /**
     * @param argument The list of email receivers that are part of this action group.
     */
    @JvmName("pjtvtthnvfamypag")
    public suspend fun emailReceivers(argument: List<suspend EmailReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EmailReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.emailReceivers = mapped
    }

    /**
     * @param argument The list of email receivers that are part of this action group.
     */
    @JvmName("hblknccrlugxagbb")
    public suspend fun emailReceivers(vararg argument: suspend EmailReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EmailReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.emailReceivers = mapped
    }

    /**
     * @param argument The list of email receivers that are part of this action group.
     */
    @JvmName("tbxdwsakswhnvdwi")
    public suspend fun emailReceivers(argument: suspend EmailReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EmailReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.emailReceivers = mapped
    }

    /**
     * @param values The list of email receivers that are part of this action group.
     */
    @JvmName("owpxyahxboxvoblp")
    public suspend fun emailReceivers(vararg values: EmailReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailReceivers = mapped
    }

    /**
     * @param value Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications.
     */
    @JvmName("frwtxcqkofeskdjw")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The list of event hub receivers that are part of this action group.
     */
    @JvmName("lfuoceplweudcapv")
    public suspend fun eventHubReceivers(`value`: List<EventHubReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubReceivers = mapped
    }

    /**
     * @param argument The list of event hub receivers that are part of this action group.
     */
    @JvmName("ryqjjrmdgfhfnpbl")
    public suspend fun eventHubReceivers(argument: List<suspend EventHubReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventHubReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHubReceivers = mapped
    }

    /**
     * @param argument The list of event hub receivers that are part of this action group.
     */
    @JvmName("acrylkovrqnrjvjy")
    public suspend fun eventHubReceivers(vararg argument: suspend EventHubReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventHubReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHubReceivers = mapped
    }

    /**
     * @param argument The list of event hub receivers that are part of this action group.
     */
    @JvmName("vafhbteqnqilwlqp")
    public suspend fun eventHubReceivers(argument: suspend EventHubReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EventHubReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.eventHubReceivers = mapped
    }

    /**
     * @param values The list of event hub receivers that are part of this action group.
     */
    @JvmName("rqbfsrftrjlbdxof")
    public suspend fun eventHubReceivers(vararg values: EventHubReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubReceivers = mapped
    }

    /**
     * @param value The short name of the action group. This will be used in SMS messages.
     */
    @JvmName("tnbufebifbavqaee")
    public suspend fun groupShortName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupShortName = mapped
    }

    /**
     * @param value The list of ITSM receivers that are part of this action group.
     */
    @JvmName("gbfewleuqdyfhpdy")
    public suspend fun itsmReceivers(`value`: List<ItsmReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.itsmReceivers = mapped
    }

    /**
     * @param argument The list of ITSM receivers that are part of this action group.
     */
    @JvmName("atghwenexqckcwdi")
    public suspend fun itsmReceivers(argument: List<suspend ItsmReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ItsmReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.itsmReceivers = mapped
    }

    /**
     * @param argument The list of ITSM receivers that are part of this action group.
     */
    @JvmName("sjmcqksnqaleekfp")
    public suspend fun itsmReceivers(vararg argument: suspend ItsmReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ItsmReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.itsmReceivers = mapped
    }

    /**
     * @param argument The list of ITSM receivers that are part of this action group.
     */
    @JvmName("vcmnqvsbqjfppcin")
    public suspend fun itsmReceivers(argument: suspend ItsmReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ItsmReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.itsmReceivers = mapped
    }

    /**
     * @param values The list of ITSM receivers that are part of this action group.
     */
    @JvmName("urnwbkuixpxuqjhl")
    public suspend fun itsmReceivers(vararg values: ItsmReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.itsmReceivers = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("amygbcofivfqwgsc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The list of logic app receivers that are part of this action group.
     */
    @JvmName("mbojyfljscribxcf")
    public suspend fun logicAppReceivers(`value`: List<LogicAppReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicAppReceivers = mapped
    }

    /**
     * @param argument The list of logic app receivers that are part of this action group.
     */
    @JvmName("cvwjfgybrngskncp")
    public suspend fun logicAppReceivers(argument: List<suspend LogicAppReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LogicAppReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logicAppReceivers = mapped
    }

    /**
     * @param argument The list of logic app receivers that are part of this action group.
     */
    @JvmName("herxssbgumnfteam")
    public suspend fun logicAppReceivers(vararg argument: suspend LogicAppReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LogicAppReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logicAppReceivers = mapped
    }

    /**
     * @param argument The list of logic app receivers that are part of this action group.
     */
    @JvmName("oesyfdhqusbevwcy")
    public suspend fun logicAppReceivers(argument: suspend LogicAppReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LogicAppReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.logicAppReceivers = mapped
    }

    /**
     * @param values The list of logic app receivers that are part of this action group.
     */
    @JvmName("iyxrtvypjdhrwfyk")
    public suspend fun logicAppReceivers(vararg values: LogicAppReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logicAppReceivers = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yidksajcfahqlswj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The list of SMS receivers that are part of this action group.
     */
    @JvmName("nitttutnwqoswpqq")
    public suspend fun smsReceivers(`value`: List<SmsReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smsReceivers = mapped
    }

    /**
     * @param argument The list of SMS receivers that are part of this action group.
     */
    @JvmName("iwnsccridptgcetv")
    public suspend fun smsReceivers(argument: List<suspend SmsReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SmsReceiverArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.smsReceivers = mapped
    }

    /**
     * @param argument The list of SMS receivers that are part of this action group.
     */
    @JvmName("pryweyghuoragcrm")
    public suspend fun smsReceivers(vararg argument: suspend SmsReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SmsReceiverArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.smsReceivers = mapped
    }

    /**
     * @param argument The list of SMS receivers that are part of this action group.
     */
    @JvmName("ivqoltuussdbxonx")
    public suspend fun smsReceivers(argument: suspend SmsReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SmsReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.smsReceivers = mapped
    }

    /**
     * @param values The list of SMS receivers that are part of this action group.
     */
    @JvmName("bvgkjfcrulolhlcl")
    public suspend fun smsReceivers(vararg values: SmsReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.smsReceivers = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("otpvdxghiohpbfgm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("ecnuexnkobhpyrjk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The list of voice receivers that are part of this action group.
     */
    @JvmName("pquffwnjmhtrssqj")
    public suspend fun voiceReceivers(`value`: List<VoiceReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceReceivers = mapped
    }

    /**
     * @param argument The list of voice receivers that are part of this action group.
     */
    @JvmName("tcbruecanrqvppdu")
    public suspend fun voiceReceivers(argument: List<suspend VoiceReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VoiceReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.voiceReceivers = mapped
    }

    /**
     * @param argument The list of voice receivers that are part of this action group.
     */
    @JvmName("alxlqnipxrvfdgpq")
    public suspend fun voiceReceivers(vararg argument: suspend VoiceReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VoiceReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.voiceReceivers = mapped
    }

    /**
     * @param argument The list of voice receivers that are part of this action group.
     */
    @JvmName("hjedsnjsyisrmvbp")
    public suspend fun voiceReceivers(argument: suspend VoiceReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VoiceReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.voiceReceivers = mapped
    }

    /**
     * @param values The list of voice receivers that are part of this action group.
     */
    @JvmName("ohcstfoysqlgelyi")
    public suspend fun voiceReceivers(vararg values: VoiceReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.voiceReceivers = mapped
    }

    /**
     * @param value The list of webhook receivers that are part of this action group.
     */
    @JvmName("ycnbpsbyomcorrut")
    public suspend fun webhookReceivers(`value`: List<WebhookReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookReceivers = mapped
    }

    /**
     * @param argument The list of webhook receivers that are part of this action group.
     */
    @JvmName("cxmwvawciouptbpv")
    public suspend fun webhookReceivers(argument: List<suspend WebhookReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebhookReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.webhookReceivers = mapped
    }

    /**
     * @param argument The list of webhook receivers that are part of this action group.
     */
    @JvmName("wovpqtoqullepnii")
    public suspend fun webhookReceivers(vararg argument: suspend WebhookReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebhookReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.webhookReceivers = mapped
    }

    /**
     * @param argument The list of webhook receivers that are part of this action group.
     */
    @JvmName("iexulrxyyehdqimm")
    public suspend fun webhookReceivers(argument: suspend WebhookReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebhookReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.webhookReceivers = mapped
    }

    /**
     * @param values The list of webhook receivers that are part of this action group.
     */
    @JvmName("umrcsuypthegcbkg")
    public suspend fun webhookReceivers(vararg values: WebhookReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webhookReceivers = mapped
    }

    internal fun build(): ActionGroupArgs = ActionGroupArgs(
        actionGroupName = actionGroupName,
        armRoleReceivers = armRoleReceivers,
        automationRunbookReceivers = automationRunbookReceivers,
        azureAppPushReceivers = azureAppPushReceivers,
        azureFunctionReceivers = azureFunctionReceivers,
        emailReceivers = emailReceivers,
        enabled = enabled,
        eventHubReceivers = eventHubReceivers,
        groupShortName = groupShortName,
        itsmReceivers = itsmReceivers,
        location = location,
        logicAppReceivers = logicAppReceivers,
        resourceGroupName = resourceGroupName,
        smsReceivers = smsReceivers,
        tags = tags,
        voiceReceivers = voiceReceivers,
        webhookReceivers = webhookReceivers,
    )
}
