@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.ComponentArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.ApplicationType
import com.pulumi.azurenative.insights.kotlin.enums.FlowType
import com.pulumi.azurenative.insights.kotlin.enums.IngestionMode
import com.pulumi.azurenative.insights.kotlin.enums.PublicNetworkAccessType
import com.pulumi.azurenative.insights.kotlin.enums.RequestSource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Application Insights component definition.
 * Azure REST API version: 2020-02-02. Prior API version in Azure Native 1.x: 2015-05-01.
 * Other available API versions: 2020-02-02-preview.
 * ## Example Usage
 * ### ComponentCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var component = new AzureNative.Insights.Component("component", new()
 *     {
 *         ApplicationType = AzureNative.Insights.ApplicationType.Web,
 *         FlowType = AzureNative.Insights.FlowType.Bluefield,
 *         Kind = "web",
 *         Location = "South Central US",
 *         RequestSource = AzureNative.Insights.RequestSource.Rest,
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "my-component",
 *         WorkspaceResourceId = "/subscriptions/subid/resourcegroups/my-resource-group/providers/microsoft.operationalinsights/workspaces/my-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewComponent(ctx, "component", &insights.ComponentArgs{
 * 			ApplicationType:     pulumi.String(insights.ApplicationTypeWeb),
 * 			FlowType:            pulumi.String(insights.FlowTypeBluefield),
 * 			Kind:                pulumi.String("web"),
 * 			Location:            pulumi.String("South Central US"),
 * 			RequestSource:       pulumi.String(insights.RequestSourceRest),
 * 			ResourceGroupName:   pulumi.String("my-resource-group"),
 * 			ResourceName:        pulumi.String("my-component"),
 * 			WorkspaceResourceId: pulumi.String("/subscriptions/subid/resourcegroups/my-resource-group/providers/microsoft.operationalinsights/workspaces/my-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.Component;
 * import com.pulumi.azurenative.insights.ComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var component = new Component("component", ComponentArgs.builder()
 *             .applicationType("web")
 *             .flowType("Bluefield")
 *             .kind("web")
 *             .location("South Central US")
 *             .requestSource("rest")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("my-component")
 *             .workspaceResourceId("/subscriptions/subid/resourcegroups/my-resource-group/providers/microsoft.operationalinsights/workspaces/my-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### ComponentUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var component = new AzureNative.Insights.Component("component", new()
 *     {
 *         Kind = "web",
 *         Location = "South Central US",
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "my-component",
 *         Tags =
 *         {
 *             { "ApplicationGatewayType", "Internal-Only" },
 *             { "BillingEntity", "Self" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewComponent(ctx, "component", &insights.ComponentArgs{
 * 			Kind:              pulumi.String("web"),
 * 			Location:          pulumi.String("South Central US"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("my-component"),
 * 			Tags: pulumi.StringMap{
 * 				"ApplicationGatewayType": pulumi.String("Internal-Only"),
 * 				"BillingEntity":          pulumi.String("Self"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.Component;
 * import com.pulumi.azurenative.insights.ComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var component = new Component("component", ComponentArgs.builder()
 *             .kind("web")
 *             .location("South Central US")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("my-component")
 *             .tags(Map.ofEntries(
 *                 Map.entry("ApplicationGatewayType", "Internal-Only"),
 *                 Map.entry("BillingEntity", "Self")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:Component my-component /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}
 * ```
 * @property applicationType Type of application being monitored.
 * @property disableIpMasking Disable IP masking.
 * @property disableLocalAuth Disable Non-AAD based Auth.
 * @property flowType Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API.
 * @property forceCustomerStorageForProfiler Force users to create their own storage account for profiler and debugger.
 * @property hockeyAppId The unique application ID created when a new application is added to HockeyApp, used for communications with HockeyApp.
 * @property immediatePurgeDataOn30Days Purge data immediately after 30 days.
 * @property ingestionMode Indicates the flow of the ingestion.
 * @property kind The kind of application that this component refers to, used to customize UI. This value is a freeform string, values should typically be one of the following: web, ios, other, store, java, phone.
 * @property location Resource location
 * @property publicNetworkAccessForIngestion The network access type for accessing Application Insights ingestion.
 * @property publicNetworkAccessForQuery The network access type for accessing Application Insights query.
 * @property requestSource Describes what tool created this Application Insights component. Customers using this API should set this to the default 'rest'.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the Application Insights component resource.
 * @property retentionInDays Retention period in days.
 * @property samplingPercentage Percentage of the data produced by the application being monitored that is being sampled for Application Insights telemetry.
 * @property tags Resource tags
 * @property workspaceResourceId Resource Id of the log analytics workspace which the data will be ingested to. This property is required to create an application with this API version. Applications from older versions will not have this property.
 */
public data class ComponentArgs(
    public val applicationType: Output<Either<String, ApplicationType>>? = null,
    public val disableIpMasking: Output<Boolean>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val flowType: Output<Either<String, FlowType>>? = null,
    public val forceCustomerStorageForProfiler: Output<Boolean>? = null,
    public val hockeyAppId: Output<String>? = null,
    public val immediatePurgeDataOn30Days: Output<Boolean>? = null,
    public val ingestionMode: Output<Either<String, IngestionMode>>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val publicNetworkAccessForIngestion: Output<Either<String, PublicNetworkAccessType>>? =
        null,
    public val publicNetworkAccessForQuery: Output<Either<String, PublicNetworkAccessType>>? = null,
    public val requestSource: Output<Either<String, RequestSource>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val retentionInDays: Output<Int>? = null,
    public val samplingPercentage: Output<Double>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.ComponentArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.ComponentArgs =
        com.pulumi.azurenative.insights.ComponentArgs.builder()
            .applicationType(
                applicationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .disableIpMasking(disableIpMasking?.applyValue({ args0 -> args0 }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .flowType(
                flowType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .forceCustomerStorageForProfiler(forceCustomerStorageForProfiler?.applyValue({ args0 -> args0 }))
            .hockeyAppId(hockeyAppId?.applyValue({ args0 -> args0 }))
            .immediatePurgeDataOn30Days(immediatePurgeDataOn30Days?.applyValue({ args0 -> args0 }))
            .ingestionMode(
                ingestionMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .publicNetworkAccessForIngestion(
                publicNetworkAccessForIngestion?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicNetworkAccessForQuery(
                publicNetworkAccessForQuery?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .requestSource(
                requestSource?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .retentionInDays(retentionInDays?.applyValue({ args0 -> args0 }))
            .samplingPercentage(samplingPercentage?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceResourceId(workspaceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComponentArgs].
 */
@PulumiTagMarker
public class ComponentArgsBuilder internal constructor() {
    private var applicationType: Output<Either<String, ApplicationType>>? = null

    private var disableIpMasking: Output<Boolean>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var flowType: Output<Either<String, FlowType>>? = null

    private var forceCustomerStorageForProfiler: Output<Boolean>? = null

    private var hockeyAppId: Output<String>? = null

    private var immediatePurgeDataOn30Days: Output<Boolean>? = null

    private var ingestionMode: Output<Either<String, IngestionMode>>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var publicNetworkAccessForIngestion: Output<Either<String, PublicNetworkAccessType>>? =
        null

    private var publicNetworkAccessForQuery: Output<Either<String, PublicNetworkAccessType>>? = null

    private var requestSource: Output<Either<String, RequestSource>>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var retentionInDays: Output<Int>? = null

    private var samplingPercentage: Output<Double>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceResourceId: Output<String>? = null

    /**
     * @param value Type of application being monitored.
     */
    @JvmName("vctlphxmbfmnvbto")
    public suspend fun applicationType(`value`: Output<Either<String, ApplicationType>>) {
        this.applicationType = value
    }

    /**
     * @param value Disable IP masking.
     */
    @JvmName("mgudqjltghbgbahr")
    public suspend fun disableIpMasking(`value`: Output<Boolean>) {
        this.disableIpMasking = value
    }

    /**
     * @param value Disable Non-AAD based Auth.
     */
    @JvmName("mktxbunwyrfokudq")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API.
     */
    @JvmName("bwrtjdwvlrwofamp")
    public suspend fun flowType(`value`: Output<Either<String, FlowType>>) {
        this.flowType = value
    }

    /**
     * @param value Force users to create their own storage account for profiler and debugger.
     */
    @JvmName("fopedhcwqwaxkidj")
    public suspend fun forceCustomerStorageForProfiler(`value`: Output<Boolean>) {
        this.forceCustomerStorageForProfiler = value
    }

    /**
     * @param value The unique application ID created when a new application is added to HockeyApp, used for communications with HockeyApp.
     */
    @JvmName("dtwkrqrmwkijrbtw")
    public suspend fun hockeyAppId(`value`: Output<String>) {
        this.hockeyAppId = value
    }

    /**
     * @param value Purge data immediately after 30 days.
     */
    @JvmName("btnvjvwuscuibunj")
    public suspend fun immediatePurgeDataOn30Days(`value`: Output<Boolean>) {
        this.immediatePurgeDataOn30Days = value
    }

    /**
     * @param value Indicates the flow of the ingestion.
     */
    @JvmName("ndolgpjotlptguur")
    public suspend fun ingestionMode(`value`: Output<Either<String, IngestionMode>>) {
        this.ingestionMode = value
    }

    /**
     * @param value The kind of application that this component refers to, used to customize UI. This value is a freeform string, values should typically be one of the following: web, ios, other, store, java, phone.
     */
    @JvmName("cnfjdexcborfrvbm")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("goqadwladpdmgvib")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The network access type for accessing Application Insights ingestion.
     */
    @JvmName("ggigrwqmgqdrtclf")
    public suspend fun publicNetworkAccessForIngestion(`value`: Output<Either<String, PublicNetworkAccessType>>) {
        this.publicNetworkAccessForIngestion = value
    }

    /**
     * @param value The network access type for accessing Application Insights query.
     */
    @JvmName("cvppbaiytkhceshp")
    public suspend fun publicNetworkAccessForQuery(`value`: Output<Either<String, PublicNetworkAccessType>>) {
        this.publicNetworkAccessForQuery = value
    }

    /**
     * @param value Describes what tool created this Application Insights component. Customers using this API should set this to the default 'rest'.
     */
    @JvmName("qnmwotwwhvvxkoqn")
    public suspend fun requestSource(`value`: Output<Either<String, RequestSource>>) {
        this.requestSource = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lnqeurbgwrefsfab")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("jjxrmhfqwetgpwlb")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Retention period in days.
     */
    @JvmName("nmnhkoqkoeprgiqf")
    public suspend fun retentionInDays(`value`: Output<Int>) {
        this.retentionInDays = value
    }

    /**
     * @param value Percentage of the data produced by the application being monitored that is being sampled for Application Insights telemetry.
     */
    @JvmName("pglnbrecbqluxmlr")
    public suspend fun samplingPercentage(`value`: Output<Double>) {
        this.samplingPercentage = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("rrmdenjusbudtgnr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource Id of the log analytics workspace which the data will be ingested to. This property is required to create an application with this API version. Applications from older versions will not have this property.
     */
    @JvmName("sfxuehonbgkoanmn")
    public suspend fun workspaceResourceId(`value`: Output<String>) {
        this.workspaceResourceId = value
    }

    /**
     * @param value Type of application being monitored.
     */
    @JvmName("chxgajiuqwrvfbfn")
    public suspend fun applicationType(`value`: Either<String, ApplicationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationType = mapped
    }

    /**
     * @param value Type of application being monitored.
     */
    @JvmName("crkuoyeqcocasvdm")
    public fun applicationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationType = mapped
    }

    /**
     * @param value Type of application being monitored.
     */
    @JvmName("cjgwinppvabfioui")
    public fun applicationType(`value`: ApplicationType) {
        val toBeMapped = Either.ofRight<String, ApplicationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationType = mapped
    }

    /**
     * @param value Disable IP masking.
     */
    @JvmName("qwuwhhbytnugpjhn")
    public suspend fun disableIpMasking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableIpMasking = mapped
    }

    /**
     * @param value Disable Non-AAD based Auth.
     */
    @JvmName("ytneiswqqbvawajb")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API.
     */
    @JvmName("jouobdqfxlcrcodu")
    public suspend fun flowType(`value`: Either<String, FlowType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowType = mapped
    }

    /**
     * @param value Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API.
     */
    @JvmName("esikhlrimfljioke")
    public fun flowType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FlowType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flowType = mapped
    }

    /**
     * @param value Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API.
     */
    @JvmName("xfcstvhrgaunqdle")
    public fun flowType(`value`: FlowType) {
        val toBeMapped = Either.ofRight<String, FlowType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flowType = mapped
    }

    /**
     * @param value Force users to create their own storage account for profiler and debugger.
     */
    @JvmName("gqllckomkymjwimr")
    public suspend fun forceCustomerStorageForProfiler(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceCustomerStorageForProfiler = mapped
    }

    /**
     * @param value The unique application ID created when a new application is added to HockeyApp, used for communications with HockeyApp.
     */
    @JvmName("sqlwqnsxlesotipt")
    public suspend fun hockeyAppId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hockeyAppId = mapped
    }

    /**
     * @param value Purge data immediately after 30 days.
     */
    @JvmName("ebghagdcfbegdnib")
    public suspend fun immediatePurgeDataOn30Days(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immediatePurgeDataOn30Days = mapped
    }

    /**
     * @param value Indicates the flow of the ingestion.
     */
    @JvmName("jfdkbnldrhpanwpc")
    public suspend fun ingestionMode(`value`: Either<String, IngestionMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionMode = mapped
    }

    /**
     * @param value Indicates the flow of the ingestion.
     */
    @JvmName("sastjbqxnujlllqb")
    public fun ingestionMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IngestionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionMode = mapped
    }

    /**
     * @param value Indicates the flow of the ingestion.
     */
    @JvmName("rvrlapxrddkkbymr")
    public fun ingestionMode(`value`: IngestionMode) {
        val toBeMapped = Either.ofRight<String, IngestionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionMode = mapped
    }

    /**
     * @param value The kind of application that this component refers to, used to customize UI. This value is a freeform string, values should typically be one of the following: web, ios, other, store, java, phone.
     */
    @JvmName("pcxvggpwnkuedkrh")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("rukjltnxfeeqxsfm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The network access type for accessing Application Insights ingestion.
     */
    @JvmName("isgvsorowyykhntn")
    public suspend fun publicNetworkAccessForIngestion(`value`: Either<String, PublicNetworkAccessType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccessForIngestion = mapped
    }

    /**
     * @param value The network access type for accessing Application Insights ingestion.
     */
    @JvmName("ykrhkuyiaibfgsjk")
    public fun publicNetworkAccessForIngestion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccessForIngestion = mapped
    }

    /**
     * @param value The network access type for accessing Application Insights ingestion.
     */
    @JvmName("aynnkhyepaqneuay")
    public fun publicNetworkAccessForIngestion(`value`: PublicNetworkAccessType) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccessForIngestion = mapped
    }

    /**
     * @param value The network access type for accessing Application Insights query.
     */
    @JvmName("atojmugmkjvwcdma")
    public suspend fun publicNetworkAccessForQuery(`value`: Either<String, PublicNetworkAccessType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccessForQuery = mapped
    }

    /**
     * @param value The network access type for accessing Application Insights query.
     */
    @JvmName("eeuxslmcobipxvpm")
    public fun publicNetworkAccessForQuery(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccessForQuery = mapped
    }

    /**
     * @param value The network access type for accessing Application Insights query.
     */
    @JvmName("tusvymgsxcgpjgbm")
    public fun publicNetworkAccessForQuery(`value`: PublicNetworkAccessType) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccessForQuery = mapped
    }

    /**
     * @param value Describes what tool created this Application Insights component. Customers using this API should set this to the default 'rest'.
     */
    @JvmName("soruvtahlblnmbvn")
    public suspend fun requestSource(`value`: Either<String, RequestSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestSource = mapped
    }

    /**
     * @param value Describes what tool created this Application Insights component. Customers using this API should set this to the default 'rest'.
     */
    @JvmName("etgfglrourcquvmg")
    public fun requestSource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RequestSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestSource = mapped
    }

    /**
     * @param value Describes what tool created this Application Insights component. Customers using this API should set this to the default 'rest'.
     */
    @JvmName("nngdfuagwhwbtxot")
    public fun requestSource(`value`: RequestSource) {
        val toBeMapped = Either.ofRight<String, RequestSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestSource = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("elydxaqmeojxamet")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("ifsywwxwtvpecoyy")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Retention period in days.
     */
    @JvmName("ewmebqfkaualfogo")
    public suspend fun retentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionInDays = mapped
    }

    /**
     * @param value Percentage of the data produced by the application being monitored that is being sampled for Application Insights telemetry.
     */
    @JvmName("aefsxwfemloqxxua")
    public suspend fun samplingPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samplingPercentage = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("mudwqltntgddycxk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("jdushbrcxwbxghks")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Resource Id of the log analytics workspace which the data will be ingested to. This property is required to create an application with this API version. Applications from older versions will not have this property.
     */
    @JvmName("epffdsuijvehmpns")
    public suspend fun workspaceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceResourceId = mapped
    }

    internal fun build(): ComponentArgs = ComponentArgs(
        applicationType = applicationType,
        disableIpMasking = disableIpMasking,
        disableLocalAuth = disableLocalAuth,
        flowType = flowType,
        forceCustomerStorageForProfiler = forceCustomerStorageForProfiler,
        hockeyAppId = hockeyAppId,
        immediatePurgeDataOn30Days = immediatePurgeDataOn30Days,
        ingestionMode = ingestionMode,
        kind = kind,
        location = location,
        publicNetworkAccessForIngestion = publicNetworkAccessForIngestion,
        publicNetworkAccessForQuery = publicNetworkAccessForQuery,
        requestSource = requestSource,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        retentionInDays = retentionInDays,
        samplingPercentage = samplingPercentage,
        tags = tags,
        workspaceResourceId = workspaceResourceId,
    )
}
