@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ComponentLinkedStorageAccount].
 */
@PulumiTagMarker
public class ComponentLinkedStorageAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ComponentLinkedStorageAccountArgs = ComponentLinkedStorageAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ComponentLinkedStorageAccountArgsBuilder.() -> Unit) {
        val builder = ComponentLinkedStorageAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ComponentLinkedStorageAccount {
        val builtJavaResource =
            com.pulumi.azurenative.insights.ComponentLinkedStorageAccount(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ComponentLinkedStorageAccount(builtJavaResource)
    }
}

/**
 * An Application Insights component linked storage accounts
 * Azure REST API version: 2020-03-01-preview. Prior API version in Azure Native 1.x: 2020-03-01-preview.
 * ## Example Usage
 * ### ComponentLinkedStorageAccountsCreateAndUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var componentLinkedStorageAccount = new AzureNative.Insights.ComponentLinkedStorageAccount("componentLinkedStorageAccount", new()
 *     {
 *         LinkedStorageAccount = "/subscriptions/86dc51d3-92ed-4d7e-947a-775ea79b4918/resourceGroups/someResourceGroupName/providers/Microsoft.Storage/storageAccounts/storageaccountname",
 *         ResourceGroupName = "someResourceGroupName",
 *         ResourceName = "myComponent",
 *         StorageType = "ServiceProfiler",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewComponentLinkedStorageAccount(ctx, "componentLinkedStorageAccount", &insights.ComponentLinkedStorageAccountArgs{
 * 			LinkedStorageAccount: pulumi.String("/subscriptions/86dc51d3-92ed-4d7e-947a-775ea79b4918/resourceGroups/someResourceGroupName/providers/Microsoft.Storage/storageAccounts/storageaccountname"),
 * 			ResourceGroupName:    pulumi.String("someResourceGroupName"),
 * 			ResourceName:         pulumi.String("myComponent"),
 * 			StorageType:          pulumi.String("ServiceProfiler"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ComponentLinkedStorageAccount;
 * import com.pulumi.azurenative.insights.ComponentLinkedStorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var componentLinkedStorageAccount = new ComponentLinkedStorageAccount("componentLinkedStorageAccount", ComponentLinkedStorageAccountArgs.builder()
 *             .linkedStorageAccount("/subscriptions/86dc51d3-92ed-4d7e-947a-775ea79b4918/resourceGroups/someResourceGroupName/providers/Microsoft.Storage/storageAccounts/storageaccountname")
 *             .resourceGroupName("someResourceGroupName")
 *             .resourceName("myComponent")
 *             .storageType("ServiceProfiler")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ComponentLinkedStorageAccount serviceprofile /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/linkedStorageAccounts/{storageType}
 * ```
 */
public class ComponentLinkedStorageAccount internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.ComponentLinkedStorageAccount,
) : KotlinCustomResource(javaResource, ComponentLinkedStorageAccountMapper) {
    /**
     * Linked storage account resource ID
     */
    public val linkedStorageAccount: Output<String>?
        get() = javaResource.linkedStorageAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ComponentLinkedStorageAccountMapper : ResourceMapper<ComponentLinkedStorageAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.ComponentLinkedStorageAccount::class == javaResource::class

    override fun map(javaResource: Resource): ComponentLinkedStorageAccount =
        ComponentLinkedStorageAccount(
            javaResource as
                com.pulumi.azurenative.insights.ComponentLinkedStorageAccount,
        )
}

/**
 * @see [ComponentLinkedStorageAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ComponentLinkedStorageAccount].
 */
public suspend fun componentLinkedStorageAccount(
    name: String,
    block: suspend ComponentLinkedStorageAccountResourceBuilder.() -> Unit,
): ComponentLinkedStorageAccount {
    val builder = ComponentLinkedStorageAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ComponentLinkedStorageAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun componentLinkedStorageAccount(name: String): ComponentLinkedStorageAccount {
    val builder = ComponentLinkedStorageAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
