@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.DataSourceResponse
import com.pulumi.azurenative.insights.kotlin.outputs.DataSourceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [GuestDiagnosticsSetting].
 */
@PulumiTagMarker
public class GuestDiagnosticsSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GuestDiagnosticsSettingArgs = GuestDiagnosticsSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GuestDiagnosticsSettingArgsBuilder.() -> Unit) {
        val builder = GuestDiagnosticsSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GuestDiagnosticsSetting {
        val builtJavaResource =
            com.pulumi.azurenative.insights.GuestDiagnosticsSetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GuestDiagnosticsSetting(builtJavaResource)
    }
}

/**
 * Virtual machine guest diagnostics settings resource.
 * Azure REST API version: 2018-06-01-preview. Prior API version in Azure Native 1.x: 2018-06-01-preview.
 * ## Example Usage
 * ### Create or update a guest diagnostic settings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var guestDiagnosticsSetting = new AzureNative.Insights.GuestDiagnosticsSetting("guestDiagnosticsSetting", new()
 *     {
 *         DataSources = new[]
 *         {
 *             new AzureNative.Insights.Inputs.DataSourceArgs
 *             {
 *                 Configuration = new AzureNative.Insights.Inputs.DataSourceConfigurationArgs
 *                 {
 *                     PerfCounters = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.PerformanceCounterConfigurationArgs
 *                         {
 *                             Name = "\\Process(_Total)\\%Processor Time",
 *                             SamplingPeriod = "PT1M",
 *                         },
 *                         new AzureNative.Insights.Inputs.PerformanceCounterConfigurationArgs
 *                         {
 *                             Name = "\\Process(_Total)\\Working Set",
 *                             SamplingPeriod = "PT1M",
 *                         },
 *                     },
 *                 },
 *                 Kind = "PerformanceCounter",
 *                 Sinks = new[]
 *                 {
 *                     new AzureNative.Insights.Inputs.SinkConfigurationArgs
 *                     {
 *                         Kind = "LogAnalytics",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Insights.Inputs.DataSourceArgs
 *             {
 *                 Configuration = new AzureNative.Insights.Inputs.DataSourceConfigurationArgs
 *                 {
 *                     Providers = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.EtwProviderConfigurationArgs
 *                         {
 *                             Id = "1",
 *                         },
 *                         new AzureNative.Insights.Inputs.EtwProviderConfigurationArgs
 *                         {
 *                             Id = "2",
 *                         },
 *                     },
 *                 },
 *                 Kind = "ETWProviders",
 *                 Sinks = new[]
 *                 {
 *                     new AzureNative.Insights.Inputs.SinkConfigurationArgs
 *                     {
 *                         Kind = "LogAnalytics",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Insights.Inputs.DataSourceArgs
 *             {
 *                 Configuration = new AzureNative.Insights.Inputs.DataSourceConfigurationArgs
 *                 {
 *                     EventLogs = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.EventLogConfigurationArgs
 *                         {
 *                             Filter = "SourceName == Xyz AND EventId = \"100\" AND  $Xpath/Column=\"DCName\" = \"CatWoman\"",
 *                             LogName = "Application",
 *                         },
 *                         new AzureNative.Insights.Inputs.EventLogConfigurationArgs
 *                         {
 *                             Filter = "SourceName == Xyz AND EventId = \"100\" AND  $Xpath/Column=\"DCName\" = \"BatMan\"",
 *                             LogName = "Application",
 *                         },
 *                     },
 *                 },
 *                 Kind = "WindowsEventLogs",
 *                 Sinks = new[]
 *                 {
 *                     new AzureNative.Insights.Inputs.SinkConfigurationArgs
 *                     {
 *                         Kind = "LogAnalytics",
 *                     },
 *                 },
 *             },
 *         },
 *         DiagnosticSettingsName = "SampleDiagSetting",
 *         Location = "Global",
 *         OsType = "Windows",
 *         ResourceGroupName = "Default-ResourceGroup",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewGuestDiagnosticsSetting(ctx, "guestDiagnosticsSetting", &insights.GuestDiagnosticsSettingArgs{
 * 			DataSources: insights.DataSourceArray{
 * 				&insights.DataSourceArgs{
 * 					Configuration: &insights.DataSourceConfigurationArgs{
 * 						PerfCounters: insights.PerformanceCounterConfigurationArray{
 * 							&insights.PerformanceCounterConfigurationArgs{
 * 								Name:           pulumi.String("\\Process(_Total)\\%Processor Time"),
 * 								SamplingPeriod: pulumi.String("PT1M"),
 * 							},
 * 							&insights.PerformanceCounterConfigurationArgs{
 * 								Name:           pulumi.String("\\Process(_Total)\\Working Set"),
 * 								SamplingPeriod: pulumi.String("PT1M"),
 * 							},
 * 						},
 * 					},
 * 					Kind: pulumi.String("PerformanceCounter"),
 * 					Sinks: insights.SinkConfigurationArray{
 * 						&insights.SinkConfigurationArgs{
 * 							Kind: pulumi.String("LogAnalytics"),
 * 						},
 * 					},
 * 				},
 * 				&insights.DataSourceArgs{
 * 					Configuration: &insights.DataSourceConfigurationArgs{
 * 						Providers: insights.EtwProviderConfigurationArray{
 * 							&insights.EtwProviderConfigurationArgs{
 * 								Id: pulumi.String("1"),
 * 							},
 * 							&insights.EtwProviderConfigurationArgs{
 * 								Id: pulumi.String("2"),
 * 							},
 * 						},
 * 					},
 * 					Kind: pulumi.String("ETWProviders"),
 * 					Sinks: insights.SinkConfigurationArray{
 * 						&insights.SinkConfigurationArgs{
 * 							Kind: pulumi.String("LogAnalytics"),
 * 						},
 * 					},
 * 				},
 * 				&insights.DataSourceArgs{
 * 					Configuration: &insights.DataSourceConfigurationArgs{
 * 						EventLogs: insights.EventLogConfigurationArray{
 * 							&insights.EventLogConfigurationArgs{
 * 								Filter:  pulumi.String("SourceName == Xyz AND EventId = \"100\" AND  $Xpath/Column=\"DCName\" = \"CatWoman\""),
 * 								LogName: pulumi.String("Application"),
 * 							},
 * 							&insights.EventLogConfigurationArgs{
 * 								Filter:  pulumi.String("SourceName == Xyz AND EventId = \"100\" AND  $Xpath/Column=\"DCName\" = \"BatMan\""),
 * 								LogName: pulumi.String("Application"),
 * 							},
 * 						},
 * 					},
 * 					Kind: pulumi.String("WindowsEventLogs"),
 * 					Sinks: insights.SinkConfigurationArray{
 * 						&insights.SinkConfigurationArgs{
 * 							Kind: pulumi.String("LogAnalytics"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			DiagnosticSettingsName: pulumi.String("SampleDiagSetting"),
 * 			Location:               pulumi.String("Global"),
 * 			OsType:                 pulumi.String("Windows"),
 * 			ResourceGroupName:      pulumi.String("Default-ResourceGroup"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.GuestDiagnosticsSetting;
 * import com.pulumi.azurenative.insights.GuestDiagnosticsSettingArgs;
 * import com.pulumi.azurenative.insights.inputs.DataSourceArgs;
 * import com.pulumi.azurenative.insights.inputs.DataSourceConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var guestDiagnosticsSetting = new GuestDiagnosticsSetting("guestDiagnosticsSetting", GuestDiagnosticsSettingArgs.builder()
 *             .dataSources(
 *                 DataSourceArgs.builder()
 *                     .configuration(DataSourceConfigurationArgs.builder()
 *                         .perfCounters(
 *                             PerformanceCounterConfigurationArgs.builder()
 *                                 .name("\\Process(_Total)\\%Processor Time")
 *                                 .samplingPeriod("PT1M")
 *                                 .build(),
 *                             PerformanceCounterConfigurationArgs.builder()
 *                                 .name("\\Process(_Total)\\Working Set")
 *                                 .samplingPeriod("PT1M")
 *                                 .build())
 *                         .build())
 *                     .kind("PerformanceCounter")
 *                     .sinks(SinkConfigurationArgs.builder()
 *                         .kind("LogAnalytics")
 *                         .build())
 *                     .build(),
 *                 DataSourceArgs.builder()
 *                     .configuration(DataSourceConfigurationArgs.builder()
 *                         .providers(
 *                             EtwProviderConfigurationArgs.builder()
 *                                 .id(1)
 *                                 .build(),
 *                             EtwProviderConfigurationArgs.builder()
 *                                 .id(2)
 *                                 .build())
 *                         .build())
 *                     .kind("ETWProviders")
 *                     .sinks(SinkConfigurationArgs.builder()
 *                         .kind("LogAnalytics")
 *                         .build())
 *                     .build(),
 *                 DataSourceArgs.builder()
 *                     .configuration(DataSourceConfigurationArgs.builder()
 *                         .eventLogs(
 *                             EventLogConfigurationArgs.builder()
 *                                 .filter("SourceName == Xyz AND EventId = \"100\" AND  $Xpath/Column=\"DCName\" = \"CatWoman\"")
 *                                 .logName("Application")
 *                                 .build(),
 *                             EventLogConfigurationArgs.builder()
 *                                 .filter("SourceName == Xyz AND EventId = \"100\" AND  $Xpath/Column=\"DCName\" = \"BatMan\"")
 *                                 .logName("Application")
 *                                 .build())
 *                         .build())
 *                     .kind("WindowsEventLogs")
 *                     .sinks(SinkConfigurationArgs.builder()
 *                         .kind("LogAnalytics")
 *                         .build())
 *                     .build())
 *             .diagnosticSettingsName("SampleDiagSetting")
 *             .location("Global")
 *             .osType("Windows")
 *             .resourceGroupName("Default-ResourceGroup")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:GuestDiagnosticsSetting productionMachineSetting /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/guestDiagnosticSettings/{diagnosticSettingsName}
 * ```
 */
public class GuestDiagnosticsSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.GuestDiagnosticsSetting,
) : KotlinCustomResource(javaResource, GuestDiagnosticsSettingMapper) {
    /**
     * the array of data source object which are configured to collect and send data
     */
    public val dataSources: Output<List<DataSourceResponse>>?
        get() = javaResource.dataSources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Operating system type for the configuration
     */
    public val osType: Output<String>?
        get() = javaResource.osType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val proxySetting: Output<String>?
        get() = javaResource.proxySetting().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GuestDiagnosticsSettingMapper : ResourceMapper<GuestDiagnosticsSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.GuestDiagnosticsSetting::class == javaResource::class

    override fun map(javaResource: Resource): GuestDiagnosticsSetting =
        GuestDiagnosticsSetting(
            javaResource as
                com.pulumi.azurenative.insights.GuestDiagnosticsSetting,
        )
}

/**
 * @see [GuestDiagnosticsSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GuestDiagnosticsSetting].
 */
public suspend fun guestDiagnosticsSetting(
    name: String,
    block: suspend GuestDiagnosticsSettingResourceBuilder.() -> Unit,
): GuestDiagnosticsSetting {
    val builder = GuestDiagnosticsSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GuestDiagnosticsSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun guestDiagnosticsSetting(name: String): GuestDiagnosticsSetting {
    val builder = GuestDiagnosticsSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
