@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.GuestDiagnosticsSettingArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.DataSourceArgs
import com.pulumi.azurenative.insights.kotlin.inputs.DataSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Virtual machine guest diagnostics settings resource.
 * Azure REST API version: 2018-06-01-preview. Prior API version in Azure Native 1.x: 2018-06-01-preview.
 * ## Example Usage
 * ### Create or update a guest diagnostic settings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var guestDiagnosticsSetting = new AzureNative.Insights.GuestDiagnosticsSetting("guestDiagnosticsSetting", new()
 *     {
 *         DataSources = new[]
 *         {
 *             new AzureNative.Insights.Inputs.DataSourceArgs
 *             {
 *                 Configuration = new AzureNative.Insights.Inputs.DataSourceConfigurationArgs
 *                 {
 *                     PerfCounters = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.PerformanceCounterConfigurationArgs
 *                         {
 *                             Name = "\\Process(_Total)\\%Processor Time",
 *                             SamplingPeriod = "PT1M",
 *                         },
 *                         new AzureNative.Insights.Inputs.PerformanceCounterConfigurationArgs
 *                         {
 *                             Name = "\\Process(_Total)\\Working Set",
 *                             SamplingPeriod = "PT1M",
 *                         },
 *                     },
 *                 },
 *                 Kind = "PerformanceCounter",
 *                 Sinks = new[]
 *                 {
 *                     new AzureNative.Insights.Inputs.SinkConfigurationArgs
 *                     {
 *                         Kind = "LogAnalytics",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Insights.Inputs.DataSourceArgs
 *             {
 *                 Configuration = new AzureNative.Insights.Inputs.DataSourceConfigurationArgs
 *                 {
 *                     Providers = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.EtwProviderConfigurationArgs
 *                         {
 *                             Id = "1",
 *                         },
 *                         new AzureNative.Insights.Inputs.EtwProviderConfigurationArgs
 *                         {
 *                             Id = "2",
 *                         },
 *                     },
 *                 },
 *                 Kind = "ETWProviders",
 *                 Sinks = new[]
 *                 {
 *                     new AzureNative.Insights.Inputs.SinkConfigurationArgs
 *                     {
 *                         Kind = "LogAnalytics",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Insights.Inputs.DataSourceArgs
 *             {
 *                 Configuration = new AzureNative.Insights.Inputs.DataSourceConfigurationArgs
 *                 {
 *                     EventLogs = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.EventLogConfigurationArgs
 *                         {
 *                             Filter = "SourceName == Xyz AND EventId = \"100\" AND  $Xpath/Column=\"DCName\" = \"CatWoman\"",
 *                             LogName = "Application",
 *                         },
 *                         new AzureNative.Insights.Inputs.EventLogConfigurationArgs
 *                         {
 *                             Filter = "SourceName == Xyz AND EventId = \"100\" AND  $Xpath/Column=\"DCName\" = \"BatMan\"",
 *                             LogName = "Application",
 *                         },
 *                     },
 *                 },
 *                 Kind = "WindowsEventLogs",
 *                 Sinks = new[]
 *                 {
 *                     new AzureNative.Insights.Inputs.SinkConfigurationArgs
 *                     {
 *                         Kind = "LogAnalytics",
 *                     },
 *                 },
 *             },
 *         },
 *         DiagnosticSettingsName = "SampleDiagSetting",
 *         Location = "Global",
 *         OsType = "Windows",
 *         ResourceGroupName = "Default-ResourceGroup",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewGuestDiagnosticsSetting(ctx, "guestDiagnosticsSetting", &insights.GuestDiagnosticsSettingArgs{
 * 			DataSources: insights.DataSourceArray{
 * 				&insights.DataSourceArgs{
 * 					Configuration: &insights.DataSourceConfigurationArgs{
 * 						PerfCounters: insights.PerformanceCounterConfigurationArray{
 * 							&insights.PerformanceCounterConfigurationArgs{
 * 								Name:           pulumi.String("\\Process(_Total)\\%Processor Time"),
 * 								SamplingPeriod: pulumi.String("PT1M"),
 * 							},
 * 							&insights.PerformanceCounterConfigurationArgs{
 * 								Name:           pulumi.String("\\Process(_Total)\\Working Set"),
 * 								SamplingPeriod: pulumi.String("PT1M"),
 * 							},
 * 						},
 * 					},
 * 					Kind: pulumi.String("PerformanceCounter"),
 * 					Sinks: insights.SinkConfigurationArray{
 * 						&insights.SinkConfigurationArgs{
 * 							Kind: pulumi.String("LogAnalytics"),
 * 						},
 * 					},
 * 				},
 * 				&insights.DataSourceArgs{
 * 					Configuration: &insights.DataSourceConfigurationArgs{
 * 						Providers: insights.EtwProviderConfigurationArray{
 * 							&insights.EtwProviderConfigurationArgs{
 * 								Id: pulumi.String("1"),
 * 							},
 * 							&insights.EtwProviderConfigurationArgs{
 * 								Id: pulumi.String("2"),
 * 							},
 * 						},
 * 					},
 * 					Kind: pulumi.String("ETWProviders"),
 * 					Sinks: insights.SinkConfigurationArray{
 * 						&insights.SinkConfigurationArgs{
 * 							Kind: pulumi.String("LogAnalytics"),
 * 						},
 * 					},
 * 				},
 * 				&insights.DataSourceArgs{
 * 					Configuration: &insights.DataSourceConfigurationArgs{
 * 						EventLogs: insights.EventLogConfigurationArray{
 * 							&insights.EventLogConfigurationArgs{
 * 								Filter:  pulumi.String("SourceName == Xyz AND EventId = \"100\" AND  $Xpath/Column=\"DCName\" = \"CatWoman\""),
 * 								LogName: pulumi.String("Application"),
 * 							},
 * 							&insights.EventLogConfigurationArgs{
 * 								Filter:  pulumi.String("SourceName == Xyz AND EventId = \"100\" AND  $Xpath/Column=\"DCName\" = \"BatMan\""),
 * 								LogName: pulumi.String("Application"),
 * 							},
 * 						},
 * 					},
 * 					Kind: pulumi.String("WindowsEventLogs"),
 * 					Sinks: insights.SinkConfigurationArray{
 * 						&insights.SinkConfigurationArgs{
 * 							Kind: pulumi.String("LogAnalytics"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			DiagnosticSettingsName: pulumi.String("SampleDiagSetting"),
 * 			Location:               pulumi.String("Global"),
 * 			OsType:                 pulumi.String("Windows"),
 * 			ResourceGroupName:      pulumi.String("Default-ResourceGroup"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.GuestDiagnosticsSetting;
 * import com.pulumi.azurenative.insights.GuestDiagnosticsSettingArgs;
 * import com.pulumi.azurenative.insights.inputs.DataSourceArgs;
 * import com.pulumi.azurenative.insights.inputs.DataSourceConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var guestDiagnosticsSetting = new GuestDiagnosticsSetting("guestDiagnosticsSetting", GuestDiagnosticsSettingArgs.builder()
 *             .dataSources(
 *                 DataSourceArgs.builder()
 *                     .configuration(DataSourceConfigurationArgs.builder()
 *                         .perfCounters(
 *                             PerformanceCounterConfigurationArgs.builder()
 *                                 .name("\\Process(_Total)\\%Processor Time")
 *                                 .samplingPeriod("PT1M")
 *                                 .build(),
 *                             PerformanceCounterConfigurationArgs.builder()
 *                                 .name("\\Process(_Total)\\Working Set")
 *                                 .samplingPeriod("PT1M")
 *                                 .build())
 *                         .build())
 *                     .kind("PerformanceCounter")
 *                     .sinks(SinkConfigurationArgs.builder()
 *                         .kind("LogAnalytics")
 *                         .build())
 *                     .build(),
 *                 DataSourceArgs.builder()
 *                     .configuration(DataSourceConfigurationArgs.builder()
 *                         .providers(
 *                             EtwProviderConfigurationArgs.builder()
 *                                 .id(1)
 *                                 .build(),
 *                             EtwProviderConfigurationArgs.builder()
 *                                 .id(2)
 *                                 .build())
 *                         .build())
 *                     .kind("ETWProviders")
 *                     .sinks(SinkConfigurationArgs.builder()
 *                         .kind("LogAnalytics")
 *                         .build())
 *                     .build(),
 *                 DataSourceArgs.builder()
 *                     .configuration(DataSourceConfigurationArgs.builder()
 *                         .eventLogs(
 *                             EventLogConfigurationArgs.builder()
 *                                 .filter("SourceName == Xyz AND EventId = \"100\" AND  $Xpath/Column=\"DCName\" = \"CatWoman\"")
 *                                 .logName("Application")
 *                                 .build(),
 *                             EventLogConfigurationArgs.builder()
 *                                 .filter("SourceName == Xyz AND EventId = \"100\" AND  $Xpath/Column=\"DCName\" = \"BatMan\"")
 *                                 .logName("Application")
 *                                 .build())
 *                         .build())
 *                     .kind("WindowsEventLogs")
 *                     .sinks(SinkConfigurationArgs.builder()
 *                         .kind("LogAnalytics")
 *                         .build())
 *                     .build())
 *             .diagnosticSettingsName("SampleDiagSetting")
 *             .location("Global")
 *             .osType("Windows")
 *             .resourceGroupName("Default-ResourceGroup")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:GuestDiagnosticsSetting productionMachineSetting /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/guestDiagnosticSettings/{diagnosticSettingsName}
 * ```
 * @property dataSources the array of data source object which are configured to collect and send data
 * @property diagnosticSettingsName The name of the diagnostic setting.
 * @property location Resource location
 * @property osType Operating system type for the configuration
 * @property proxySetting
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags
 */
public data class GuestDiagnosticsSettingArgs(
    public val dataSources: Output<List<DataSourceArgs>>? = null,
    public val diagnosticSettingsName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val osType: Output<String>? = null,
    public val proxySetting: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.GuestDiagnosticsSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.GuestDiagnosticsSettingArgs =
        com.pulumi.azurenative.insights.GuestDiagnosticsSettingArgs.builder()
            .dataSources(
                dataSources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .diagnosticSettingsName(diagnosticSettingsName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .osType(osType?.applyValue({ args0 -> args0 }))
            .proxySetting(proxySetting?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GuestDiagnosticsSettingArgs].
 */
@PulumiTagMarker
public class GuestDiagnosticsSettingArgsBuilder internal constructor() {
    private var dataSources: Output<List<DataSourceArgs>>? = null

    private var diagnosticSettingsName: Output<String>? = null

    private var location: Output<String>? = null

    private var osType: Output<String>? = null

    private var proxySetting: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value the array of data source object which are configured to collect and send data
     */
    @JvmName("rlkbhfhtghbtypmc")
    public suspend fun dataSources(`value`: Output<List<DataSourceArgs>>) {
        this.dataSources = value
    }

    @JvmName("gpwnqtwiaqewyuny")
    public suspend fun dataSources(vararg values: Output<DataSourceArgs>) {
        this.dataSources = Output.all(values.asList())
    }

    /**
     * @param values the array of data source object which are configured to collect and send data
     */
    @JvmName("hvwsxudvkulpwuno")
    public suspend fun dataSources(values: List<Output<DataSourceArgs>>) {
        this.dataSources = Output.all(values)
    }

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("rqukikqdshxxpwvl")
    public suspend fun diagnosticSettingsName(`value`: Output<String>) {
        this.diagnosticSettingsName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("bsbfmuyinikvvuwk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Operating system type for the configuration
     */
    @JvmName("geuihuhiwcrstcqo")
    public suspend fun osType(`value`: Output<String>) {
        this.osType = value
    }

    /**
     * @param value
     */
    @JvmName("pytymwktmyukyeym")
    public suspend fun proxySetting(`value`: Output<String>) {
        this.proxySetting = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lnvtoorejgqdioha")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ttinaerkiqiwaoko")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value the array of data source object which are configured to collect and send data
     */
    @JvmName("owfgigooeadbqsqu")
    public suspend fun dataSources(`value`: List<DataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSources = mapped
    }

    /**
     * @param argument the array of data source object which are configured to collect and send data
     */
    @JvmName("ejpcehlakuaecvvf")
    public suspend fun dataSources(argument: List<suspend DataSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DataSourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataSources = mapped
    }

    /**
     * @param argument the array of data source object which are configured to collect and send data
     */
    @JvmName("ojdhpbkrgsmcjnap")
    public suspend fun dataSources(vararg argument: suspend DataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DataSourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataSources = mapped
    }

    /**
     * @param argument the array of data source object which are configured to collect and send data
     */
    @JvmName("plugtfsqmgxckljq")
    public suspend fun dataSources(argument: suspend DataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataSources = mapped
    }

    /**
     * @param values the array of data source object which are configured to collect and send data
     */
    @JvmName("mhxbovqcubpxhhiw")
    public suspend fun dataSources(vararg values: DataSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSources = mapped
    }

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("jslmehwehmnkfqle")
    public suspend fun diagnosticSettingsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnosticSettingsName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("betqkshstdayqflc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Operating system type for the configuration
     */
    @JvmName("ytqenwkvwjehsixn")
    public suspend fun osType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value
     */
    @JvmName("mkgsnuxruypsacff")
    public suspend fun proxySetting(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxySetting = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gffvvfsaloalpidl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ychhuhuabidnowyc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("nyiwndwsshtpviux")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GuestDiagnosticsSettingArgs = GuestDiagnosticsSettingArgs(
        dataSources = dataSources,
        diagnosticSettingsName = diagnosticSettingsName,
        location = location,
        osType = osType,
        proxySetting = proxySetting,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
