@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.RetentionPolicyResponse
import com.pulumi.azurenative.insights.kotlin.outputs.RetentionPolicyResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [LogProfile].
 */
@PulumiTagMarker
public class LogProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogProfileArgs = LogProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogProfileArgsBuilder.() -> Unit) {
        val builder = LogProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LogProfile {
        val builtJavaResource = com.pulumi.azurenative.insights.LogProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LogProfile(builtJavaResource)
    }
}

/**
 * The log profile resource.
 * Azure REST API version: 2016-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * ## Example Usage
 * ### Create or update a log profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var logProfile = new AzureNative.Insights.LogProfile("logProfile", new()
 *     {
 *         Categories = new[]
 *         {
 *             "Write",
 *             "Delete",
 *             "Action",
 *         },
 *         Location = "",
 *         Locations = new[]
 *         {
 *             "global",
 *         },
 *         LogProfileName = "Rac46PostSwapRG",
 *         RetentionPolicy = new AzureNative.Insights.Inputs.RetentionPolicyArgs
 *         {
 *             Days = 3,
 *             Enabled = true,
 *         },
 *         ServiceBusRuleId = "",
 *         StorageAccountId = "/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8162",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewLogProfile(ctx, "logProfile", &insights.LogProfileArgs{
 * 			Categories: pulumi.StringArray{
 * 				pulumi.String("Write"),
 * 				pulumi.String("Delete"),
 * 				pulumi.String("Action"),
 * 			},
 * 			Location: pulumi.String(""),
 * 			Locations: pulumi.StringArray{
 * 				pulumi.String("global"),
 * 			},
 * 			LogProfileName: pulumi.String("Rac46PostSwapRG"),
 * 			RetentionPolicy: &insights.RetentionPolicyArgs{
 * 				Days:    pulumi.Int(3),
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 			ServiceBusRuleId: pulumi.String(""),
 * 			StorageAccountId: pulumi.String("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8162"),
 * 			Tags:             nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.LogProfile;
 * import com.pulumi.azurenative.insights.LogProfileArgs;
 * import com.pulumi.azurenative.insights.inputs.RetentionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var logProfile = new LogProfile("logProfile", LogProfileArgs.builder()
 *             .categories(
 *                 "Write",
 *                 "Delete",
 *                 "Action")
 *             .location("")
 *             .locations("global")
 *             .logProfileName("Rac46PostSwapRG")
 *             .retentionPolicy(RetentionPolicyArgs.builder()
 *                 .days(3)
 *                 .enabled(true)
 *                 .build())
 *             .serviceBusRuleId("")
 *             .storageAccountId("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8162")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:LogProfile default /subscriptions/{subscriptionId}/providers/Microsoft.Insights/logprofiles/{logProfileName}
 * ```
 */
public class LogProfile internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.LogProfile,
) : KotlinCustomResource(javaResource, LogProfileMapper) {
    /**
     * the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write', 'Delete', and/or 'Action.'
     */
    public val categories: Output<List<String>>
        get() = javaResource.categories().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid ARM locations including the 'global' location.
     */
    public val locations: Output<List<String>>
        get() = javaResource.locations().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * the retention policy for the events in the log.
     */
    public val retentionPolicy: Output<RetentionPolicyResponse>
        get() = javaResource.retentionPolicy().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the format: '{service bus resource ID}/authorizationrules/{key name}'.
     */
    public val serviceBusRuleId: Output<String>?
        get() = javaResource.serviceBusRuleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * the resource id of the storage account to which you would like to send the Activity Log.
     */
    public val storageAccountId: Output<String>?
        get() = javaResource.storageAccountId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LogProfileMapper : ResourceMapper<LogProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.LogProfile::class == javaResource::class

    override fun map(javaResource: Resource): LogProfile = LogProfile(
        javaResource as
            com.pulumi.azurenative.insights.LogProfile,
    )
}

/**
 * @see [LogProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogProfile].
 */
public suspend fun logProfile(name: String, block: suspend LogProfileResourceBuilder.() -> Unit): LogProfile {
    val builder = LogProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logProfile(name: String): LogProfile {
    val builder = LogProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
