@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.LogProfileArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.RetentionPolicyArgs
import com.pulumi.azurenative.insights.kotlin.inputs.RetentionPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The log profile resource.
 * Azure REST API version: 2016-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * ## Example Usage
 * ### Create or update a log profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var logProfile = new AzureNative.Insights.LogProfile("logProfile", new()
 *     {
 *         Categories = new[]
 *         {
 *             "Write",
 *             "Delete",
 *             "Action",
 *         },
 *         Location = "",
 *         Locations = new[]
 *         {
 *             "global",
 *         },
 *         LogProfileName = "Rac46PostSwapRG",
 *         RetentionPolicy = new AzureNative.Insights.Inputs.RetentionPolicyArgs
 *         {
 *             Days = 3,
 *             Enabled = true,
 *         },
 *         ServiceBusRuleId = "",
 *         StorageAccountId = "/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8162",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewLogProfile(ctx, "logProfile", &insights.LogProfileArgs{
 * 			Categories: pulumi.StringArray{
 * 				pulumi.String("Write"),
 * 				pulumi.String("Delete"),
 * 				pulumi.String("Action"),
 * 			},
 * 			Location: pulumi.String(""),
 * 			Locations: pulumi.StringArray{
 * 				pulumi.String("global"),
 * 			},
 * 			LogProfileName: pulumi.String("Rac46PostSwapRG"),
 * 			RetentionPolicy: &insights.RetentionPolicyArgs{
 * 				Days:    pulumi.Int(3),
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 			ServiceBusRuleId: pulumi.String(""),
 * 			StorageAccountId: pulumi.String("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8162"),
 * 			Tags:             nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.LogProfile;
 * import com.pulumi.azurenative.insights.LogProfileArgs;
 * import com.pulumi.azurenative.insights.inputs.RetentionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var logProfile = new LogProfile("logProfile", LogProfileArgs.builder()
 *             .categories(
 *                 "Write",
 *                 "Delete",
 *                 "Action")
 *             .location("")
 *             .locations("global")
 *             .logProfileName("Rac46PostSwapRG")
 *             .retentionPolicy(RetentionPolicyArgs.builder()
 *                 .days(3)
 *                 .enabled(true)
 *                 .build())
 *             .serviceBusRuleId("")
 *             .storageAccountId("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8162")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:LogProfile default /subscriptions/{subscriptionId}/providers/Microsoft.Insights/logprofiles/{logProfileName}
 * ```
 * @property categories the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write', 'Delete', and/or 'Action.'
 * @property location Resource location
 * @property locations List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid ARM locations including the 'global' location.
 * @property logProfileName The name of the log profile.
 * @property retentionPolicy the retention policy for the events in the log.
 * @property serviceBusRuleId The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the format: '{service bus resource ID}/authorizationrules/{key name}'.
 * @property storageAccountId the resource id of the storage account to which you would like to send the Activity Log.
 * @property tags Resource tags
 */
public data class LogProfileArgs(
    public val categories: Output<List<String>>? = null,
    public val location: Output<String>? = null,
    public val locations: Output<List<String>>? = null,
    public val logProfileName: Output<String>? = null,
    public val retentionPolicy: Output<RetentionPolicyArgs>? = null,
    public val serviceBusRuleId: Output<String>? = null,
    public val storageAccountId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.LogProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.LogProfileArgs =
        com.pulumi.azurenative.insights.LogProfileArgs.builder()
            .categories(categories?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .logProfileName(logProfileName?.applyValue({ args0 -> args0 }))
            .retentionPolicy(retentionPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceBusRuleId(serviceBusRuleId?.applyValue({ args0 -> args0 }))
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LogProfileArgs].
 */
@PulumiTagMarker
public class LogProfileArgsBuilder internal constructor() {
    private var categories: Output<List<String>>? = null

    private var location: Output<String>? = null

    private var locations: Output<List<String>>? = null

    private var logProfileName: Output<String>? = null

    private var retentionPolicy: Output<RetentionPolicyArgs>? = null

    private var serviceBusRuleId: Output<String>? = null

    private var storageAccountId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write', 'Delete', and/or 'Action.'
     */
    @JvmName("gmbtifmcakpoehlh")
    public suspend fun categories(`value`: Output<List<String>>) {
        this.categories = value
    }

    @JvmName("cnvkhitytvyunbae")
    public suspend fun categories(vararg values: Output<String>) {
        this.categories = Output.all(values.asList())
    }

    /**
     * @param values the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write', 'Delete', and/or 'Action.'
     */
    @JvmName("qtosbfqokxpsplfw")
    public suspend fun categories(values: List<Output<String>>) {
        this.categories = Output.all(values)
    }

    /**
     * @param value Resource location
     */
    @JvmName("bnrigprcvgrfkskq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid ARM locations including the 'global' location.
     */
    @JvmName("laaiqqgbmlmdvnny")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("cxmvfoawlfhjqtjd")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid ARM locations including the 'global' location.
     */
    @JvmName("ekwdyubivpuuxhve")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value The name of the log profile.
     */
    @JvmName("hqrmabbkqdlqamte")
    public suspend fun logProfileName(`value`: Output<String>) {
        this.logProfileName = value
    }

    /**
     * @param value the retention policy for the events in the log.
     */
    @JvmName("tbniptujjnewxceq")
    public suspend fun retentionPolicy(`value`: Output<RetentionPolicyArgs>) {
        this.retentionPolicy = value
    }

    /**
     * @param value The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the format: '{service bus resource ID}/authorizationrules/{key name}'.
     */
    @JvmName("rtwiofdolnfhdrlt")
    public suspend fun serviceBusRuleId(`value`: Output<String>) {
        this.serviceBusRuleId = value
    }

    /**
     * @param value the resource id of the storage account to which you would like to send the Activity Log.
     */
    @JvmName("bjobrsdnwofinudo")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("jjviidtnixgmoiew")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write', 'Delete', and/or 'Action.'
     */
    @JvmName("rnekqdvplahyvwlh")
    public suspend fun categories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param values the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write', 'Delete', and/or 'Action.'
     */
    @JvmName("orsawmgfrqsfgghb")
    public suspend fun categories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("amxsfwmmbttkrphm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid ARM locations including the 'global' location.
     */
    @JvmName("fpjywnhnstvlvjve")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid ARM locations including the 'global' location.
     */
    @JvmName("tcchwpunbmwtvygj")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value The name of the log profile.
     */
    @JvmName("lsllrugercxnvtyh")
    public suspend fun logProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logProfileName = mapped
    }

    /**
     * @param value the retention policy for the events in the log.
     */
    @JvmName("gcaijaffuhdqqpkd")
    public suspend fun retentionPolicy(`value`: RetentionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param argument the retention policy for the events in the log.
     */
    @JvmName("jkrrfhbeptlflsmw")
    public suspend fun retentionPolicy(argument: suspend RetentionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionPolicy = mapped
    }

    /**
     * @param value The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the format: '{service bus resource ID}/authorizationrules/{key name}'.
     */
    @JvmName("obteswcijdywivag")
    public suspend fun serviceBusRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusRuleId = mapped
    }

    /**
     * @param value the resource id of the storage account to which you would like to send the Activity Log.
     */
    @JvmName("xbyhwrxkftgekglm")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("jshsicgxukqtfgal")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("osphfkkbxwdwlkor")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LogProfileArgs = LogProfileArgs(
        categories = categories,
        location = location,
        locations = locations,
        logProfileName = logProfileName,
        retentionPolicy = retentionPolicy,
        serviceBusRuleId = serviceBusRuleId,
        storageAccountId = storageAccountId,
        tags = tags,
    )
}
