@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.AccessModeSettingsResponse
import com.pulumi.azurenative.insights.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.insights.kotlin.outputs.AccessModeSettingsResponse.Companion.toKotlin as accessModeSettingsResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateLinkScope].
 */
@PulumiTagMarker
public class PrivateLinkScopeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateLinkScopeArgs = PrivateLinkScopeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateLinkScopeArgsBuilder.() -> Unit) {
        val builder = PrivateLinkScopeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateLinkScope {
        val builtJavaResource =
            com.pulumi.azurenative.insights.PrivateLinkScope(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateLinkScope(builtJavaResource)
    }
}

/**
 * An Azure Monitor PrivateLinkScope definition.
 * Azure REST API version: 2021-07-01-preview. Prior API version in Azure Native 1.x: 2019-10-17-preview.
 * Other available API versions: 2019-10-17-preview.
 * ## Example Usage
 * ### PrivateLinkScopeCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkScope = new AzureNative.Insights.PrivateLinkScope("privateLinkScope", new()
 *     {
 *         AccessModeSettings = new AzureNative.Insights.Inputs.AccessModeSettingsArgs
 *         {
 *             Exclusions = new() { },
 *             IngestionAccessMode = AzureNative.Insights.AccessMode.Open,
 *             QueryAccessMode = AzureNative.Insights.AccessMode.Open,
 *         },
 *         Location = "Global",
 *         ResourceGroupName = "my-resource-group",
 *         ScopeName = "my-privatelinkscope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewPrivateLinkScope(ctx, "privateLinkScope", &insights.PrivateLinkScopeArgs{
 * 			AccessModeSettings: &insights.AccessModeSettingsArgs{
 * 				Exclusions:          insights.AccessModeSettingsExclusionArray{},
 * 				IngestionAccessMode: pulumi.String(insights.AccessModeOpen),
 * 				QueryAccessMode:     pulumi.String(insights.AccessModeOpen),
 * 			},
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ScopeName:         pulumi.String("my-privatelinkscope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.PrivateLinkScope;
 * import com.pulumi.azurenative.insights.PrivateLinkScopeArgs;
 * import com.pulumi.azurenative.insights.inputs.AccessModeSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkScope = new PrivateLinkScope("privateLinkScope", PrivateLinkScopeArgs.builder()
 *             .accessModeSettings(AccessModeSettingsArgs.builder()
 *                 .exclusions()
 *                 .ingestionAccessMode("Open")
 *                 .queryAccessMode("Open")
 *                 .build())
 *             .location("Global")
 *             .resourceGroupName("my-resource-group")
 *             .scopeName("my-privatelinkscope")
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateLinkScopeUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkScope = new AzureNative.Insights.PrivateLinkScope("privateLinkScope", new()
 *     {
 *         AccessModeSettings = new AzureNative.Insights.Inputs.AccessModeSettingsArgs
 *         {
 *             Exclusions = new() { },
 *             IngestionAccessMode = AzureNative.Insights.AccessMode.Open,
 *             QueryAccessMode = AzureNative.Insights.AccessMode.Open,
 *         },
 *         Location = "Global",
 *         ResourceGroupName = "my-resource-group",
 *         ScopeName = "my-privatelinkscope",
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewPrivateLinkScope(ctx, "privateLinkScope", &insights.PrivateLinkScopeArgs{
 * 			AccessModeSettings: &insights.AccessModeSettingsArgs{
 * 				Exclusions:          insights.AccessModeSettingsExclusionArray{},
 * 				IngestionAccessMode: pulumi.String(insights.AccessModeOpen),
 * 				QueryAccessMode:     pulumi.String(insights.AccessModeOpen),
 * 			},
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ScopeName:         pulumi.String("my-privatelinkscope"),
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.PrivateLinkScope;
 * import com.pulumi.azurenative.insights.PrivateLinkScopeArgs;
 * import com.pulumi.azurenative.insights.inputs.AccessModeSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkScope = new PrivateLinkScope("privateLinkScope", PrivateLinkScopeArgs.builder()
 *             .accessModeSettings(AccessModeSettingsArgs.builder()
 *                 .exclusions()
 *                 .ingestionAccessMode("Open")
 *                 .queryAccessMode("Open")
 *                 .build())
 *             .location("Global")
 *             .resourceGroupName("my-resource-group")
 *             .scopeName("my-privatelinkscope")
 *             .tags(Map.of("Tag1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:PrivateLinkScope my-privatelinkscope /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/privateLinkScopes/{scopeName}
 * ```
 */
public class PrivateLinkScope internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.PrivateLinkScope,
) : KotlinCustomResource(javaResource, PrivateLinkScopeMapper) {
    /**
     * Access mode settings
     */
    public val accessModeSettings: Output<AccessModeSettingsResponse>
        get() = javaResource.accessModeSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                accessModeSettingsResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of private endpoint connections.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * System data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateLinkScopeMapper : ResourceMapper<PrivateLinkScope> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.PrivateLinkScope::class == javaResource::class

    override fun map(javaResource: Resource): PrivateLinkScope = PrivateLinkScope(
        javaResource as
            com.pulumi.azurenative.insights.PrivateLinkScope,
    )
}

/**
 * @see [PrivateLinkScope].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateLinkScope].
 */
public suspend fun privateLinkScope(
    name: String,
    block: suspend PrivateLinkScopeResourceBuilder.() -> Unit,
): PrivateLinkScope {
    val builder = PrivateLinkScopeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateLinkScope].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateLinkScope(name: String): PrivateLinkScope {
    val builder = PrivateLinkScopeResourceBuilder()
    builder.name(name)
    return builder.build()
}
