@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.ProactiveDetectionConfigurationArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs
import com.pulumi.azurenative.insights.kotlin.inputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A ProactiveDetection configuration definition.
 * Azure REST API version: 2018-05-01-preview. Prior API version in Azure Native 1.x: 2015-05-01.
 * Other available API versions: 2015-05-01.
 * ## Example Usage
 * ### ProactiveDetectionConfigurationUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var proactiveDetectionConfiguration = new AzureNative.Insights.ProactiveDetectionConfiguration("proactiveDetectionConfiguration", new()
 *     {
 *         ConfigurationId = "slowpageloadtime",
 *         CustomEmails = new[]
 *         {
 *             "foo@microsoft.com",
 *             "foo2@microsoft.com",
 *         },
 *         Enabled = true,
 *         Location = "South Central US",
 *         Name = "slowpageloadtime",
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "my-component",
 *         RuleDefinitions = new AzureNative.Insights.Inputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs
 *         {
 *             Description = "Smart Detection rules notify you of performance anomaly issues.",
 *             DisplayName = "Slow page load time",
 *             HelpUrl = "https://docs.microsoft.com/en-us/azure/application-insights/app-insights-proactive-performance-diagnostics",
 *             IsEnabledByDefault = true,
 *             IsHidden = false,
 *             IsInPreview = false,
 *             Name = "slowpageloadtime",
 *             SupportsEmailNotifications = true,
 *         },
 *         SendEmailsToSubscriptionOwners = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewProactiveDetectionConfiguration(ctx, "proactiveDetectionConfiguration", &insights.ProactiveDetectionConfigurationArgs{
 * 			ConfigurationId: pulumi.String("slowpageloadtime"),
 * 			CustomEmails: pulumi.StringArray{
 * 				pulumi.String("foo@microsoft.com"),
 * 				pulumi.String("foo2@microsoft.com"),
 * 			},
 * 			Enabled:           pulumi.Bool(true),
 * 			Location:          pulumi.String("South Central US"),
 * 			Name:              pulumi.String("slowpageloadtime"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("my-component"),
 * 			RuleDefinitions: &insights.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs{
 * 				Description:                pulumi.String("Smart Detection rules notify you of performance anomaly issues."),
 * 				DisplayName:                pulumi.String("Slow page load time"),
 * 				HelpUrl:                    pulumi.String("https://docs.microsoft.com/en-us/azure/application-insights/app-insights-proactive-performance-diagnostics"),
 * 				IsEnabledByDefault:         pulumi.Bool(true),
 * 				IsHidden:                   pulumi.Bool(false),
 * 				IsInPreview:                pulumi.Bool(false),
 * 				Name:                       pulumi.String("slowpageloadtime"),
 * 				SupportsEmailNotifications: pulumi.Bool(true),
 * 			},
 * 			SendEmailsToSubscriptionOwners: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ProactiveDetectionConfiguration;
 * import com.pulumi.azurenative.insights.ProactiveDetectionConfigurationArgs;
 * import com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var proactiveDetectionConfiguration = new ProactiveDetectionConfiguration("proactiveDetectionConfiguration", ProactiveDetectionConfigurationArgs.builder()
 *             .configurationId("slowpageloadtime")
 *             .customEmails(
 *                 "foo@microsoft.com",
 *                 "foo2@microsoft.com")
 *             .enabled(true)
 *             .location("South Central US")
 *             .name("slowpageloadtime")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("my-component")
 *             .ruleDefinitions(ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs.builder()
 *                 .description("Smart Detection rules notify you of performance anomaly issues.")
 *                 .displayName("Slow page load time")
 *                 .helpUrl("https://docs.microsoft.com/en-us/azure/application-insights/app-insights-proactive-performance-diagnostics")
 *                 .isEnabledByDefault(true)
 *                 .isHidden(false)
 *                 .isInPreview(false)
 *                 .name("slowpageloadtime")
 *                 .supportsEmailNotifications(true)
 *                 .build())
 *             .sendEmailsToSubscriptionOwners(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ProactiveDetectionConfiguration slowpageloadtime /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs/{ConfigurationId}
 * ```
 * @property configurationId The ProactiveDetection configuration ID. This is unique within a Application Insights component.
 * @property customEmails Custom email addresses for this rule notifications
 * @property enabled A flag that indicates whether this rule is enabled by the user
 * @property location Resource location
 * @property name Azure resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the Application Insights component resource.
 * @property ruleDefinitions Static definitions of the ProactiveDetection configuration rule (same values for all components).
 * @property sendEmailsToSubscriptionOwners A flag that indicated whether notifications on this rule should be sent to subscription owners
 */
public data class ProactiveDetectionConfigurationArgs(
    public val configurationId: Output<String>? = null,
    public val customEmails: Output<List<String>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val ruleDefinitions: Output<ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs>? =
        null,
    public val sendEmailsToSubscriptionOwners: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.ProactiveDetectionConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.ProactiveDetectionConfigurationArgs =
        com.pulumi.azurenative.insights.ProactiveDetectionConfigurationArgs.builder()
            .configurationId(configurationId?.applyValue({ args0 -> args0 }))
            .customEmails(customEmails?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .ruleDefinitions(ruleDefinitions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sendEmailsToSubscriptionOwners(
                sendEmailsToSubscriptionOwners?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ProactiveDetectionConfigurationArgs].
 */
@PulumiTagMarker
public class ProactiveDetectionConfigurationArgsBuilder internal constructor() {
    private var configurationId: Output<String>? = null

    private var customEmails: Output<List<String>>? = null

    private var enabled: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var ruleDefinitions:
        Output<ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs>? =
        null

    private var sendEmailsToSubscriptionOwners: Output<Boolean>? = null

    /**
     * @param value The ProactiveDetection configuration ID. This is unique within a Application Insights component.
     */
    @JvmName("kjtcgsgydrubwtul")
    public suspend fun configurationId(`value`: Output<String>) {
        this.configurationId = value
    }

    /**
     * @param value Custom email addresses for this rule notifications
     */
    @JvmName("embvwtkdefvqwlaf")
    public suspend fun customEmails(`value`: Output<List<String>>) {
        this.customEmails = value
    }

    @JvmName("kbtwioixvaigxcme")
    public suspend fun customEmails(vararg values: Output<String>) {
        this.customEmails = Output.all(values.asList())
    }

    /**
     * @param values Custom email addresses for this rule notifications
     */
    @JvmName("vofeeltmvtopaeba")
    public suspend fun customEmails(values: List<Output<String>>) {
        this.customEmails = Output.all(values)
    }

    /**
     * @param value A flag that indicates whether this rule is enabled by the user
     */
    @JvmName("abpamoytpsajmdrb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("mxylvhwpgtwopmle")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Azure resource name
     */
    @JvmName("blywnjrxxemmohlo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nsyinjwjrmvdsova")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("hxadepgmlwiukunh")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Static definitions of the ProactiveDetection configuration rule (same values for all components).
     */
    @JvmName("lfpdqpcwfbfydevp")
    public suspend fun ruleDefinitions(`value`: Output<ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs>) {
        this.ruleDefinitions = value
    }

    /**
     * @param value A flag that indicated whether notifications on this rule should be sent to subscription owners
     */
    @JvmName("bgygixcwrmnbbvnr")
    public suspend fun sendEmailsToSubscriptionOwners(`value`: Output<Boolean>) {
        this.sendEmailsToSubscriptionOwners = value
    }

    /**
     * @param value The ProactiveDetection configuration ID. This is unique within a Application Insights component.
     */
    @JvmName("mcilrtfodkpekqtl")
    public suspend fun configurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationId = mapped
    }

    /**
     * @param value Custom email addresses for this rule notifications
     */
    @JvmName("ecfmfmbxrowkjeas")
    public suspend fun customEmails(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customEmails = mapped
    }

    /**
     * @param values Custom email addresses for this rule notifications
     */
    @JvmName("vbimwcwybnddysfe")
    public suspend fun customEmails(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customEmails = mapped
    }

    /**
     * @param value A flag that indicates whether this rule is enabled by the user
     */
    @JvmName("bkyxtjbaccelaqyf")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("tqopqxmewknnlfcu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Azure resource name
     */
    @JvmName("uvexckmjclxmukdq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uofdobwbvqxqiclj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("wlkwyrdejixtbjme")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Static definitions of the ProactiveDetection configuration rule (same values for all components).
     */
    @JvmName("jvkahcwbivsahork")
    public suspend fun ruleDefinitions(`value`: ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleDefinitions = mapped
    }

    /**
     * @param argument Static definitions of the ProactiveDetection configuration rule (same values for all components).
     */
    @JvmName("nediqbtwcipaacaj")
    public suspend fun ruleDefinitions(argument: suspend ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ruleDefinitions = mapped
    }

    /**
     * @param value A flag that indicated whether notifications on this rule should be sent to subscription owners
     */
    @JvmName("aafbsemhfqucjrbi")
    public suspend fun sendEmailsToSubscriptionOwners(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendEmailsToSubscriptionOwners = mapped
    }

    internal fun build(): ProactiveDetectionConfigurationArgs = ProactiveDetectionConfigurationArgs(
        configurationId = configurationId,
        customEmails = customEmails,
        enabled = enabled,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        ruleDefinitions = ruleDefinitions,
        sendEmailsToSubscriptionOwners = sendEmailsToSubscriptionOwners,
    )
}
