@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.TenantActionGroupArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.AzureAppPushReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.AzureAppPushReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.EmailReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.EmailReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.SmsReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.SmsReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.VoiceReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.VoiceReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.WebhookReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.WebhookReceiverArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A tenant action group resource.
 * Azure REST API version: 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update a tenant action group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tenantActionGroup = new AzureNative.Insights.TenantActionGroup("tenantActionGroup", new()
 *     {
 *         AzureAppPushReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AzureAppPushReceiverArgs
 *             {
 *                 EmailAddress = "johndoe@email.com",
 *                 Name = "Sample azureAppPush",
 *             },
 *         },
 *         EmailReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.EmailReceiverArgs
 *             {
 *                 EmailAddress = "johndoe@email.com",
 *                 Name = "John Doe's email",
 *                 UseCommonAlertSchema = false,
 *             },
 *             new AzureNative.Insights.Inputs.EmailReceiverArgs
 *             {
 *                 EmailAddress = "janesmith@email.com",
 *                 Name = "Jane Smith's email",
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *         Enabled = true,
 *         GroupShortName = "sample",
 *         Location = "Global",
 *         ManagementGroupId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *         SmsReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.SmsReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "John Doe's mobile",
 *                 PhoneNumber = "2062022299",
 *             },
 *             new AzureNative.Insights.Inputs.SmsReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "Jane Smith's mobile",
 *                 PhoneNumber = "0987654321",
 *             },
 *         },
 *         Tags = null,
 *         TenantActionGroupName = "testTenantActionGroup",
 *         VoiceReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.VoiceReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "Sample voice",
 *                 PhoneNumber = "2062022299",
 *             },
 *         },
 *         WebhookReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.WebhookReceiverArgs
 *             {
 *                 Name = "Sample webhook 1",
 *                 ServiceUri = "http://www.example.com/webhook1",
 *                 UseCommonAlertSchema = true,
 *             },
 *             new AzureNative.Insights.Inputs.WebhookReceiverArgs
 *             {
 *                 IdentifierUri = "http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a",
 *                 Name = "Sample webhook 2",
 *                 ObjectId = "d3bb868c-fe44-452c-aa26-769a6538c808",
 *                 ServiceUri = "http://www.example.com/webhook2",
 *                 TenantId = "68a4459a-ccb8-493c-b9da-dd30457d1b84",
 *                 UseAadAuth = true,
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewTenantActionGroup(ctx, "tenantActionGroup", &insights.TenantActionGroupArgs{
 * 			AzureAppPushReceivers: insights.AzureAppPushReceiverArray{
 * 				&insights.AzureAppPushReceiverArgs{
 * 					EmailAddress: pulumi.String("johndoe@email.com"),
 * 					Name:         pulumi.String("Sample azureAppPush"),
 * 				},
 * 			},
 * 			EmailReceivers: insights.EmailReceiverArray{
 * 				&insights.EmailReceiverArgs{
 * 					EmailAddress:         pulumi.String("johndoe@email.com"),
 * 					Name:                 pulumi.String("John Doe's email"),
 * 					UseCommonAlertSchema: pulumi.Bool(false),
 * 				},
 * 				&insights.EmailReceiverArgs{
 * 					EmailAddress:         pulumi.String("janesmith@email.com"),
 * 					Name:                 pulumi.String("Jane Smith's email"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 			},
 * 			Enabled:           pulumi.Bool(true),
 * 			GroupShortName:    pulumi.String("sample"),
 * 			Location:          pulumi.String("Global"),
 * 			ManagementGroupId: pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 			SmsReceivers: insights.SmsReceiverArray{
 * 				&insights.SmsReceiverArgs{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("John Doe's mobile"),
 * 					PhoneNumber: pulumi.String("2062022299"),
 * 				},
 * 				&insights.SmsReceiverArgs{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("Jane Smith's mobile"),
 * 					PhoneNumber: pulumi.String("0987654321"),
 * 				},
 * 			},
 * 			Tags:                  nil,
 * 			TenantActionGroupName: pulumi.String("testTenantActionGroup"),
 * 			VoiceReceivers: insights.VoiceReceiverArray{
 * 				&insights.VoiceReceiverArgs{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("Sample voice"),
 * 					PhoneNumber: pulumi.String("2062022299"),
 * 				},
 * 			},
 * 			WebhookReceivers: insights.WebhookReceiverArray{
 * 				&insights.WebhookReceiverArgs{
 * 					Name:                 pulumi.String("Sample webhook 1"),
 * 					ServiceUri:           pulumi.String("http://www.example.com/webhook1"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 				&insights.WebhookReceiverArgs{
 * 					IdentifierUri:        pulumi.String("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
 * 					Name:                 pulumi.String("Sample webhook 2"),
 * 					ObjectId:             pulumi.String("d3bb868c-fe44-452c-aa26-769a6538c808"),
 * 					ServiceUri:           pulumi.String("http://www.example.com/webhook2"),
 * 					TenantId:             pulumi.String("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
 * 					UseAadAuth:           pulumi.Bool(true),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.TenantActionGroup;
 * import com.pulumi.azurenative.insights.TenantActionGroupArgs;
 * import com.pulumi.azurenative.insights.inputs.AzureAppPushReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.EmailReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.SmsReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.VoiceReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.WebhookReceiverArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tenantActionGroup = new TenantActionGroup("tenantActionGroup", TenantActionGroupArgs.builder()
 *             .azureAppPushReceivers(AzureAppPushReceiverArgs.builder()
 *                 .emailAddress("johndoe@email.com")
 *                 .name("Sample azureAppPush")
 *                 .build())
 *             .emailReceivers(
 *                 EmailReceiverArgs.builder()
 *                     .emailAddress("johndoe@email.com")
 *                     .name("John Doe's email")
 *                     .useCommonAlertSchema(false)
 *                     .build(),
 *                 EmailReceiverArgs.builder()
 *                     .emailAddress("janesmith@email.com")
 *                     .name("Jane Smith's email")
 *                     .useCommonAlertSchema(true)
 *                     .build())
 *             .enabled(true)
 *             .groupShortName("sample")
 *             .location("Global")
 *             .managementGroupId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *             .smsReceivers(
 *                 SmsReceiverArgs.builder()
 *                     .countryCode("1")
 *                     .name("John Doe's mobile")
 *                     .phoneNumber("2062022299")
 *                     .build(),
 *                 SmsReceiverArgs.builder()
 *                     .countryCode("1")
 *                     .name("Jane Smith's mobile")
 *                     .phoneNumber("0987654321")
 *                     .build())
 *             .tags()
 *             .tenantActionGroupName("testTenantActionGroup")
 *             .voiceReceivers(VoiceReceiverArgs.builder()
 *                 .countryCode("1")
 *                 .name("Sample voice")
 *                 .phoneNumber("2062022299")
 *                 .build())
 *             .webhookReceivers(
 *                 WebhookReceiverArgs.builder()
 *                     .name("Sample webhook 1")
 *                     .serviceUri("http://www.example.com/webhook1")
 *                     .useCommonAlertSchema(true)
 *                     .build(),
 *                 WebhookReceiverArgs.builder()
 *                     .identifierUri("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a")
 *                     .name("Sample webhook 2")
 *                     .objectId("d3bb868c-fe44-452c-aa26-769a6538c808")
 *                     .serviceUri("http://www.example.com/webhook2")
 *                     .tenantId("68a4459a-ccb8-493c-b9da-dd30457d1b84")
 *                     .useAadAuth(true)
 *                     .useCommonAlertSchema(true)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:TenantActionGroup testTenantActionGroup /providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Insights/tenantActionGroups/{tenantActionGroupName}
 * ```
 * @property azureAppPushReceivers The list of AzureAppPush receivers that are part of this tenant action group.
 * @property emailReceivers The list of email receivers that are part of this tenant action group.
 * @property enabled Indicates whether this tenant action group is enabled. If a tenant action group is not enabled, then none of its receivers will receive communications.
 * @property groupShortName The short name of the action group. This will be used in SMS messages.
 * @property location Resource location
 * @property managementGroupId The management group id.
 * @property smsReceivers The list of SMS receivers that are part of this tenant action group.
 * @property tags Resource tags
 * @property tenantActionGroupName The name of the action group.
 * @property voiceReceivers The list of voice receivers that are part of this tenant action group.
 * @property webhookReceivers The list of webhook receivers that are part of this tenant action group.
 */
public data class TenantActionGroupArgs(
    public val azureAppPushReceivers: Output<List<AzureAppPushReceiverArgs>>? = null,
    public val emailReceivers: Output<List<EmailReceiverArgs>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val groupShortName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managementGroupId: Output<String>? = null,
    public val smsReceivers: Output<List<SmsReceiverArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tenantActionGroupName: Output<String>? = null,
    public val voiceReceivers: Output<List<VoiceReceiverArgs>>? = null,
    public val webhookReceivers: Output<List<WebhookReceiverArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.TenantActionGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.TenantActionGroupArgs =
        com.pulumi.azurenative.insights.TenantActionGroupArgs.builder()
            .azureAppPushReceivers(
                azureAppPushReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .emailReceivers(
                emailReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .groupShortName(groupShortName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managementGroupId(managementGroupId?.applyValue({ args0 -> args0 }))
            .smsReceivers(
                smsReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tenantActionGroupName(tenantActionGroupName?.applyValue({ args0 -> args0 }))
            .voiceReceivers(
                voiceReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .webhookReceivers(
                webhookReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TenantActionGroupArgs].
 */
@PulumiTagMarker
public class TenantActionGroupArgsBuilder internal constructor() {
    private var azureAppPushReceivers: Output<List<AzureAppPushReceiverArgs>>? = null

    private var emailReceivers: Output<List<EmailReceiverArgs>>? = null

    private var enabled: Output<Boolean>? = null

    private var groupShortName: Output<String>? = null

    private var location: Output<String>? = null

    private var managementGroupId: Output<String>? = null

    private var smsReceivers: Output<List<SmsReceiverArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tenantActionGroupName: Output<String>? = null

    private var voiceReceivers: Output<List<VoiceReceiverArgs>>? = null

    private var webhookReceivers: Output<List<WebhookReceiverArgs>>? = null

    /**
     * @param value The list of AzureAppPush receivers that are part of this tenant action group.
     */
    @JvmName("vxugwwmovddbjumr")
    public suspend fun azureAppPushReceivers(`value`: Output<List<AzureAppPushReceiverArgs>>) {
        this.azureAppPushReceivers = value
    }

    @JvmName("gydgoenumyrclqyy")
    public suspend fun azureAppPushReceivers(vararg values: Output<AzureAppPushReceiverArgs>) {
        this.azureAppPushReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of AzureAppPush receivers that are part of this tenant action group.
     */
    @JvmName("thuhumkpeuavffll")
    public suspend fun azureAppPushReceivers(values: List<Output<AzureAppPushReceiverArgs>>) {
        this.azureAppPushReceivers = Output.all(values)
    }

    /**
     * @param value The list of email receivers that are part of this tenant action group.
     */
    @JvmName("tvcsahcmdwwuhedo")
    public suspend fun emailReceivers(`value`: Output<List<EmailReceiverArgs>>) {
        this.emailReceivers = value
    }

    @JvmName("ewwrcikrmhttmopv")
    public suspend fun emailReceivers(vararg values: Output<EmailReceiverArgs>) {
        this.emailReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of email receivers that are part of this tenant action group.
     */
    @JvmName("kjhpbdrlbyqibxul")
    public suspend fun emailReceivers(values: List<Output<EmailReceiverArgs>>) {
        this.emailReceivers = Output.all(values)
    }

    /**
     * @param value Indicates whether this tenant action group is enabled. If a tenant action group is not enabled, then none of its receivers will receive communications.
     */
    @JvmName("jtbdvxcvwgfsovck")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The short name of the action group. This will be used in SMS messages.
     */
    @JvmName("xiywlfnlnjruglwp")
    public suspend fun groupShortName(`value`: Output<String>) {
        this.groupShortName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("lwcrkdovmvclqadr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The management group id.
     */
    @JvmName("pmkulfmfrcxcxgnh")
    public suspend fun managementGroupId(`value`: Output<String>) {
        this.managementGroupId = value
    }

    /**
     * @param value The list of SMS receivers that are part of this tenant action group.
     */
    @JvmName("huqhcvkpsehfspsl")
    public suspend fun smsReceivers(`value`: Output<List<SmsReceiverArgs>>) {
        this.smsReceivers = value
    }

    @JvmName("mgyrbwerudpwaygb")
    public suspend fun smsReceivers(vararg values: Output<SmsReceiverArgs>) {
        this.smsReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of SMS receivers that are part of this tenant action group.
     */
    @JvmName("bbyevjtjxetqjlpj")
    public suspend fun smsReceivers(values: List<Output<SmsReceiverArgs>>) {
        this.smsReceivers = Output.all(values)
    }

    /**
     * @param value Resource tags
     */
    @JvmName("orchyfcnaewumixa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the action group.
     */
    @JvmName("vddkceecqjqbrfwl")
    public suspend fun tenantActionGroupName(`value`: Output<String>) {
        this.tenantActionGroupName = value
    }

    /**
     * @param value The list of voice receivers that are part of this tenant action group.
     */
    @JvmName("csgcjomvmxemiuxn")
    public suspend fun voiceReceivers(`value`: Output<List<VoiceReceiverArgs>>) {
        this.voiceReceivers = value
    }

    @JvmName("tetmtkyppyqsyfgo")
    public suspend fun voiceReceivers(vararg values: Output<VoiceReceiverArgs>) {
        this.voiceReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of voice receivers that are part of this tenant action group.
     */
    @JvmName("rtycqaqaumucgwvm")
    public suspend fun voiceReceivers(values: List<Output<VoiceReceiverArgs>>) {
        this.voiceReceivers = Output.all(values)
    }

    /**
     * @param value The list of webhook receivers that are part of this tenant action group.
     */
    @JvmName("xulnmfbgtexndojo")
    public suspend fun webhookReceivers(`value`: Output<List<WebhookReceiverArgs>>) {
        this.webhookReceivers = value
    }

    @JvmName("uaykkatneqgilxtm")
    public suspend fun webhookReceivers(vararg values: Output<WebhookReceiverArgs>) {
        this.webhookReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of webhook receivers that are part of this tenant action group.
     */
    @JvmName("hdjsetdiprbjlbbf")
    public suspend fun webhookReceivers(values: List<Output<WebhookReceiverArgs>>) {
        this.webhookReceivers = Output.all(values)
    }

    /**
     * @param value The list of AzureAppPush receivers that are part of this tenant action group.
     */
    @JvmName("rcfmaqgvsnerqmpt")
    public suspend fun azureAppPushReceivers(`value`: List<AzureAppPushReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param argument The list of AzureAppPush receivers that are part of this tenant action group.
     */
    @JvmName("gxqrbundugdmvqoj")
    public suspend fun azureAppPushReceivers(argument: List<suspend AzureAppPushReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureAppPushReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param argument The list of AzureAppPush receivers that are part of this tenant action group.
     */
    @JvmName("vqiadauvbfdqspsx")
    public suspend fun azureAppPushReceivers(vararg argument: suspend AzureAppPushReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AzureAppPushReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param argument The list of AzureAppPush receivers that are part of this tenant action group.
     */
    @JvmName("fmjrgdhsdsgwqcia")
    public suspend fun azureAppPushReceivers(argument: suspend AzureAppPushReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AzureAppPushReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param values The list of AzureAppPush receivers that are part of this tenant action group.
     */
    @JvmName("kguqbkgufpbrbjhm")
    public suspend fun azureAppPushReceivers(vararg values: AzureAppPushReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param value The list of email receivers that are part of this tenant action group.
     */
    @JvmName("hfnsjbabaegmrcoy")
    public suspend fun emailReceivers(`value`: List<EmailReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailReceivers = mapped
    }

    /**
     * @param argument The list of email receivers that are part of this tenant action group.
     */
    @JvmName("djibxfidwlfsybkn")
    public suspend fun emailReceivers(argument: List<suspend EmailReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EmailReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.emailReceivers = mapped
    }

    /**
     * @param argument The list of email receivers that are part of this tenant action group.
     */
    @JvmName("tyclupqqnpcjpnde")
    public suspend fun emailReceivers(vararg argument: suspend EmailReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EmailReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.emailReceivers = mapped
    }

    /**
     * @param argument The list of email receivers that are part of this tenant action group.
     */
    @JvmName("gmqwxxpovfvkvbit")
    public suspend fun emailReceivers(argument: suspend EmailReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EmailReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.emailReceivers = mapped
    }

    /**
     * @param values The list of email receivers that are part of this tenant action group.
     */
    @JvmName("gwhlqjjwjmimxwvf")
    public suspend fun emailReceivers(vararg values: EmailReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailReceivers = mapped
    }

    /**
     * @param value Indicates whether this tenant action group is enabled. If a tenant action group is not enabled, then none of its receivers will receive communications.
     */
    @JvmName("muarweutuytoycdx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The short name of the action group. This will be used in SMS messages.
     */
    @JvmName("hookmeeysbiugoqg")
    public suspend fun groupShortName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupShortName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("kvfitwqqndqibbyg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The management group id.
     */
    @JvmName("perijpwbeqfohiej")
    public suspend fun managementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementGroupId = mapped
    }

    /**
     * @param value The list of SMS receivers that are part of this tenant action group.
     */
    @JvmName("bxyjvtqpublpqkos")
    public suspend fun smsReceivers(`value`: List<SmsReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smsReceivers = mapped
    }

    /**
     * @param argument The list of SMS receivers that are part of this tenant action group.
     */
    @JvmName("rrfjnxyvalqkyyyw")
    public suspend fun smsReceivers(argument: List<suspend SmsReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SmsReceiverArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.smsReceivers = mapped
    }

    /**
     * @param argument The list of SMS receivers that are part of this tenant action group.
     */
    @JvmName("rfwqlfbrfnxqlnnv")
    public suspend fun smsReceivers(vararg argument: suspend SmsReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SmsReceiverArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.smsReceivers = mapped
    }

    /**
     * @param argument The list of SMS receivers that are part of this tenant action group.
     */
    @JvmName("husprsmbcqvaawld")
    public suspend fun smsReceivers(argument: suspend SmsReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SmsReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.smsReceivers = mapped
    }

    /**
     * @param values The list of SMS receivers that are part of this tenant action group.
     */
    @JvmName("nbaebtaeojnbkkqo")
    public suspend fun smsReceivers(vararg values: SmsReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.smsReceivers = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("fbcxryiqarlucfam")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("glcvlphdpgbiqkti")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the action group.
     */
    @JvmName("intvhbjlxetbplam")
    public suspend fun tenantActionGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantActionGroupName = mapped
    }

    /**
     * @param value The list of voice receivers that are part of this tenant action group.
     */
    @JvmName("owdatflstjcmsbqp")
    public suspend fun voiceReceivers(`value`: List<VoiceReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceReceivers = mapped
    }

    /**
     * @param argument The list of voice receivers that are part of this tenant action group.
     */
    @JvmName("mfhhchflreaiktle")
    public suspend fun voiceReceivers(argument: List<suspend VoiceReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VoiceReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.voiceReceivers = mapped
    }

    /**
     * @param argument The list of voice receivers that are part of this tenant action group.
     */
    @JvmName("itjexsivffryjkle")
    public suspend fun voiceReceivers(vararg argument: suspend VoiceReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VoiceReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.voiceReceivers = mapped
    }

    /**
     * @param argument The list of voice receivers that are part of this tenant action group.
     */
    @JvmName("eqbcbgopxatkonyi")
    public suspend fun voiceReceivers(argument: suspend VoiceReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VoiceReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.voiceReceivers = mapped
    }

    /**
     * @param values The list of voice receivers that are part of this tenant action group.
     */
    @JvmName("bnieefwobnlmswqe")
    public suspend fun voiceReceivers(vararg values: VoiceReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.voiceReceivers = mapped
    }

    /**
     * @param value The list of webhook receivers that are part of this tenant action group.
     */
    @JvmName("lrkwfhqdlolhmdxw")
    public suspend fun webhookReceivers(`value`: List<WebhookReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookReceivers = mapped
    }

    /**
     * @param argument The list of webhook receivers that are part of this tenant action group.
     */
    @JvmName("dfauuvmgcxpspqda")
    public suspend fun webhookReceivers(argument: List<suspend WebhookReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebhookReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.webhookReceivers = mapped
    }

    /**
     * @param argument The list of webhook receivers that are part of this tenant action group.
     */
    @JvmName("qjmstogjlmnknmku")
    public suspend fun webhookReceivers(vararg argument: suspend WebhookReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebhookReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.webhookReceivers = mapped
    }

    /**
     * @param argument The list of webhook receivers that are part of this tenant action group.
     */
    @JvmName("oifkvdyqdpefqyvn")
    public suspend fun webhookReceivers(argument: suspend WebhookReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebhookReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.webhookReceivers = mapped
    }

    /**
     * @param values The list of webhook receivers that are part of this tenant action group.
     */
    @JvmName("kjddfrjvbpanehei")
    public suspend fun webhookReceivers(vararg values: WebhookReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webhookReceivers = mapped
    }

    internal fun build(): TenantActionGroupArgs = TenantActionGroupArgs(
        azureAppPushReceivers = azureAppPushReceivers,
        emailReceivers = emailReceivers,
        enabled = enabled,
        groupShortName = groupShortName,
        location = location,
        managementGroupId = managementGroupId,
        smsReceivers = smsReceivers,
        tags = tags,
        tenantActionGroupName = tenantActionGroupName,
        voiceReceivers = voiceReceivers,
        webhookReceivers = webhookReceivers,
    )
}
