@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of application being monitored.
 */
public enum class ApplicationType(
    public val javaValue: com.pulumi.azurenative.insights.enums.ApplicationType,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.ApplicationType> {
    Web(com.pulumi.azurenative.insights.enums.ApplicationType.Web),
    Other(com.pulumi.azurenative.insights.enums.ApplicationType.Other),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.ApplicationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.ApplicationType): ApplicationType = ApplicationType.values().first { it.javaValue == javaType }
    }
}
