@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
 */
public enum class ItemScope(
    public val javaValue: com.pulumi.azurenative.insights.enums.ItemScope,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.ItemScope> {
    Shared(com.pulumi.azurenative.insights.enums.ItemScope.Shared),
    User(com.pulumi.azurenative.insights.enums.ItemScope.User),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.ItemScope = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.ItemScope): ItemScope =
            ItemScope.values().first { it.javaValue == javaType }
    }
}
