@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The configuration to set whether network access from public internet to the endpoints are allowed.
 */
public enum class KnownPublicNetworkAccessOptions(
    public val javaValue: com.pulumi.azurenative.insights.enums.KnownPublicNetworkAccessOptions,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.KnownPublicNetworkAccessOptions> {
    Enabled(com.pulumi.azurenative.insights.enums.KnownPublicNetworkAccessOptions.Enabled),
    Disabled(com.pulumi.azurenative.insights.enums.KnownPublicNetworkAccessOptions.Disabled),
    SecuredByPerimeter(com.pulumi.azurenative.insights.enums.KnownPublicNetworkAccessOptions.SecuredByPerimeter),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.KnownPublicNetworkAccessOptions =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.KnownPublicNetworkAccessOptions): KnownPublicNetworkAccessOptions =
            KnownPublicNetworkAccessOptions.values().first { it.javaValue == javaType }
    }
}
