@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * the metric statistic type. How the metrics from multiple instances are combined.
 */
public enum class MetricStatisticType(
    public val javaValue: com.pulumi.azurenative.insights.enums.MetricStatisticType,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.MetricStatisticType> {
    Average(com.pulumi.azurenative.insights.enums.MetricStatisticType.Average),
    Min(com.pulumi.azurenative.insights.enums.MetricStatisticType.Min),
    Max(com.pulumi.azurenative.insights.enums.MetricStatisticType.Max),
    Sum(com.pulumi.azurenative.insights.enums.MetricStatisticType.Sum),
    Count(com.pulumi.azurenative.insights.enums.MetricStatisticType.Count),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.MetricStatisticType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.MetricStatisticType): MetricStatisticType = MetricStatisticType.values().first { it.javaValue == javaType }
    }
}
