@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.
 */
public enum class RecurrenceFrequency(
    public val javaValue: com.pulumi.azurenative.insights.enums.RecurrenceFrequency,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.RecurrenceFrequency> {
    None(com.pulumi.azurenative.insights.enums.RecurrenceFrequency.None),
    Second(com.pulumi.azurenative.insights.enums.RecurrenceFrequency.Second),
    Minute(com.pulumi.azurenative.insights.enums.RecurrenceFrequency.Minute),
    Hour(com.pulumi.azurenative.insights.enums.RecurrenceFrequency.Hour),
    Day(com.pulumi.azurenative.insights.enums.RecurrenceFrequency.Day),
    Week(com.pulumi.azurenative.insights.enums.RecurrenceFrequency.Week),
    Month(com.pulumi.azurenative.insights.enums.RecurrenceFrequency.Month),
    Year(com.pulumi.azurenative.insights.enums.RecurrenceFrequency.Year),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.RecurrenceFrequency = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.RecurrenceFrequency): RecurrenceFrequency = RecurrenceFrequency.values().first { it.javaValue == javaType }
    }
}
