@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * time aggregation type. How the data that is collected should be combined over time. The default value is Average.
 */
public enum class TimeAggregationType(
    public val javaValue: com.pulumi.azurenative.insights.enums.TimeAggregationType,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.TimeAggregationType> {
    Average(com.pulumi.azurenative.insights.enums.TimeAggregationType.Average),
    Minimum(com.pulumi.azurenative.insights.enums.TimeAggregationType.Minimum),
    Maximum(com.pulumi.azurenative.insights.enums.TimeAggregationType.Maximum),
    Total(com.pulumi.azurenative.insights.enums.TimeAggregationType.Total),
    Count(com.pulumi.azurenative.insights.enums.TimeAggregationType.Count),
    Last(com.pulumi.azurenative.insights.enums.TimeAggregationType.Last),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.TimeAggregationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.TimeAggregationType): TimeAggregationType = TimeAggregationType.values().first { it.javaValue == javaType }
    }
}
