@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The kind of web test this is, valid choices are ping, multistep and standard.
 */
public enum class WebTestKind(
    public val javaValue: com.pulumi.azurenative.insights.enums.WebTestKind,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.WebTestKind> {
    Ping(com.pulumi.azurenative.insights.enums.WebTestKind.Ping),
    Multistep(com.pulumi.azurenative.insights.enums.WebTestKind.Multistep),
    Standard(com.pulumi.azurenative.insights.enums.WebTestKind.Standard),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.WebTestKind = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.WebTestKind): WebTestKind =
            WebTestKind.values().first { it.javaValue == javaType }
    }
}
