@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ActionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Actions to invoke when the alert fires.
 * @property actionGroups Action Group resource Ids to invoke when the alert fires.
 * @property actionProperties The properties of an action properties.
 * @property customProperties The properties of an alert payload.
 */
public data class ActionsArgs(
    public val actionGroups: Output<List<String>>? = null,
    public val actionProperties: Output<Map<String, String>>? = null,
    public val customProperties: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ActionsArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ActionsArgs =
        com.pulumi.azurenative.insights.inputs.ActionsArgs.builder()
            .actionGroups(actionGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .actionProperties(
                actionProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .customProperties(
                customProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ActionsArgs].
 */
@PulumiTagMarker
public class ActionsArgsBuilder internal constructor() {
    private var actionGroups: Output<List<String>>? = null

    private var actionProperties: Output<Map<String, String>>? = null

    private var customProperties: Output<Map<String, String>>? = null

    /**
     * @param value Action Group resource Ids to invoke when the alert fires.
     */
    @JvmName("bkrciyjerqnvtjla")
    public suspend fun actionGroups(`value`: Output<List<String>>) {
        this.actionGroups = value
    }

    @JvmName("pgjacjlqmcvwtaht")
    public suspend fun actionGroups(vararg values: Output<String>) {
        this.actionGroups = Output.all(values.asList())
    }

    /**
     * @param values Action Group resource Ids to invoke when the alert fires.
     */
    @JvmName("xxtcihiknlnftiri")
    public suspend fun actionGroups(values: List<Output<String>>) {
        this.actionGroups = Output.all(values)
    }

    /**
     * @param value The properties of an action properties.
     */
    @JvmName("wlbmxpvfvbkfboud")
    public suspend fun actionProperties(`value`: Output<Map<String, String>>) {
        this.actionProperties = value
    }

    /**
     * @param value The properties of an alert payload.
     */
    @JvmName("rblirexursefyqjo")
    public suspend fun customProperties(`value`: Output<Map<String, String>>) {
        this.customProperties = value
    }

    /**
     * @param value Action Group resource Ids to invoke when the alert fires.
     */
    @JvmName("geqneoseqsgajxdi")
    public suspend fun actionGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionGroups = mapped
    }

    /**
     * @param values Action Group resource Ids to invoke when the alert fires.
     */
    @JvmName("emclguulqdaixvxa")
    public suspend fun actionGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionGroups = mapped
    }

    /**
     * @param value The properties of an action properties.
     */
    @JvmName("kgjobyxahveamofp")
    public suspend fun actionProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionProperties = mapped
    }

    /**
     * @param values The properties of an action properties.
     */
    @JvmName("ulutghheauxlidnm")
    public fun actionProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionProperties = mapped
    }

    /**
     * @param value The properties of an alert payload.
     */
    @JvmName("joeqklvghqmruyjn")
    public suspend fun customProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param values The properties of an alert payload.
     */
    @JvmName("eterwrekwvcqfwll")
    public fun customProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    internal fun build(): ActionsArgs = ActionsArgs(
        actionGroups = actionGroups,
        actionProperties = actionProperties,
        customProperties = customProperties,
    )
}
