@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.AlertRuleAnyOfOrLeafConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An Activity Log Alert rule condition that is met when all its member conditions are met.
 * Each condition can be of one of the following types:
 * __Important__: Each type has its unique subset of properties. Properties from different types CANNOT exist in one condition.
 *    * __Leaf Condition -__ must contain 'field' and either 'equals' or 'containsAny'.
 *   _Please note, 'anyOf' should __not__ be set in a Leaf Condition._
 *   * __AnyOf Condition -__ must contain __only__ 'anyOf' (which is an array of Leaf Conditions).
 *   _Please note, 'field', 'equals' and 'containsAny' should __not__ be set in an AnyOf Condition._
 * @property anyOf An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
 * @property containsAny The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
 * @property equals The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
 * @property field The name of the Activity Log event's field that this condition will examine.
 * The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
 */
public data class AlertRuleAnyOfOrLeafConditionArgs(
    public val anyOf: Output<List<AlertRuleLeafConditionArgs>>? = null,
    public val containsAny: Output<List<String>>? = null,
    public val equals: Output<String>? = null,
    public val `field`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.AlertRuleAnyOfOrLeafConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.AlertRuleAnyOfOrLeafConditionArgs =
        com.pulumi.azurenative.insights.inputs.AlertRuleAnyOfOrLeafConditionArgs.builder()
            .anyOf(anyOf?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .containsAny(containsAny?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .equals_(equals?.applyValue({ args0 -> args0 }))
            .`field`(`field`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertRuleAnyOfOrLeafConditionArgs].
 */
@PulumiTagMarker
public class AlertRuleAnyOfOrLeafConditionArgsBuilder internal constructor() {
    private var anyOf: Output<List<AlertRuleLeafConditionArgs>>? = null

    private var containsAny: Output<List<String>>? = null

    private var equals: Output<String>? = null

    private var `field`: Output<String>? = null

    /**
     * @param value An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
     */
    @JvmName("plytrenvhejpvahw")
    public suspend fun anyOf(`value`: Output<List<AlertRuleLeafConditionArgs>>) {
        this.anyOf = value
    }

    @JvmName("hfbwhnctnihoyydd")
    public suspend fun anyOf(vararg values: Output<AlertRuleLeafConditionArgs>) {
        this.anyOf = Output.all(values.asList())
    }

    /**
     * @param values An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
     */
    @JvmName("ciwfwtafiashhjww")
    public suspend fun anyOf(values: List<Output<AlertRuleLeafConditionArgs>>) {
        this.anyOf = Output.all(values)
    }

    /**
     * @param value The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
     */
    @JvmName("ncoshgybgaawqpkt")
    public suspend fun containsAny(`value`: Output<List<String>>) {
        this.containsAny = value
    }

    @JvmName("bbjgpmepvkiobpnl")
    public suspend fun containsAny(vararg values: Output<String>) {
        this.containsAny = Output.all(values.asList())
    }

    /**
     * @param values The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
     */
    @JvmName("bhiuuwifqjacmuit")
    public suspend fun containsAny(values: List<Output<String>>) {
        this.containsAny = Output.all(values)
    }

    /**
     * @param value The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
     */
    @JvmName("ewynlggmfodupbui")
    public suspend fun equals(`value`: Output<String>) {
        this.equals = value
    }

    /**
     * @param value The name of the Activity Log event's field that this condition will examine.
     * The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
     */
    @JvmName("svqftgpjmidevysm")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
     */
    @JvmName("mfhyjmibvyxqomyq")
    public suspend fun anyOf(`value`: List<AlertRuleLeafConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.anyOf = mapped
    }

    /**
     * @param argument An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
     */
    @JvmName("hywvnhaiudworkbm")
    public suspend fun anyOf(argument: List<suspend AlertRuleLeafConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlertRuleLeafConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.anyOf = mapped
    }

    /**
     * @param argument An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
     */
    @JvmName("gavifvxlwejndnmm")
    public suspend fun anyOf(vararg argument: suspend AlertRuleLeafConditionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlertRuleLeafConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.anyOf = mapped
    }

    /**
     * @param argument An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
     */
    @JvmName("lpjeatvbdwkeccsm")
    public suspend fun anyOf(argument: suspend AlertRuleLeafConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AlertRuleLeafConditionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.anyOf = mapped
    }

    /**
     * @param values An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
     */
    @JvmName("gditrufxqpbmosjf")
    public suspend fun anyOf(vararg values: AlertRuleLeafConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.anyOf = mapped
    }

    /**
     * @param value The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
     */
    @JvmName("yaxoyfpykfexfady")
    public suspend fun containsAny(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containsAny = mapped
    }

    /**
     * @param values The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
     */
    @JvmName("qevpgbotoongogaa")
    public suspend fun containsAny(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containsAny = mapped
    }

    /**
     * @param value The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
     */
    @JvmName("cjpoaihhgqdtwtxl")
    public suspend fun equals(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.equals = mapped
    }

    /**
     * @param value The name of the Activity Log event's field that this condition will examine.
     * The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
     */
    @JvmName("xlrhjtsotoaifeih")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    internal fun build(): AlertRuleAnyOfOrLeafConditionArgs = AlertRuleAnyOfOrLeafConditionArgs(
        anyOf = anyOf,
        containsAny = containsAny,
        equals = equals,
        `field` = `field`,
    )
}
