@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.AutoscaleProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Autoscale profile.
 * @property capacity the number of instances that can be used during this profile.
 * @property fixedDate the specific date-time for the profile. This element is not used if the Recurrence element is used.
 * @property name the name of the profile.
 * @property recurrence the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
 * @property rules the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
 */
public data class AutoscaleProfileArgs(
    public val capacity: Output<ScaleCapacityArgs>,
    public val fixedDate: Output<TimeWindowArgs>? = null,
    public val name: Output<String>,
    public val recurrence: Output<RecurrenceArgs>? = null,
    public val rules: Output<List<ScaleRuleArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.AutoscaleProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.AutoscaleProfileArgs =
        com.pulumi.azurenative.insights.inputs.AutoscaleProfileArgs.builder()
            .capacity(capacity.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fixedDate(fixedDate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .recurrence(recurrence?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rules(
                rules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AutoscaleProfileArgs].
 */
@PulumiTagMarker
public class AutoscaleProfileArgsBuilder internal constructor() {
    private var capacity: Output<ScaleCapacityArgs>? = null

    private var fixedDate: Output<TimeWindowArgs>? = null

    private var name: Output<String>? = null

    private var recurrence: Output<RecurrenceArgs>? = null

    private var rules: Output<List<ScaleRuleArgs>>? = null

    /**
     * @param value the number of instances that can be used during this profile.
     */
    @JvmName("bvqcglcfmyuyvtct")
    public suspend fun capacity(`value`: Output<ScaleCapacityArgs>) {
        this.capacity = value
    }

    /**
     * @param value the specific date-time for the profile. This element is not used if the Recurrence element is used.
     */
    @JvmName("mjkivwotxyibxltd")
    public suspend fun fixedDate(`value`: Output<TimeWindowArgs>) {
        this.fixedDate = value
    }

    /**
     * @param value the name of the profile.
     */
    @JvmName("yasyhnorricxefhi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
     */
    @JvmName("rofasfpeyxjgbudv")
    public suspend fun recurrence(`value`: Output<RecurrenceArgs>) {
        this.recurrence = value
    }

    /**
     * @param value the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
     */
    @JvmName("mrgdbiyjluqstydy")
    public suspend fun rules(`value`: Output<List<ScaleRuleArgs>>) {
        this.rules = value
    }

    @JvmName("oiierheffngtedwt")
    public suspend fun rules(vararg values: Output<ScaleRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
     */
    @JvmName("fjorjjusuhgvkxbo")
    public suspend fun rules(values: List<Output<ScaleRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value the number of instances that can be used during this profile.
     */
    @JvmName("wjwyyuxvlhwnkscf")
    public suspend fun capacity(`value`: ScaleCapacityArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param argument the number of instances that can be used during this profile.
     */
    @JvmName("jccemfhdoqqtudmi")
    public suspend fun capacity(argument: suspend ScaleCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = ScaleCapacityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacity = mapped
    }

    /**
     * @param value the specific date-time for the profile. This element is not used if the Recurrence element is used.
     */
    @JvmName("wwgdkglypqhblswr")
    public suspend fun fixedDate(`value`: TimeWindowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixedDate = mapped
    }

    /**
     * @param argument the specific date-time for the profile. This element is not used if the Recurrence element is used.
     */
    @JvmName("vkhcmovvbmjqgebl")
    public suspend fun fixedDate(argument: suspend TimeWindowArgsBuilder.() -> Unit) {
        val toBeMapped = TimeWindowArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fixedDate = mapped
    }

    /**
     * @param value the name of the profile.
     */
    @JvmName("jjtqmdmtmjfaytog")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
     */
    @JvmName("wrhhqcmnhyhbnnfg")
    public suspend fun recurrence(`value`: RecurrenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param argument the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
     */
    @JvmName("nwoqlektoljwrmwv")
    public suspend fun recurrence(argument: suspend RecurrenceArgsBuilder.() -> Unit) {
        val toBeMapped = RecurrenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recurrence = mapped
    }

    /**
     * @param value the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
     */
    @JvmName("huwlvwfeifihrqdr")
    public suspend fun rules(`value`: List<ScaleRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
     */
    @JvmName("yawhjnkmrpigeeuw")
    public suspend fun rules(argument: List<suspend ScaleRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ScaleRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
     */
    @JvmName("tshkodsmkefskhre")
    public suspend fun rules(vararg argument: suspend ScaleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ScaleRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
     */
    @JvmName("mtwljkykufbtghoo")
    public suspend fun rules(argument: suspend ScaleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScaleRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
     */
    @JvmName("ojgbeowqnsditydx")
    public suspend fun rules(vararg values: ScaleRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): AutoscaleProfileArgs = AutoscaleProfileArgs(
        capacity = capacity ?: throw PulumiNullFieldException("capacity"),
        fixedDate = fixedDate,
        name = name ?: throw PulumiNullFieldException("name"),
        recurrence = recurrence,
        rules = rules ?: throw PulumiNullFieldException("rules"),
    )
}
