@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ColumnDefinitionArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.KnownColumnDefinitionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of custom data column.
 * @property name The name of the column.
 * @property type The type of the column data.
 */
public data class ColumnDefinitionArgs(
    public val name: Output<String>? = null,
    public val type: Output<Either<String, KnownColumnDefinitionType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ColumnDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ColumnDefinitionArgs =
        com.pulumi.azurenative.insights.inputs.ColumnDefinitionArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ColumnDefinitionArgs].
 */
@PulumiTagMarker
public class ColumnDefinitionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<Either<String, KnownColumnDefinitionType>>? = null

    /**
     * @param value The name of the column.
     */
    @JvmName("ygwqamfpjmjlwdft")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of the column data.
     */
    @JvmName("smnwmkbifddehhij")
    public suspend fun type(`value`: Output<Either<String, KnownColumnDefinitionType>>) {
        this.type = value
    }

    /**
     * @param value The name of the column.
     */
    @JvmName("cyelbflhyndvtayb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of the column data.
     */
    @JvmName("vuavjcbsdrbphyfy")
    public suspend fun type(`value`: Either<String, KnownColumnDefinitionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the column data.
     */
    @JvmName("frlbpscbgmsmxyrj")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KnownColumnDefinitionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the column data.
     */
    @JvmName("weqhataylgxyrulv")
    public fun type(`value`: KnownColumnDefinitionType) {
        val toBeMapped = Either.ofRight<String, KnownColumnDefinitionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ColumnDefinitionArgs = ColumnDefinitionArgs(
        name = name,
        type = type,
    )
}
