@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ConditionArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.ConditionOperator
import com.pulumi.azurenative.insights.kotlin.enums.TimeAggregation
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A condition of the scheduled query rule.
 * @property dimensions List of Dimensions conditions
 * @property failingPeriods The minimum number of violations required within the selected lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
 * @property metricMeasureColumn The column containing the metric measure number. Relevant only for rules of the kind LogAlert.
 * @property metricName The name of the metric to be sent. Relevant and required only for rules of the kind LogToMetric.
 * @property operator The criteria operator. Relevant and required only for rules of the kind LogAlert.
 * @property query Log query alert
 * @property resourceIdColumn The column containing the resource id. The content of the column must be a uri formatted as resource id. Relevant only for rules of the kind LogAlert.
 * @property threshold the criteria threshold value that activates the alert. Relevant and required only for rules of the kind LogAlert.
 * @property timeAggregation Aggregation type. Relevant and required only for rules of the kind LogAlert.
 */
public data class ConditionArgs(
    public val dimensions: Output<List<DimensionArgs>>? = null,
    public val failingPeriods: Output<ConditionFailingPeriodsArgs>? = null,
    public val metricMeasureColumn: Output<String>? = null,
    public val metricName: Output<String>? = null,
    public val `operator`: Output<Either<String, ConditionOperator>>? = null,
    public val query: Output<String>? = null,
    public val resourceIdColumn: Output<String>? = null,
    public val threshold: Output<Double>? = null,
    public val timeAggregation: Output<Either<String, TimeAggregation>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ConditionArgs =
        com.pulumi.azurenative.insights.inputs.ConditionArgs.builder()
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .failingPeriods(failingPeriods?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .metricMeasureColumn(metricMeasureColumn?.applyValue({ args0 -> args0 }))
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .query(query?.applyValue({ args0 -> args0 }))
            .resourceIdColumn(resourceIdColumn?.applyValue({ args0 -> args0 }))
            .threshold(threshold?.applyValue({ args0 -> args0 }))
            .timeAggregation(
                timeAggregation?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConditionArgs].
 */
@PulumiTagMarker
public class ConditionArgsBuilder internal constructor() {
    private var dimensions: Output<List<DimensionArgs>>? = null

    private var failingPeriods: Output<ConditionFailingPeriodsArgs>? = null

    private var metricMeasureColumn: Output<String>? = null

    private var metricName: Output<String>? = null

    private var `operator`: Output<Either<String, ConditionOperator>>? = null

    private var query: Output<String>? = null

    private var resourceIdColumn: Output<String>? = null

    private var threshold: Output<Double>? = null

    private var timeAggregation: Output<Either<String, TimeAggregation>>? = null

    /**
     * @param value List of Dimensions conditions
     */
    @JvmName("trrasycpbjqtdphp")
    public suspend fun dimensions(`value`: Output<List<DimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("ivcbpdjovdbsvtfg")
    public suspend fun dimensions(vararg values: Output<DimensionArgs>) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values List of Dimensions conditions
     */
    @JvmName("fxdcyfxnluxobbvq")
    public suspend fun dimensions(values: List<Output<DimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value The minimum number of violations required within the selected lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("yuoljdbusvyahkxn")
    public suspend fun failingPeriods(`value`: Output<ConditionFailingPeriodsArgs>) {
        this.failingPeriods = value
    }

    /**
     * @param value The column containing the metric measure number. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("gsqrrgiiftvxnaqx")
    public suspend fun metricMeasureColumn(`value`: Output<String>) {
        this.metricMeasureColumn = value
    }

    /**
     * @param value The name of the metric to be sent. Relevant and required only for rules of the kind LogToMetric.
     */
    @JvmName("sdkkjyotlhiceqse")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The criteria operator. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("ndifqwrwlbjqvnux")
    public suspend fun `operator`(`value`: Output<Either<String, ConditionOperator>>) {
        this.`operator` = value
    }

    /**
     * @param value Log query alert
     */
    @JvmName("vuytdkkoyynisuiw")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value The column containing the resource id. The content of the column must be a uri formatted as resource id. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("eitrqbynjrbyalgv")
    public suspend fun resourceIdColumn(`value`: Output<String>) {
        this.resourceIdColumn = value
    }

    /**
     * @param value the criteria threshold value that activates the alert. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("vdhgltyqmwteahcm")
    public suspend fun threshold(`value`: Output<Double>) {
        this.threshold = value
    }

    /**
     * @param value Aggregation type. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("ftdjtawnygjbjyus")
    public suspend fun timeAggregation(`value`: Output<Either<String, TimeAggregation>>) {
        this.timeAggregation = value
    }

    /**
     * @param value List of Dimensions conditions
     */
    @JvmName("vqtfyurkvneqgfkm")
    public suspend fun dimensions(`value`: List<DimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument List of Dimensions conditions
     */
    @JvmName("eyljnauodgwfnfwg")
    public suspend fun dimensions(argument: List<suspend DimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DimensionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument List of Dimensions conditions
     */
    @JvmName("qgjmyvisdtemqcip")
    public suspend fun dimensions(vararg argument: suspend DimensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DimensionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument List of Dimensions conditions
     */
    @JvmName("vimfhvshgoifwjmn")
    public suspend fun dimensions(argument: suspend DimensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DimensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values List of Dimensions conditions
     */
    @JvmName("qpeiuqfnadkuoptm")
    public suspend fun dimensions(vararg values: DimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value The minimum number of violations required within the selected lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("ienqcuafnnanhbtc")
    public suspend fun failingPeriods(`value`: ConditionFailingPeriodsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failingPeriods = mapped
    }

    /**
     * @param argument The minimum number of violations required within the selected lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("aibmwwopipfrpmdo")
    public suspend fun failingPeriods(argument: suspend ConditionFailingPeriodsArgsBuilder.() -> Unit) {
        val toBeMapped = ConditionFailingPeriodsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.failingPeriods = mapped
    }

    /**
     * @param value The column containing the metric measure number. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("erlydfnxtaibahfv")
    public suspend fun metricMeasureColumn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricMeasureColumn = mapped
    }

    /**
     * @param value The name of the metric to be sent. Relevant and required only for rules of the kind LogToMetric.
     */
    @JvmName("mkwfequslrryeoro")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The criteria operator. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("onhslheeclgshkuw")
    public suspend fun `operator`(`value`: Either<String, ConditionOperator>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The criteria operator. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("pdsambpjkwiavsyd")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConditionOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The criteria operator. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("lwcwboyrdamxdkod")
    public fun `operator`(`value`: ConditionOperator) {
        val toBeMapped = Either.ofRight<String, ConditionOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Log query alert
     */
    @JvmName("xhmldjtmkokkmcrf")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value The column containing the resource id. The content of the column must be a uri formatted as resource id. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("nudcmfrjppyybbtk")
    public suspend fun resourceIdColumn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceIdColumn = mapped
    }

    /**
     * @param value the criteria threshold value that activates the alert. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("fisgsgxuarrheyxt")
    public suspend fun threshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value Aggregation type. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("mtmbtiquwreravhb")
    public suspend fun timeAggregation(`value`: Either<String, TimeAggregation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeAggregation = mapped
    }

    /**
     * @param value Aggregation type. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("eblwnswrxfoptafu")
    public fun timeAggregation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TimeAggregation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeAggregation = mapped
    }

    /**
     * @param value Aggregation type. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("yhkviqujoxgeycto")
    public fun timeAggregation(`value`: TimeAggregation) {
        val toBeMapped = Either.ofRight<String, TimeAggregation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeAggregation = mapped
    }

    internal fun build(): ConditionArgs = ConditionArgs(
        dimensions = dimensions,
        failingPeriods = failingPeriods,
        metricMeasureColumn = metricMeasureColumn,
        metricName = metricName,
        `operator` = `operator`,
        query = query,
        resourceIdColumn = resourceIdColumn,
        threshold = threshold,
        timeAggregation = timeAggregation,
    )
}
