@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ConditionFailingPeriodsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The minimum number of violations required within the selected lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
 * @property minFailingPeriodsToAlert The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods. Default value is 1
 * @property numberOfEvaluationPeriods The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points. Default value is 1
 */
public data class ConditionFailingPeriodsArgs(
    public val minFailingPeriodsToAlert: Output<Double>? = null,
    public val numberOfEvaluationPeriods: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ConditionFailingPeriodsArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ConditionFailingPeriodsArgs =
        com.pulumi.azurenative.insights.inputs.ConditionFailingPeriodsArgs.builder()
            .minFailingPeriodsToAlert(minFailingPeriodsToAlert?.applyValue({ args0 -> args0 }))
            .numberOfEvaluationPeriods(numberOfEvaluationPeriods?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConditionFailingPeriodsArgs].
 */
@PulumiTagMarker
public class ConditionFailingPeriodsArgsBuilder internal constructor() {
    private var minFailingPeriodsToAlert: Output<Double>? = null

    private var numberOfEvaluationPeriods: Output<Double>? = null

    /**
     * @param value The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods. Default value is 1
     */
    @JvmName("xxxmrcvtvmythhnn")
    public suspend fun minFailingPeriodsToAlert(`value`: Output<Double>) {
        this.minFailingPeriodsToAlert = value
    }

    /**
     * @param value The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points. Default value is 1
     */
    @JvmName("xqqmuxalildmhrga")
    public suspend fun numberOfEvaluationPeriods(`value`: Output<Double>) {
        this.numberOfEvaluationPeriods = value
    }

    /**
     * @param value The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods. Default value is 1
     */
    @JvmName("tcjxithtwfvfujyu")
    public suspend fun minFailingPeriodsToAlert(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minFailingPeriodsToAlert = mapped
    }

    /**
     * @param value The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points. Default value is 1
     */
    @JvmName("gwasdqigwxacdean")
    public suspend fun numberOfEvaluationPeriods(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfEvaluationPeriods = mapped
    }

    internal fun build(): ConditionFailingPeriodsArgs = ConditionFailingPeriodsArgs(
        minFailingPeriodsToAlert = minFailingPeriodsToAlert,
        numberOfEvaluationPeriods = numberOfEvaluationPeriods,
    )
}
