@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.DataCollectionEndpointNetworkAclsArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.KnownPublicNetworkAccessOptions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network access control rules for the endpoints.
 * @property publicNetworkAccess The configuration to set whether network access from public internet to the endpoints are allowed.
 */
public data class DataCollectionEndpointNetworkAclsArgs(
    public val publicNetworkAccess: Output<Either<String, KnownPublicNetworkAccessOptions>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.DataCollectionEndpointNetworkAclsArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.DataCollectionEndpointNetworkAclsArgs =
        com.pulumi.azurenative.insights.inputs.DataCollectionEndpointNetworkAclsArgs.builder()
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [DataCollectionEndpointNetworkAclsArgs].
 */
@PulumiTagMarker
public class DataCollectionEndpointNetworkAclsArgsBuilder internal constructor() {
    private var publicNetworkAccess: Output<Either<String, KnownPublicNetworkAccessOptions>>? = null

    /**
     * @param value The configuration to set whether network access from public internet to the endpoints are allowed.
     */
    @JvmName("acphofrbdowqqbca")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, KnownPublicNetworkAccessOptions>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The configuration to set whether network access from public internet to the endpoints are allowed.
     */
    @JvmName("rggpqbacdcxsjbau")
    public suspend fun publicNetworkAccess(`value`: Either<String, KnownPublicNetworkAccessOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The configuration to set whether network access from public internet to the endpoints are allowed.
     */
    @JvmName("vcuvxmghwsvmqevk")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KnownPublicNetworkAccessOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The configuration to set whether network access from public internet to the endpoints are allowed.
     */
    @JvmName("usuxcmpduoshbpgw")
    public fun publicNetworkAccess(`value`: KnownPublicNetworkAccessOptions) {
        val toBeMapped = Either.ofRight<String, KnownPublicNetworkAccessOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    internal fun build(): DataCollectionEndpointNetworkAclsArgs =
        DataCollectionEndpointNetworkAclsArgs(
            publicNetworkAccess = publicNetworkAccess,
        )
}
