@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.DataCollectionRuleDataSourcesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The specification of data sources.
 * This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
 * @property dataImports Specifications of pull based data sources
 * @property extensions The list of Azure VM extension data source configurations.
 * @property iisLogs The list of IIS logs source configurations.
 * @property logFiles The list of Log files source configurations.
 * @property performanceCounters The list of performance counter data source configurations.
 * @property platformTelemetry The list of platform telemetry configurations
 * @property prometheusForwarder The list of Prometheus forwarder data source configurations.
 * @property syslog The list of Syslog data source configurations.
 * @property windowsEventLogs The list of Windows Event Log data source configurations.
 * @property windowsFirewallLogs The list of Windows Firewall logs source configurations.
 */
public data class DataCollectionRuleDataSourcesArgs(
    public val dataImports: Output<DataSourcesSpecDataImportsArgs>? = null,
    public val extensions: Output<List<ExtensionDataSourceArgs>>? = null,
    public val iisLogs: Output<List<IisLogsDataSourceArgs>>? = null,
    public val logFiles: Output<List<LogFilesDataSourceArgs>>? = null,
    public val performanceCounters: Output<List<PerfCounterDataSourceArgs>>? = null,
    public val platformTelemetry: Output<List<PlatformTelemetryDataSourceArgs>>? = null,
    public val prometheusForwarder: Output<List<PrometheusForwarderDataSourceArgs>>? = null,
    public val syslog: Output<List<SyslogDataSourceArgs>>? = null,
    public val windowsEventLogs: Output<List<WindowsEventLogDataSourceArgs>>? = null,
    public val windowsFirewallLogs: Output<List<WindowsFirewallLogsDataSourceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.DataCollectionRuleDataSourcesArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.DataCollectionRuleDataSourcesArgs =
        com.pulumi.azurenative.insights.inputs.DataCollectionRuleDataSourcesArgs.builder()
            .dataImports(dataImports?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extensions(
                extensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .iisLogs(
                iisLogs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .logFiles(
                logFiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .performanceCounters(
                performanceCounters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .platformTelemetry(
                platformTelemetry?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .prometheusForwarder(
                prometheusForwarder?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .syslog(syslog?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .windowsEventLogs(
                windowsEventLogs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .windowsFirewallLogs(
                windowsFirewallLogs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataCollectionRuleDataSourcesArgs].
 */
@PulumiTagMarker
public class DataCollectionRuleDataSourcesArgsBuilder internal constructor() {
    private var dataImports: Output<DataSourcesSpecDataImportsArgs>? = null

    private var extensions: Output<List<ExtensionDataSourceArgs>>? = null

    private var iisLogs: Output<List<IisLogsDataSourceArgs>>? = null

    private var logFiles: Output<List<LogFilesDataSourceArgs>>? = null

    private var performanceCounters: Output<List<PerfCounterDataSourceArgs>>? = null

    private var platformTelemetry: Output<List<PlatformTelemetryDataSourceArgs>>? = null

    private var prometheusForwarder: Output<List<PrometheusForwarderDataSourceArgs>>? = null

    private var syslog: Output<List<SyslogDataSourceArgs>>? = null

    private var windowsEventLogs: Output<List<WindowsEventLogDataSourceArgs>>? = null

    private var windowsFirewallLogs: Output<List<WindowsFirewallLogsDataSourceArgs>>? = null

    /**
     * @param value Specifications of pull based data sources
     */
    @JvmName("usjvmvpyaikdeeif")
    public suspend fun dataImports(`value`: Output<DataSourcesSpecDataImportsArgs>) {
        this.dataImports = value
    }

    /**
     * @param value The list of Azure VM extension data source configurations.
     */
    @JvmName("vionmctbaddxxgxi")
    public suspend fun extensions(`value`: Output<List<ExtensionDataSourceArgs>>) {
        this.extensions = value
    }

    @JvmName("vieagveksikquuxr")
    public suspend fun extensions(vararg values: Output<ExtensionDataSourceArgs>) {
        this.extensions = Output.all(values.asList())
    }

    /**
     * @param values The list of Azure VM extension data source configurations.
     */
    @JvmName("oinmxjehxlovncoa")
    public suspend fun extensions(values: List<Output<ExtensionDataSourceArgs>>) {
        this.extensions = Output.all(values)
    }

    /**
     * @param value The list of IIS logs source configurations.
     */
    @JvmName("mmdnjnmfxhdfcvwy")
    public suspend fun iisLogs(`value`: Output<List<IisLogsDataSourceArgs>>) {
        this.iisLogs = value
    }

    @JvmName("ahgbiskehjgnewci")
    public suspend fun iisLogs(vararg values: Output<IisLogsDataSourceArgs>) {
        this.iisLogs = Output.all(values.asList())
    }

    /**
     * @param values The list of IIS logs source configurations.
     */
    @JvmName("pmarekubaipjcnqa")
    public suspend fun iisLogs(values: List<Output<IisLogsDataSourceArgs>>) {
        this.iisLogs = Output.all(values)
    }

    /**
     * @param value The list of Log files source configurations.
     */
    @JvmName("jlmqvewlxiprbmsi")
    public suspend fun logFiles(`value`: Output<List<LogFilesDataSourceArgs>>) {
        this.logFiles = value
    }

    @JvmName("qdpxvhxbruqkxmnn")
    public suspend fun logFiles(vararg values: Output<LogFilesDataSourceArgs>) {
        this.logFiles = Output.all(values.asList())
    }

    /**
     * @param values The list of Log files source configurations.
     */
    @JvmName("bcmwfqiofhrpvitn")
    public suspend fun logFiles(values: List<Output<LogFilesDataSourceArgs>>) {
        this.logFiles = Output.all(values)
    }

    /**
     * @param value The list of performance counter data source configurations.
     */
    @JvmName("qhlqurcaqfeupsur")
    public suspend fun performanceCounters(`value`: Output<List<PerfCounterDataSourceArgs>>) {
        this.performanceCounters = value
    }

    @JvmName("ltwbircnnekmpiql")
    public suspend fun performanceCounters(vararg values: Output<PerfCounterDataSourceArgs>) {
        this.performanceCounters = Output.all(values.asList())
    }

    /**
     * @param values The list of performance counter data source configurations.
     */
    @JvmName("tdkqrvqwbxtchitq")
    public suspend fun performanceCounters(values: List<Output<PerfCounterDataSourceArgs>>) {
        this.performanceCounters = Output.all(values)
    }

    /**
     * @param value The list of platform telemetry configurations
     */
    @JvmName("mjbhalrgbhjpbigb")
    public suspend fun platformTelemetry(`value`: Output<List<PlatformTelemetryDataSourceArgs>>) {
        this.platformTelemetry = value
    }

    @JvmName("hiblxnuyxsciouag")
    public suspend fun platformTelemetry(vararg values: Output<PlatformTelemetryDataSourceArgs>) {
        this.platformTelemetry = Output.all(values.asList())
    }

    /**
     * @param values The list of platform telemetry configurations
     */
    @JvmName("abfblycwxxbubrjj")
    public suspend fun platformTelemetry(values: List<Output<PlatformTelemetryDataSourceArgs>>) {
        this.platformTelemetry = Output.all(values)
    }

    /**
     * @param value The list of Prometheus forwarder data source configurations.
     */
    @JvmName("isftqyyvpqawchry")
    public suspend fun prometheusForwarder(`value`: Output<List<PrometheusForwarderDataSourceArgs>>) {
        this.prometheusForwarder = value
    }

    @JvmName("omqmvikgspljttis")
    public suspend fun prometheusForwarder(vararg values: Output<PrometheusForwarderDataSourceArgs>) {
        this.prometheusForwarder = Output.all(values.asList())
    }

    /**
     * @param values The list of Prometheus forwarder data source configurations.
     */
    @JvmName("lvfjhkruhvbvapwm")
    public suspend fun prometheusForwarder(values: List<Output<PrometheusForwarderDataSourceArgs>>) {
        this.prometheusForwarder = Output.all(values)
    }

    /**
     * @param value The list of Syslog data source configurations.
     */
    @JvmName("dayxyworbhhgactk")
    public suspend fun syslog(`value`: Output<List<SyslogDataSourceArgs>>) {
        this.syslog = value
    }

    @JvmName("ouyvyaeivvwswylv")
    public suspend fun syslog(vararg values: Output<SyslogDataSourceArgs>) {
        this.syslog = Output.all(values.asList())
    }

    /**
     * @param values The list of Syslog data source configurations.
     */
    @JvmName("yhijqpkbgjbrdwkg")
    public suspend fun syslog(values: List<Output<SyslogDataSourceArgs>>) {
        this.syslog = Output.all(values)
    }

    /**
     * @param value The list of Windows Event Log data source configurations.
     */
    @JvmName("jpcvfmeyumyyjwrx")
    public suspend fun windowsEventLogs(`value`: Output<List<WindowsEventLogDataSourceArgs>>) {
        this.windowsEventLogs = value
    }

    @JvmName("sdwshgnvgdcplirl")
    public suspend fun windowsEventLogs(vararg values: Output<WindowsEventLogDataSourceArgs>) {
        this.windowsEventLogs = Output.all(values.asList())
    }

    /**
     * @param values The list of Windows Event Log data source configurations.
     */
    @JvmName("riwpvyinexombyte")
    public suspend fun windowsEventLogs(values: List<Output<WindowsEventLogDataSourceArgs>>) {
        this.windowsEventLogs = Output.all(values)
    }

    /**
     * @param value The list of Windows Firewall logs source configurations.
     */
    @JvmName("ukadgaxecailnxel")
    public suspend fun windowsFirewallLogs(`value`: Output<List<WindowsFirewallLogsDataSourceArgs>>) {
        this.windowsFirewallLogs = value
    }

    @JvmName("sorkcndwpdmhsdeb")
    public suspend fun windowsFirewallLogs(vararg values: Output<WindowsFirewallLogsDataSourceArgs>) {
        this.windowsFirewallLogs = Output.all(values.asList())
    }

    /**
     * @param values The list of Windows Firewall logs source configurations.
     */
    @JvmName("pmqtsiakqyntslgm")
    public suspend fun windowsFirewallLogs(values: List<Output<WindowsFirewallLogsDataSourceArgs>>) {
        this.windowsFirewallLogs = Output.all(values)
    }

    /**
     * @param value Specifications of pull based data sources
     */
    @JvmName("ssgwhdtmavvipavf")
    public suspend fun dataImports(`value`: DataSourcesSpecDataImportsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataImports = mapped
    }

    /**
     * @param argument Specifications of pull based data sources
     */
    @JvmName("qrduaqfkccldncli")
    public suspend fun dataImports(argument: suspend DataSourcesSpecDataImportsArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourcesSpecDataImportsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataImports = mapped
    }

    /**
     * @param value The list of Azure VM extension data source configurations.
     */
    @JvmName("lgphpgnanxtigckd")
    public suspend fun extensions(`value`: List<ExtensionDataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param argument The list of Azure VM extension data source configurations.
     */
    @JvmName("unhqmriviyouqovg")
    public suspend fun extensions(argument: List<suspend ExtensionDataSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExtensionDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument The list of Azure VM extension data source configurations.
     */
    @JvmName("uhncrfjspvgflgwg")
    public suspend fun extensions(vararg argument: suspend ExtensionDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExtensionDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument The list of Azure VM extension data source configurations.
     */
    @JvmName("jbfnnfgkddfuyjxp")
    public suspend fun extensions(argument: suspend ExtensionDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExtensionDataSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param values The list of Azure VM extension data source configurations.
     */
    @JvmName("rxykpsfbmmsrgegj")
    public suspend fun extensions(vararg values: ExtensionDataSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param value The list of IIS logs source configurations.
     */
    @JvmName("klqquevocqhcwodo")
    public suspend fun iisLogs(`value`: List<IisLogsDataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iisLogs = mapped
    }

    /**
     * @param argument The list of IIS logs source configurations.
     */
    @JvmName("nhkvjisdkqirqbtu")
    public suspend fun iisLogs(argument: List<suspend IisLogsDataSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IisLogsDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iisLogs = mapped
    }

    /**
     * @param argument The list of IIS logs source configurations.
     */
    @JvmName("qjdrtohuyyprakcu")
    public suspend fun iisLogs(vararg argument: suspend IisLogsDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IisLogsDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.iisLogs = mapped
    }

    /**
     * @param argument The list of IIS logs source configurations.
     */
    @JvmName("tirnnqjjamjydmbb")
    public suspend fun iisLogs(argument: suspend IisLogsDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IisLogsDataSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.iisLogs = mapped
    }

    /**
     * @param values The list of IIS logs source configurations.
     */
    @JvmName("yaomwyiuojjddpuc")
    public suspend fun iisLogs(vararg values: IisLogsDataSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iisLogs = mapped
    }

    /**
     * @param value The list of Log files source configurations.
     */
    @JvmName("dqkqwsdixocxyivx")
    public suspend fun logFiles(`value`: List<LogFilesDataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logFiles = mapped
    }

    /**
     * @param argument The list of Log files source configurations.
     */
    @JvmName("tgpcksscsyshhwyp")
    public suspend fun logFiles(argument: List<suspend LogFilesDataSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LogFilesDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logFiles = mapped
    }

    /**
     * @param argument The list of Log files source configurations.
     */
    @JvmName("hlbwmrfbhapxggqv")
    public suspend fun logFiles(vararg argument: suspend LogFilesDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LogFilesDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logFiles = mapped
    }

    /**
     * @param argument The list of Log files source configurations.
     */
    @JvmName("nifnpsdvoyyfjnji")
    public suspend fun logFiles(argument: suspend LogFilesDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LogFilesDataSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.logFiles = mapped
    }

    /**
     * @param values The list of Log files source configurations.
     */
    @JvmName("rjsfeglawvtlkbdo")
    public suspend fun logFiles(vararg values: LogFilesDataSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logFiles = mapped
    }

    /**
     * @param value The list of performance counter data source configurations.
     */
    @JvmName("dmsqfjwgdroyoyrt")
    public suspend fun performanceCounters(`value`: List<PerfCounterDataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceCounters = mapped
    }

    /**
     * @param argument The list of performance counter data source configurations.
     */
    @JvmName("aqjdlvnmwqbfxtli")
    public suspend fun performanceCounters(argument: List<suspend PerfCounterDataSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PerfCounterDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.performanceCounters = mapped
    }

    /**
     * @param argument The list of performance counter data source configurations.
     */
    @JvmName("dbclwmlatoeowswo")
    public suspend fun performanceCounters(vararg argument: suspend PerfCounterDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PerfCounterDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.performanceCounters = mapped
    }

    /**
     * @param argument The list of performance counter data source configurations.
     */
    @JvmName("ikeybdcmnyoficds")
    public suspend fun performanceCounters(argument: suspend PerfCounterDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PerfCounterDataSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.performanceCounters = mapped
    }

    /**
     * @param values The list of performance counter data source configurations.
     */
    @JvmName("jncxyxsewxmfekbm")
    public suspend fun performanceCounters(vararg values: PerfCounterDataSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.performanceCounters = mapped
    }

    /**
     * @param value The list of platform telemetry configurations
     */
    @JvmName("sksdlubedsgwjkxk")
    public suspend fun platformTelemetry(`value`: List<PlatformTelemetryDataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformTelemetry = mapped
    }

    /**
     * @param argument The list of platform telemetry configurations
     */
    @JvmName("qybcemndscvtmvqi")
    public suspend fun platformTelemetry(argument: List<suspend PlatformTelemetryDataSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PlatformTelemetryDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.platformTelemetry = mapped
    }

    /**
     * @param argument The list of platform telemetry configurations
     */
    @JvmName("iphghvojrmoewupq")
    public suspend fun platformTelemetry(vararg argument: suspend PlatformTelemetryDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PlatformTelemetryDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.platformTelemetry = mapped
    }

    /**
     * @param argument The list of platform telemetry configurations
     */
    @JvmName("xempegrgxymhluai")
    public suspend fun platformTelemetry(argument: suspend PlatformTelemetryDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PlatformTelemetryDataSourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.platformTelemetry = mapped
    }

    /**
     * @param values The list of platform telemetry configurations
     */
    @JvmName("kgsvpgtxvqukukjt")
    public suspend fun platformTelemetry(vararg values: PlatformTelemetryDataSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.platformTelemetry = mapped
    }

    /**
     * @param value The list of Prometheus forwarder data source configurations.
     */
    @JvmName("esqnegaoliqtljwj")
    public suspend fun prometheusForwarder(`value`: List<PrometheusForwarderDataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prometheusForwarder = mapped
    }

    /**
     * @param argument The list of Prometheus forwarder data source configurations.
     */
    @JvmName("xjnkppimfclhqscp")
    public suspend fun prometheusForwarder(argument: List<suspend PrometheusForwarderDataSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrometheusForwarderDataSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.prometheusForwarder = mapped
    }

    /**
     * @param argument The list of Prometheus forwarder data source configurations.
     */
    @JvmName("diutmrebxmsdhxxt")
    public suspend fun prometheusForwarder(vararg argument: suspend PrometheusForwarderDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PrometheusForwarderDataSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.prometheusForwarder = mapped
    }

    /**
     * @param argument The list of Prometheus forwarder data source configurations.
     */
    @JvmName("rsokdwnfkxltdsmr")
    public suspend fun prometheusForwarder(argument: suspend PrometheusForwarderDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrometheusForwarderDataSourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.prometheusForwarder = mapped
    }

    /**
     * @param values The list of Prometheus forwarder data source configurations.
     */
    @JvmName("kfeigduhvfwpyonr")
    public suspend fun prometheusForwarder(vararg values: PrometheusForwarderDataSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prometheusForwarder = mapped
    }

    /**
     * @param value The list of Syslog data source configurations.
     */
    @JvmName("gahqbbeyltggqcvv")
    public suspend fun syslog(`value`: List<SyslogDataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syslog = mapped
    }

    /**
     * @param argument The list of Syslog data source configurations.
     */
    @JvmName("yrgaktmkbbvyeljk")
    public suspend fun syslog(argument: List<suspend SyslogDataSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SyslogDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.syslog = mapped
    }

    /**
     * @param argument The list of Syslog data source configurations.
     */
    @JvmName("rtpnaarexrntkohe")
    public suspend fun syslog(vararg argument: suspend SyslogDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SyslogDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.syslog = mapped
    }

    /**
     * @param argument The list of Syslog data source configurations.
     */
    @JvmName("ntgvoufkhwvnmexf")
    public suspend fun syslog(argument: suspend SyslogDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SyslogDataSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.syslog = mapped
    }

    /**
     * @param values The list of Syslog data source configurations.
     */
    @JvmName("ktfgkayvvlurmhdf")
    public suspend fun syslog(vararg values: SyslogDataSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syslog = mapped
    }

    /**
     * @param value The list of Windows Event Log data source configurations.
     */
    @JvmName("nspdkdppgamxenue")
    public suspend fun windowsEventLogs(`value`: List<WindowsEventLogDataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsEventLogs = mapped
    }

    /**
     * @param argument The list of Windows Event Log data source configurations.
     */
    @JvmName("ugmdbskkubudjwcp")
    public suspend fun windowsEventLogs(argument: List<suspend WindowsEventLogDataSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WindowsEventLogDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.windowsEventLogs = mapped
    }

    /**
     * @param argument The list of Windows Event Log data source configurations.
     */
    @JvmName("djjwxevtpqulecwj")
    public suspend fun windowsEventLogs(vararg argument: suspend WindowsEventLogDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WindowsEventLogDataSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.windowsEventLogs = mapped
    }

    /**
     * @param argument The list of Windows Event Log data source configurations.
     */
    @JvmName("bpgnwccfdwnogpcq")
    public suspend fun windowsEventLogs(argument: suspend WindowsEventLogDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WindowsEventLogDataSourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.windowsEventLogs = mapped
    }

    /**
     * @param values The list of Windows Event Log data source configurations.
     */
    @JvmName("sjoapajnjhbskyvx")
    public suspend fun windowsEventLogs(vararg values: WindowsEventLogDataSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.windowsEventLogs = mapped
    }

    /**
     * @param value The list of Windows Firewall logs source configurations.
     */
    @JvmName("pxittelfqtlwjnix")
    public suspend fun windowsFirewallLogs(`value`: List<WindowsFirewallLogsDataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsFirewallLogs = mapped
    }

    /**
     * @param argument The list of Windows Firewall logs source configurations.
     */
    @JvmName("dhbasgxoovyfkbqp")
    public suspend fun windowsFirewallLogs(argument: List<suspend WindowsFirewallLogsDataSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WindowsFirewallLogsDataSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.windowsFirewallLogs = mapped
    }

    /**
     * @param argument The list of Windows Firewall logs source configurations.
     */
    @JvmName("gtdqofdhbahuwgvo")
    public suspend fun windowsFirewallLogs(vararg argument: suspend WindowsFirewallLogsDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WindowsFirewallLogsDataSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.windowsFirewallLogs = mapped
    }

    /**
     * @param argument The list of Windows Firewall logs source configurations.
     */
    @JvmName("cllshaoerjnwaojt")
    public suspend fun windowsFirewallLogs(argument: suspend WindowsFirewallLogsDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WindowsFirewallLogsDataSourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.windowsFirewallLogs = mapped
    }

    /**
     * @param values The list of Windows Firewall logs source configurations.
     */
    @JvmName("dumileflixvkbswt")
    public suspend fun windowsFirewallLogs(vararg values: WindowsFirewallLogsDataSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.windowsFirewallLogs = mapped
    }

    internal fun build(): DataCollectionRuleDataSourcesArgs = DataCollectionRuleDataSourcesArgs(
        dataImports = dataImports,
        extensions = extensions,
        iisLogs = iisLogs,
        logFiles = logFiles,
        performanceCounters = performanceCounters,
        platformTelemetry = platformTelemetry,
        prometheusForwarder = prometheusForwarder,
        syslog = syslog,
        windowsEventLogs = windowsEventLogs,
        windowsFirewallLogs = windowsFirewallLogs,
    )
}
