@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.DataSourceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property eventLogs Windows event logs configuration.
 * @property perfCounters Performance counter configuration
 * @property providers ETW providers configuration
 */
public data class DataSourceConfigurationArgs(
    public val eventLogs: Output<List<EventLogConfigurationArgs>>? = null,
    public val perfCounters: Output<List<PerformanceCounterConfigurationArgs>>? = null,
    public val providers: Output<List<EtwProviderConfigurationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.DataSourceConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.DataSourceConfigurationArgs =
        com.pulumi.azurenative.insights.inputs.DataSourceConfigurationArgs.builder()
            .eventLogs(
                eventLogs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .perfCounters(
                perfCounters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .providers(
                providers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSourceConfigurationArgs].
 */
@PulumiTagMarker
public class DataSourceConfigurationArgsBuilder internal constructor() {
    private var eventLogs: Output<List<EventLogConfigurationArgs>>? = null

    private var perfCounters: Output<List<PerformanceCounterConfigurationArgs>>? = null

    private var providers: Output<List<EtwProviderConfigurationArgs>>? = null

    /**
     * @param value Windows event logs configuration.
     */
    @JvmName("kefllevnwfvmxekt")
    public suspend fun eventLogs(`value`: Output<List<EventLogConfigurationArgs>>) {
        this.eventLogs = value
    }

    @JvmName("ppcuqwhedwhvneju")
    public suspend fun eventLogs(vararg values: Output<EventLogConfigurationArgs>) {
        this.eventLogs = Output.all(values.asList())
    }

    /**
     * @param values Windows event logs configuration.
     */
    @JvmName("xlbnnfruraelnthc")
    public suspend fun eventLogs(values: List<Output<EventLogConfigurationArgs>>) {
        this.eventLogs = Output.all(values)
    }

    /**
     * @param value Performance counter configuration
     */
    @JvmName("lwftgfwtjyyaunpf")
    public suspend fun perfCounters(`value`: Output<List<PerformanceCounterConfigurationArgs>>) {
        this.perfCounters = value
    }

    @JvmName("bwaeaqhksvchorto")
    public suspend fun perfCounters(vararg values: Output<PerformanceCounterConfigurationArgs>) {
        this.perfCounters = Output.all(values.asList())
    }

    /**
     * @param values Performance counter configuration
     */
    @JvmName("kisqwbcsyyttmmcg")
    public suspend fun perfCounters(values: List<Output<PerformanceCounterConfigurationArgs>>) {
        this.perfCounters = Output.all(values)
    }

    /**
     * @param value ETW providers configuration
     */
    @JvmName("usmgnmrouhmhrmpv")
    public suspend fun providers(`value`: Output<List<EtwProviderConfigurationArgs>>) {
        this.providers = value
    }

    @JvmName("dfxfsddpvndgikgv")
    public suspend fun providers(vararg values: Output<EtwProviderConfigurationArgs>) {
        this.providers = Output.all(values.asList())
    }

    /**
     * @param values ETW providers configuration
     */
    @JvmName("wcoffewpgbyeeuty")
    public suspend fun providers(values: List<Output<EtwProviderConfigurationArgs>>) {
        this.providers = Output.all(values)
    }

    /**
     * @param value Windows event logs configuration.
     */
    @JvmName("asteovrhyvkxenwg")
    public suspend fun eventLogs(`value`: List<EventLogConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventLogs = mapped
    }

    /**
     * @param argument Windows event logs configuration.
     */
    @JvmName("srkqvnhvuldmnxjx")
    public suspend fun eventLogs(argument: List<suspend EventLogConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventLogConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventLogs = mapped
    }

    /**
     * @param argument Windows event logs configuration.
     */
    @JvmName("rfxvmmgbfkghaslt")
    public suspend fun eventLogs(vararg argument: suspend EventLogConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventLogConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventLogs = mapped
    }

    /**
     * @param argument Windows event logs configuration.
     */
    @JvmName("lueiltdbgauoppel")
    public suspend fun eventLogs(argument: suspend EventLogConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EventLogConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.eventLogs = mapped
    }

    /**
     * @param values Windows event logs configuration.
     */
    @JvmName("syejoubnwgchlspb")
    public suspend fun eventLogs(vararg values: EventLogConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventLogs = mapped
    }

    /**
     * @param value Performance counter configuration
     */
    @JvmName("phrgekhqddnrsfxs")
    public suspend fun perfCounters(`value`: List<PerformanceCounterConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perfCounters = mapped
    }

    /**
     * @param argument Performance counter configuration
     */
    @JvmName("xfvyamjfxbqhevks")
    public suspend fun perfCounters(argument: List<suspend PerformanceCounterConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PerformanceCounterConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.perfCounters = mapped
    }

    /**
     * @param argument Performance counter configuration
     */
    @JvmName("livfbagnmpkmeocj")
    public suspend fun perfCounters(vararg argument: suspend PerformanceCounterConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PerformanceCounterConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.perfCounters = mapped
    }

    /**
     * @param argument Performance counter configuration
     */
    @JvmName("asulbxntxppqwibi")
    public suspend fun perfCounters(argument: suspend PerformanceCounterConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PerformanceCounterConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.perfCounters = mapped
    }

    /**
     * @param values Performance counter configuration
     */
    @JvmName("ehbatykliaikcqno")
    public suspend fun perfCounters(vararg values: PerformanceCounterConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.perfCounters = mapped
    }

    /**
     * @param value ETW providers configuration
     */
    @JvmName("pyqybioexbmpsoyd")
    public suspend fun providers(`value`: List<EtwProviderConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providers = mapped
    }

    /**
     * @param argument ETW providers configuration
     */
    @JvmName("jxcmlgbvqjfqecku")
    public suspend fun providers(argument: List<suspend EtwProviderConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EtwProviderConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.providers = mapped
    }

    /**
     * @param argument ETW providers configuration
     */
    @JvmName("ttnvekpwwderjywm")
    public suspend fun providers(vararg argument: suspend EtwProviderConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EtwProviderConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.providers = mapped
    }

    /**
     * @param argument ETW providers configuration
     */
    @JvmName("inhfpktxxqkibbag")
    public suspend fun providers(argument: suspend EtwProviderConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EtwProviderConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.providers = mapped
    }

    /**
     * @param values ETW providers configuration
     */
    @JvmName("mfhqmoiysshiblqb")
    public suspend fun providers(vararg values: EtwProviderConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providers = mapped
    }

    internal fun build(): DataSourceConfigurationArgs = DataSourceConfigurationArgs(
        eventLogs = eventLogs,
        perfCounters = perfCounters,
        providers = providers,
    )
}
