@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetActionGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property actionGroupName The name of the action group.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetActionGroupPlainArgs(
    public val actionGroupName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetActionGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetActionGroupPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetActionGroupPlainArgs.builder()
            .actionGroupName(actionGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetActionGroupPlainArgs].
 */
@PulumiTagMarker
public class GetActionGroupPlainArgsBuilder internal constructor() {
    private var actionGroupName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the action group.
     */
    @JvmName("ussyeknimumfylkt")
    public suspend fun actionGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.actionGroupName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uaspmnhicvjntpki")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetActionGroupPlainArgs = GetActionGroupPlainArgs(
        actionGroupName = actionGroupName ?: throw PulumiNullFieldException("actionGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
