@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetDataCollectionEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataCollectionEndpointName The name of the data collection endpoint. The name is case insensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDataCollectionEndpointPlainArgs(
    public val dataCollectionEndpointName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetDataCollectionEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetDataCollectionEndpointPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetDataCollectionEndpointPlainArgs.builder()
            .dataCollectionEndpointName(dataCollectionEndpointName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataCollectionEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetDataCollectionEndpointPlainArgsBuilder internal constructor() {
    private var dataCollectionEndpointName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the data collection endpoint. The name is case insensitive.
     */
    @JvmName("oticubnbhwmmifyw")
    public suspend fun dataCollectionEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataCollectionEndpointName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nltyscwkwuxdebnd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDataCollectionEndpointPlainArgs = GetDataCollectionEndpointPlainArgs(
        dataCollectionEndpointName = dataCollectionEndpointName ?: throw
            PulumiNullFieldException("dataCollectionEndpointName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
