@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetDiagnosticServiceTokenReadWritePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceUri The identifier of the resource.
 */
public data class GetDiagnosticServiceTokenReadWritePlainArgs(
    public val resourceUri: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetDiagnosticServiceTokenReadWritePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetDiagnosticServiceTokenReadWritePlainArgs =
        com.pulumi.azurenative.insights.inputs.GetDiagnosticServiceTokenReadWritePlainArgs.builder()
            .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiagnosticServiceTokenReadWritePlainArgs].
 */
@PulumiTagMarker
public class GetDiagnosticServiceTokenReadWritePlainArgsBuilder internal constructor() {
    private var resourceUri: String? = null

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("nbgecvvucvigjfnv")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): GetDiagnosticServiceTokenReadWritePlainArgs =
        GetDiagnosticServiceTokenReadWritePlainArgs(
            resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
        )
}
