@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetDiagnosticSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the diagnostic setting.
 * @property resourceUri The identifier of the resource.
 */
public data class GetDiagnosticSettingPlainArgs(
    public val name: String,
    public val resourceUri: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetDiagnosticSettingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetDiagnosticSettingPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetDiagnosticSettingPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiagnosticSettingPlainArgs].
 */
@PulumiTagMarker
public class GetDiagnosticSettingPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceUri: String? = null

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("mvwxxjlvsfcfwtfr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("sifqymqbhqrdwusw")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): GetDiagnosticSettingPlainArgs = GetDiagnosticSettingPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
    )
}
