@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetGuestDiagnosticsSettingsAssociationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property associationName The name of the diagnostic settings association.
 * @property resourceUri The fully qualified ID of the resource, including the resource name and resource type.
 */
public data class GetGuestDiagnosticsSettingsAssociationPlainArgs(
    public val associationName: String,
    public val resourceUri: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetGuestDiagnosticsSettingsAssociationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetGuestDiagnosticsSettingsAssociationPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetGuestDiagnosticsSettingsAssociationPlainArgs.builder()
            .associationName(associationName.let({ args0 -> args0 }))
            .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGuestDiagnosticsSettingsAssociationPlainArgs].
 */
@PulumiTagMarker
public class GetGuestDiagnosticsSettingsAssociationPlainArgsBuilder internal constructor() {
    private var associationName: String? = null

    private var resourceUri: String? = null

    /**
     * @param value The name of the diagnostic settings association.
     */
    @JvmName("ymstxtmfurkkctok")
    public suspend fun associationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.associationName = mapped
    }

    /**
     * @param value The fully qualified ID of the resource, including the resource name and resource type.
     */
    @JvmName("qflhisgogunmrxxi")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): GetGuestDiagnosticsSettingsAssociationPlainArgs =
        GetGuestDiagnosticsSettingsAssociationPlainArgs(
            associationName = associationName ?: throw PulumiNullFieldException("associationName"),
            resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
        )
}
