@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetPrivateLinkScopedResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the scoped resource object.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scopeName The name of the Azure Monitor PrivateLinkScope resource.
 */
public data class GetPrivateLinkScopedResourcePlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val scopeName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetPrivateLinkScopedResourcePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetPrivateLinkScopedResourcePlainArgs =
        com.pulumi.azurenative.insights.inputs.GetPrivateLinkScopedResourcePlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .scopeName(scopeName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateLinkScopedResourcePlainArgs].
 */
@PulumiTagMarker
public class GetPrivateLinkScopedResourcePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var scopeName: String? = null

    /**
     * @param value The name of the scoped resource object.
     */
    @JvmName("kkasbxogkgoiwkhl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dlqbpnykmdpdqcpu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Monitor PrivateLinkScope resource.
     */
    @JvmName("icblwymnuwnadwgl")
    public suspend fun scopeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scopeName = mapped
    }

    internal fun build(): GetPrivateLinkScopedResourcePlainArgs =
        GetPrivateLinkScopedResourcePlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            scopeName = scopeName ?: throw PulumiNullFieldException("scopeName"),
        )
}
