@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetScheduledQueryRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleName The name of the rule.
 */
public data class GetScheduledQueryRulePlainArgs(
    public val resourceGroupName: String,
    public val ruleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetScheduledQueryRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetScheduledQueryRulePlainArgs =
        com.pulumi.azurenative.insights.inputs.GetScheduledQueryRulePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleName(ruleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScheduledQueryRulePlainArgs].
 */
@PulumiTagMarker
public class GetScheduledQueryRulePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var ruleName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ohnybenugsepmflg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("oejnifgvtriganxc")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleName = mapped
    }

    internal fun build(): GetScheduledQueryRulePlainArgs = GetScheduledQueryRulePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
    )
}
