@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetWebTestPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property webTestName The name of the Application Insights WebTest resource.
 */
public data class GetWebTestPlainArgs(
    public val resourceGroupName: String,
    public val webTestName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetWebTestPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetWebTestPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetWebTestPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .webTestName(webTestName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebTestPlainArgs].
 */
@PulumiTagMarker
public class GetWebTestPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var webTestName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mmbbpngxilntxemy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Application Insights WebTest resource.
     */
    @JvmName("yuvyowvakxtfssii")
    public suspend fun webTestName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.webTestName = mapped
    }

    internal fun build(): GetWebTestPlainArgs = GetWebTestPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        webTestName = webTestName ?: throw PulumiNullFieldException("webTestName"),
    )
}
