@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.MetricAlertSingleResourceMultipleMetricCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies the metric alert criteria for a single resource that has multiple metric criteria.
 * @property allOf The list of metric criteria for this 'all of' operation.
 * @property odataType specifies the type of the alert criteria.
 * Expected value is 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria'.
 */
public data class MetricAlertSingleResourceMultipleMetricCriteriaArgs(
    public val allOf: Output<List<MetricCriteriaArgs>>? = null,
    public val odataType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.MetricAlertSingleResourceMultipleMetricCriteriaArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.MetricAlertSingleResourceMultipleMetricCriteriaArgs =
        com.pulumi.azurenative.insights.inputs.MetricAlertSingleResourceMultipleMetricCriteriaArgs.builder()
            .allOf(allOf?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricAlertSingleResourceMultipleMetricCriteriaArgs].
 */
@PulumiTagMarker
public class MetricAlertSingleResourceMultipleMetricCriteriaArgsBuilder internal constructor() {
    private var allOf: Output<List<MetricCriteriaArgs>>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value The list of metric criteria for this 'all of' operation.
     */
    @JvmName("xhceedtnyuusllwn")
    public suspend fun allOf(`value`: Output<List<MetricCriteriaArgs>>) {
        this.allOf = value
    }

    @JvmName("xrpehmoabosxhsls")
    public suspend fun allOf(vararg values: Output<MetricCriteriaArgs>) {
        this.allOf = Output.all(values.asList())
    }

    /**
     * @param values The list of metric criteria for this 'all of' operation.
     */
    @JvmName("dheiwvussnfclvul")
    public suspend fun allOf(values: List<Output<MetricCriteriaArgs>>) {
        this.allOf = Output.all(values)
    }

    /**
     * @param value specifies the type of the alert criteria.
     * Expected value is 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria'.
     */
    @JvmName("ihiktieeasvagrau")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The list of metric criteria for this 'all of' operation.
     */
    @JvmName("bnruwmqktismaesc")
    public suspend fun allOf(`value`: List<MetricCriteriaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allOf = mapped
    }

    /**
     * @param argument The list of metric criteria for this 'all of' operation.
     */
    @JvmName("dpybcfbktqpdxwiq")
    public suspend fun allOf(argument: List<suspend MetricCriteriaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricCriteriaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.allOf = mapped
    }

    /**
     * @param argument The list of metric criteria for this 'all of' operation.
     */
    @JvmName("ryiotgohpuatdfvr")
    public suspend fun allOf(vararg argument: suspend MetricCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetricCriteriaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.allOf = mapped
    }

    /**
     * @param argument The list of metric criteria for this 'all of' operation.
     */
    @JvmName("krhnugnkopmllhcp")
    public suspend fun allOf(argument: suspend MetricCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetricCriteriaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.allOf = mapped
    }

    /**
     * @param values The list of metric criteria for this 'all of' operation.
     */
    @JvmName("oxjaiqpobnkxmodk")
    public suspend fun allOf(vararg values: MetricCriteriaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allOf = mapped
    }

    /**
     * @param value specifies the type of the alert criteria.
     * Expected value is 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria'.
     */
    @JvmName("wquotqdyjyxpojtl")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): MetricAlertSingleResourceMultipleMetricCriteriaArgs =
        MetricAlertSingleResourceMultipleMetricCriteriaArgs(
            allOf = allOf,
            odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        )
}
