@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.MetricSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
 * @property category Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a GET diagnostic settings operation.
 * @property enabled a value indicating whether this category is enabled.
 * @property retentionPolicy the retention policy for this category.
 * @property timeGrain the timegrain of the metric in ISO8601 format.
 */
public data class MetricSettingsArgs(
    public val category: Output<String>? = null,
    public val enabled: Output<Boolean>,
    public val retentionPolicy: Output<RetentionPolicyArgs>? = null,
    public val timeGrain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.MetricSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.MetricSettingsArgs =
        com.pulumi.azurenative.insights.inputs.MetricSettingsArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .retentionPolicy(retentionPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeGrain(timeGrain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricSettingsArgs].
 */
@PulumiTagMarker
public class MetricSettingsArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var retentionPolicy: Output<RetentionPolicyArgs>? = null

    private var timeGrain: Output<String>? = null

    /**
     * @param value Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a GET diagnostic settings operation.
     */
    @JvmName("rdoaklmoqascafbj")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value a value indicating whether this category is enabled.
     */
    @JvmName("cqaimvwkenskesgn")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value the retention policy for this category.
     */
    @JvmName("oncxqlwgrmtpplrl")
    public suspend fun retentionPolicy(`value`: Output<RetentionPolicyArgs>) {
        this.retentionPolicy = value
    }

    /**
     * @param value the timegrain of the metric in ISO8601 format.
     */
    @JvmName("brtnpwwgospytbli")
    public suspend fun timeGrain(`value`: Output<String>) {
        this.timeGrain = value
    }

    /**
     * @param value Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a GET diagnostic settings operation.
     */
    @JvmName("kmyemgxauliseyam")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value a value indicating whether this category is enabled.
     */
    @JvmName("fsnpeombnyueeqhv")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value the retention policy for this category.
     */
    @JvmName("ktxqvkdbxiicmrhf")
    public suspend fun retentionPolicy(`value`: RetentionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param argument the retention policy for this category.
     */
    @JvmName("pujoeoipasxaywab")
    public suspend fun retentionPolicy(argument: suspend RetentionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionPolicy = mapped
    }

    /**
     * @param value the timegrain of the metric in ISO8601 format.
     */
    @JvmName("sjglbkqfllacjnpu")
    public suspend fun timeGrain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeGrain = mapped
    }

    internal fun build(): MetricSettingsArgs = MetricSettingsArgs(
        category = category,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        retentionPolicy = retentionPolicy,
        timeGrain = timeGrain,
    )
}
