@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.RecurrenceArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.RecurrenceFrequency
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The repeating times at which this profile begins. This element is not used if the FixedDate element is used.
 * @property frequency the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.
 * @property schedule the scheduling constraints for when the profile begins.
 */
public data class RecurrenceArgs(
    public val frequency: Output<RecurrenceFrequency>,
    public val schedule: Output<RecurrentScheduleArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.RecurrenceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.RecurrenceArgs =
        com.pulumi.azurenative.insights.inputs.RecurrenceArgs.builder()
            .frequency(frequency.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schedule(schedule.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RecurrenceArgs].
 */
@PulumiTagMarker
public class RecurrenceArgsBuilder internal constructor() {
    private var frequency: Output<RecurrenceFrequency>? = null

    private var schedule: Output<RecurrentScheduleArgs>? = null

    /**
     * @param value the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.
     */
    @JvmName("yfmeeedbdqriklik")
    public suspend fun frequency(`value`: Output<RecurrenceFrequency>) {
        this.frequency = value
    }

    /**
     * @param value the scheduling constraints for when the profile begins.
     */
    @JvmName("fhwsnnuqnsscuraw")
    public suspend fun schedule(`value`: Output<RecurrentScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.
     */
    @JvmName("hsjofhdcqparjnlh")
    public suspend fun frequency(`value`: RecurrenceFrequency) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value the scheduling constraints for when the profile begins.
     */
    @JvmName("tikgeenrjvxguagv")
    public suspend fun schedule(`value`: RecurrentScheduleArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument the scheduling constraints for when the profile begins.
     */
    @JvmName("hedkkwgkuftuwcda")
    public suspend fun schedule(argument: suspend RecurrentScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = RecurrentScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    internal fun build(): RecurrenceArgs = RecurrenceArgs(
        frequency = frequency ?: throw PulumiNullFieldException("frequency"),
        schedule = schedule ?: throw PulumiNullFieldException("schedule"),
    )
}
