@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.RuleMetricDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A rule metric data source. The discriminator value is always RuleMetricDataSource in this case.
 * @property legacyResourceId the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
 * @property metricName the name of the metric that defines what the rule monitors.
 * @property metricNamespace the namespace of the metric.
 * @property odataType specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource'.
 * @property resourceLocation the location of the resource.
 * @property resourceUri the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
 */
public data class RuleMetricDataSourceArgs(
    public val legacyResourceId: Output<String>? = null,
    public val metricName: Output<String>? = null,
    public val metricNamespace: Output<String>? = null,
    public val odataType: Output<String>,
    public val resourceLocation: Output<String>? = null,
    public val resourceUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.RuleMetricDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.RuleMetricDataSourceArgs =
        com.pulumi.azurenative.insights.inputs.RuleMetricDataSourceArgs.builder()
            .legacyResourceId(legacyResourceId?.applyValue({ args0 -> args0 }))
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .metricNamespace(metricNamespace?.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .resourceLocation(resourceLocation?.applyValue({ args0 -> args0 }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleMetricDataSourceArgs].
 */
@PulumiTagMarker
public class RuleMetricDataSourceArgsBuilder internal constructor() {
    private var legacyResourceId: Output<String>? = null

    private var metricName: Output<String>? = null

    private var metricNamespace: Output<String>? = null

    private var odataType: Output<String>? = null

    private var resourceLocation: Output<String>? = null

    private var resourceUri: Output<String>? = null

    /**
     * @param value the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
     */
    @JvmName("ddhlfpkspnlmheht")
    public suspend fun legacyResourceId(`value`: Output<String>) {
        this.legacyResourceId = value
    }

    /**
     * @param value the name of the metric that defines what the rule monitors.
     */
    @JvmName("yjjiwolqfcaibivb")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value the namespace of the metric.
     */
    @JvmName("nuyienkkboxtyeqo")
    public suspend fun metricNamespace(`value`: Output<String>) {
        this.metricNamespace = value
    }

    /**
     * @param value specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource'.
     */
    @JvmName("sissdwmhuagkkhsm")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value the location of the resource.
     */
    @JvmName("tfwxijofyayvgdur")
    public suspend fun resourceLocation(`value`: Output<String>) {
        this.resourceLocation = value
    }

    /**
     * @param value the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
     */
    @JvmName("gkxmmegniyuyjqge")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
     */
    @JvmName("qvevsottmfoxthpq")
    public suspend fun legacyResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.legacyResourceId = mapped
    }

    /**
     * @param value the name of the metric that defines what the rule monitors.
     */
    @JvmName("ilyjpqtjuvwftxwh")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value the namespace of the metric.
     */
    @JvmName("tbuvmscncebjtkjv")
    public suspend fun metricNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricNamespace = mapped
    }

    /**
     * @param value specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource'.
     */
    @JvmName("brwxdjkhnkeochnn")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value the location of the resource.
     */
    @JvmName("hncfypfvpmqjqyhl")
    public suspend fun resourceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLocation = mapped
    }

    /**
     * @param value the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
     */
    @JvmName("pdndbmbfbogcieeu")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    internal fun build(): RuleMetricDataSourceArgs = RuleMetricDataSourceArgs(
        legacyResourceId = legacyResourceId,
        metricName = metricName,
        metricNamespace = metricNamespace,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        resourceLocation = resourceLocation,
        resourceUri = resourceUri,
    )
}
