@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ScaleRuleMetricDimensionArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.ScaleRuleMetricDimensionOperationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies an auto scale rule metric dimension.
 * @property dimensionName Name of the dimension.
 * @property operator the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
 * @property values list of dimension values. For example: ["App1","App2"].
 */
public data class ScaleRuleMetricDimensionArgs(
    public val dimensionName: Output<String>,
    public val `operator`: Output<Either<String, ScaleRuleMetricDimensionOperationType>>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ScaleRuleMetricDimensionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ScaleRuleMetricDimensionArgs =
        com.pulumi.azurenative.insights.inputs.ScaleRuleMetricDimensionArgs.builder()
            .dimensionName(dimensionName.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ScaleRuleMetricDimensionArgs].
 */
@PulumiTagMarker
public class ScaleRuleMetricDimensionArgsBuilder internal constructor() {
    private var dimensionName: Output<String>? = null

    private var `operator`: Output<Either<String, ScaleRuleMetricDimensionOperationType>>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Name of the dimension.
     */
    @JvmName("htsgkfsthsgcqvec")
    public suspend fun dimensionName(`value`: Output<String>) {
        this.dimensionName = value
    }

    /**
     * @param value the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
     */
    @JvmName("atvwrjenarchmgxp")
    public suspend fun `operator`(`value`: Output<Either<String, ScaleRuleMetricDimensionOperationType>>) {
        this.`operator` = value
    }

    /**
     * @param value list of dimension values. For example: ["App1","App2"].
     */
    @JvmName("wtqgqcdggumjmmpd")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("dsfbobmjkvnvicsj")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values list of dimension values. For example: ["App1","App2"].
     */
    @JvmName("xteuaybiahsqchsg")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Name of the dimension.
     */
    @JvmName("ikwppbswmcdkhwkt")
    public suspend fun dimensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensionName = mapped
    }

    /**
     * @param value the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
     */
    @JvmName("hngfytcmeyjlnrdg")
    public suspend fun `operator`(`value`: Either<String, ScaleRuleMetricDimensionOperationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
     */
    @JvmName("pbjmlmtdpjuikjco")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScaleRuleMetricDimensionOperationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
     */
    @JvmName("gfkbwxxoplwjbnmy")
    public fun `operator`(`value`: ScaleRuleMetricDimensionOperationType) {
        val toBeMapped = Either.ofRight<String, ScaleRuleMetricDimensionOperationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value list of dimension values. For example: ["App1","App2"].
     */
    @JvmName("evlaqdpxmcdddcxe")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values list of dimension values. For example: ["App1","App2"].
     */
    @JvmName("uqmspyigglpfbxqa")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ScaleRuleMetricDimensionArgs = ScaleRuleMetricDimensionArgs(
        dimensionName = dimensionName ?: throw PulumiNullFieldException("dimensionName"),
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
