@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ScheduledQueryRuleCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The rule criteria that defines the conditions of the scheduled query rule.
 * @property allOf A list of conditions to evaluate against the specified scopes
 */
public data class ScheduledQueryRuleCriteriaArgs(
    public val allOf: Output<List<ConditionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ScheduledQueryRuleCriteriaArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ScheduledQueryRuleCriteriaArgs =
        com.pulumi.azurenative.insights.inputs.ScheduledQueryRuleCriteriaArgs.builder()
            .allOf(
                allOf?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScheduledQueryRuleCriteriaArgs].
 */
@PulumiTagMarker
public class ScheduledQueryRuleCriteriaArgsBuilder internal constructor() {
    private var allOf: Output<List<ConditionArgs>>? = null

    /**
     * @param value A list of conditions to evaluate against the specified scopes
     */
    @JvmName("kvdnjgjwteocjvtd")
    public suspend fun allOf(`value`: Output<List<ConditionArgs>>) {
        this.allOf = value
    }

    @JvmName("dcyljvmgxiywcytq")
    public suspend fun allOf(vararg values: Output<ConditionArgs>) {
        this.allOf = Output.all(values.asList())
    }

    /**
     * @param values A list of conditions to evaluate against the specified scopes
     */
    @JvmName("uohyyvelkwxtmwgm")
    public suspend fun allOf(values: List<Output<ConditionArgs>>) {
        this.allOf = Output.all(values)
    }

    /**
     * @param value A list of conditions to evaluate against the specified scopes
     */
    @JvmName("ocxspmraaaurwlch")
    public suspend fun allOf(`value`: List<ConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allOf = mapped
    }

    /**
     * @param argument A list of conditions to evaluate against the specified scopes
     */
    @JvmName("bvqlktotnoxmirjt")
    public suspend fun allOf(argument: List<suspend ConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ConditionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.allOf = mapped
    }

    /**
     * @param argument A list of conditions to evaluate against the specified scopes
     */
    @JvmName("xkqadkhycbkeqxjm")
    public suspend fun allOf(vararg argument: suspend ConditionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ConditionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.allOf = mapped
    }

    /**
     * @param argument A list of conditions to evaluate against the specified scopes
     */
    @JvmName("lcsjqegdrxuptyoh")
    public suspend fun allOf(argument: suspend ConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ConditionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.allOf = mapped
    }

    /**
     * @param values A list of conditions to evaluate against the specified scopes
     */
    @JvmName("iyuclosywxhytqlg")
    public suspend fun allOf(vararg values: ConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allOf = mapped
    }

    internal fun build(): ScheduledQueryRuleCriteriaArgs = ScheduledQueryRuleCriteriaArgs(
        allOf = allOf,
    )
}
